/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.elections;

import com.tangosol.internal.sleepycat.je.rep.elections.Elections;
import com.tangosol.internal.sleepycat.je.rep.elections.Proposer;
import com.tangosol.internal.sleepycat.je.rep.elections.Protocol;
import com.tangosol.internal.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.tangosol.internal.sleepycat.je.rep.impl.TextProtocol;
import com.tangosol.internal.sleepycat.je.rep.impl.node.NameIdPair;
import com.tangosol.internal.sleepycat.je.utilint.LoggerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RankingProposer
extends Proposer {
    static volatile int testLogVersionReplicatePrevious = 0;
    private final TimebasedProposalGenerator proposalGenerator = new TimebasedProposalGenerator();

    public RankingProposer(Elections elections, NameIdPair nameIdPair) {
        super(elections, nameIdPair);
    }

    @Override
    protected Protocol.Value choosePhase2Value(Set<TextProtocol.MessageExchange> exchanges) {
        long maxRanking = Long.MIN_VALUE;
        int maxPriority = Integer.MIN_VALUE;
        String maxTarget = null;
        int zeroPrioNodes = 0;
        VersionCalculator calculator = new VersionCalculator(this.elections, exchanges);
        Protocol.Value acceptorValue = null;
        for (TextProtocol.MessageExchange me : exchanges) {
            if (me.getResponseMessage().getOp() != this.elections.getProtocol().PROMISE) continue;
            Protocol.Promise p = (Protocol.Promise)me.getResponseMessage();
            if (p.getPriority() == 0) {
                ++zeroPrioNodes;
                continue;
            }
            if (calculator.skipPromiseDueToVersion(p.getLogVersion()) || p.getSuggestionRanking() < maxRanking || p.getSuggestionRanking() == maxRanking && (p.getPriority() < maxPriority || p.getPriority() == maxPriority && maxTarget != null && me.target.toString().compareTo(maxTarget) <= 0)) continue;
            acceptorValue = p.getSuggestion();
            maxRanking = p.getSuggestionRanking();
            maxPriority = p.getPriority();
            maxTarget = me.target.toString();
        }
        if (acceptorValue == null && zeroPrioNodes > 0) {
            LoggerUtils.logMsg(this.logger, this.elections.getRepImpl(), this.formatter, Level.INFO, "No positive election priority node responded. Zero election priority node count:" + zeroPrioNodes);
            this.phase1NoNonZeroPrio.increment();
        }
        return acceptorValue;
    }

    @Override
    public synchronized Proposer.Proposal nextProposal() {
        return this.proposalGenerator.nextProposal();
    }

    private static class VersionCalculator {
        private final Set<TextProtocol.MessageExchange> exchanges;
        private final Elections elections;
        private int majorityVersion = Integer.MIN_VALUE;
        private int lowestVersion = Integer.MAX_VALUE;
        private boolean singleVersion = false;

        public VersionCalculator(Elections elections, Set<TextProtocol.MessageExchange> exchanges) {
            this.exchanges = exchanges;
            this.elections = elections;
            this.calculate();
        }

        private void calculate() {
            HashMap<Integer, Integer> logFormats = new HashMap<Integer, Integer>();
            for (TextProtocol.MessageExchange me : this.exchanges) {
                if (me.getResponseMessage().getOp() != this.elections.getProtocol().PROMISE) continue;
                Protocol.Promise p = (Protocol.Promise)me.getResponseMessage();
                if (p.getLogVersion() < this.lowestVersion) {
                    this.lowestVersion = p.getLogVersion();
                }
                if (!logFormats.containsKey(p.getLogVersion())) {
                    logFormats.put(p.getLogVersion(), 1);
                    continue;
                }
                logFormats.put(p.getLogVersion(), (Integer)logFormats.get(p.getLogVersion()) + 1);
            }
            if (logFormats.size() == 1) {
                this.singleVersion = true;
                return;
            }
            if (this.elections.getRepNode() == null) {
                return;
            }
            int electableNodeCount = this.elections.getRepNode().getGroup().getElectableGroupSize();
            for (Map.Entry entry : logFormats.entrySet()) {
                if ((Integer)entry.getValue() <= electableNodeCount / 2) continue;
                this.majorityVersion = (Integer)entry.getKey();
                break;
            }
        }

        boolean skipPromiseDueToVersion(int logVersion) {
            if (this.singleVersion) {
                return false;
            }
            int logVersionReplicatePrevious = testLogVersionReplicatePrevious;
            if (logVersionReplicatePrevious == 0) {
                logVersionReplicatePrevious = 9;
            }
            if (this.lowestVersion >= logVersionReplicatePrevious - 1) {
                return false;
            }
            return this.majorityVersion == Integer.MIN_VALUE && logVersion != this.lowestVersion || this.majorityVersion != Integer.MIN_VALUE && logVersion != this.lowestVersion && logVersion != this.majorityVersion;
        }
    }
}

