/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.impl.node;

import com.tangosol.internal.sleepycat.je.rep.elections.Proposer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class CommitFreezeLatch {
    private Proposer.Proposal proposal = null;
    private int freezeCount = 0;
    private int awaitTimeoutCount = 0;
    private int awaitElectionCount = 0;
    private CountDownLatch latch = null;
    private long freezeEnd = 0L;
    private long timeOut = DEFAULT_LATCH_TIMEOUT;
    private static long DEFAULT_LATCH_TIMEOUT = 5000L;

    public int getAwaitTimeoutCount() {
        return this.awaitTimeoutCount;
    }

    public int getAwaitElectionCount() {
        return this.awaitElectionCount;
    }

    public int getFreezeCount() {
        return this.freezeCount;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public synchronized void freeze(Proposer.Proposal freezeProposal) {
        if (this.proposal != null && freezeProposal.compareTo(this.proposal) <= 0) {
            return;
        }
        if (this.latch != null) {
            this.latch.countDown();
        }
        this.latch = new CountDownLatch(1);
        this.proposal = freezeProposal;
        this.freezeEnd = System.currentTimeMillis() + this.timeOut;
    }

    public synchronized void vlsnEvent(Proposer.Proposal listenerProposal) {
        if (this.proposal == null) {
            return;
        }
        if (listenerProposal.compareTo(this.proposal) >= 0) {
            this.latch.countDown();
        }
    }

    public synchronized void clearLatch() {
        if (this.latch != null) {
            this.latch.countDown();
        }
        this.latch = null;
        this.proposal = null;
        this.freezeEnd = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitThaw() throws InterruptedException {
        long awaitTimeout;
        CountDownLatch awaitLatch;
        CommitFreezeLatch commitFreezeLatch = this;
        synchronized (commitFreezeLatch) {
            awaitLatch = this.latch;
            if (awaitLatch == null) {
                return false;
            }
            awaitTimeout = this.freezeEnd - System.currentTimeMillis();
        }
        ++this.freezeCount;
        boolean done = awaitLatch.await(awaitTimeout, TimeUnit.MILLISECONDS);
        CommitFreezeLatch commitFreezeLatch2 = this;
        synchronized (commitFreezeLatch2) {
            if (done) {
                ++this.awaitElectionCount;
                this.clearLatch();
                return true;
            }
            if (this.freezeEnd - System.currentTimeMillis() <= 0L) {
                ++this.awaitTimeoutCount;
                this.clearLatch();
                return false;
            }
        }
        return this.awaitThaw();
    }
}

