/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.util.ldiff;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.rep.util.ldiff.LDiffUtil;
import com.tangosol.internal.sleepycat.je.utilint.Adler32;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class Window {
    private final Cursor cursor;
    private List<byte[]> window;
    private final MessageDigest md;
    private final int windowSize;
    private long chksum;
    private byte[] beginKey;
    private byte[] beginData;
    private long diffSize;

    public Window(Cursor cursor, int windowSize) throws Exception {
        this.cursor = cursor;
        this.windowSize = windowSize;
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception("MD5 hashes are required for ldiff.");
        }
        this.nextWindow();
    }

    public void rollWindow() throws Exception {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        if (this.cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            byte[] keyValue = LDiffUtil.concatByteArray(key.getData(), data.getData());
            int removeXi = LDiffUtil.getXi(this.window.remove(0));
            this.window.add(keyValue);
            int addXi = LDiffUtil.getXi(keyValue);
            this.rollChecksum(removeXi, addXi);
        } else {
            this.chksum = 0L;
        }
        ++this.diffSize;
    }

    public void nextWindow() {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        this.window = new ArrayList<byte[]>();
        this.diffSize = 0L;
        for (int i = 0; i < this.windowSize && this.cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS; ++i) {
            if (i == 0) {
                this.beginKey = key.getData();
                this.beginData = data.getData();
            }
            this.window.add(LDiffUtil.concatByteArray(key.getData(), data.getData()));
        }
        this.setChecksum();
    }

    public long getChecksum() {
        return this.chksum;
    }

    public byte[] getBeginKey() {
        return this.beginKey;
    }

    public byte[] getBeginData() {
        return this.beginData;
    }

    public long getDiffSize() {
        return this.diffSize;
    }

    public byte[] getMd5Hash() {
        this.md.reset();
        for (byte[] ba : this.window) {
            this.md.update(ba);
        }
        return this.md.digest();
    }

    public int size() {
        return this.window.size();
    }

    private void setChecksum() {
        Adler32 adler32 = new Adler32();
        int a = 0;
        int b = 0;
        for (int i = 0; i < this.size(); ++i) {
            byte[] element = this.window.get(i);
            adler32.reset();
            adler32.update(element, 0, element.length);
            int xi = (int)adler32.getValue();
            a += xi;
            b += xi * (this.size() - i);
        }
        this.chksum = (long)a & 0xFFFFFFFFL | (long)b << 32;
    }

    private void rollChecksum(int removeXi, int addXi) {
        int a = (int)this.chksum - removeXi + addXi;
        int b = (int)(this.chksum >> 32) - removeXi * this.size() + a;
        this.chksum = (long)a & 0xFFFFFFFFL | (long)b << 32;
    }
}

