/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.rep.vlsn;

import com.tangosol.internal.sleepycat.bind.tuple.LongBinding;
import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DbInternal;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.LockMode;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.dbi.DatabaseImpl;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentImpl;
import com.tangosol.internal.sleepycat.je.rep.vlsn.GhostBucket;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNBucket;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNIndexStatDefinition;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNRange;
import com.tangosol.internal.sleepycat.je.rep.vlsn.VLSNRecoveryTracker;
import com.tangosol.internal.sleepycat.je.txn.BasicLocker;
import com.tangosol.internal.sleepycat.je.txn.Locker;
import com.tangosol.internal.sleepycat.je.txn.Txn;
import com.tangosol.internal.sleepycat.je.utilint.DbLsn;
import com.tangosol.internal.sleepycat.je.utilint.LongStat;
import com.tangosol.internal.sleepycat.je.utilint.StatGroup;
import com.tangosol.internal.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

class VLSNTracker {
    private final EnvironmentImpl envImpl;
    private VLSN firstTrackedVLSN;
    private VLSN lastOnDiskVLSN;
    SortedMap<Long, VLSNBucket> bucketCache;
    protected volatile VLSNRange range;
    private boolean rangeTruncated;
    private final int stride;
    private final int maxMappings;
    private final int maxDistance;
    private final LongStat nBucketsCreated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VLSNTracker(EnvironmentImpl envImpl, DatabaseImpl mappingDbImpl, int stride, int maxMappings, int maxDistance, StatGroup statistics) throws DatabaseException {
        block7: {
            this.firstTrackedVLSN = VLSN.NULL_VLSN;
            this.lastOnDiskVLSN = VLSN.NULL_VLSN;
            this.stride = stride;
            this.maxMappings = maxMappings;
            this.maxDistance = maxDistance;
            this.envImpl = envImpl;
            this.nBucketsCreated = new LongStat(statistics, VLSNIndexStatDefinition.N_BUCKETS_CREATED);
            this.bucketCache = new TreeMap<Long, VLSNBucket>();
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LongBinding.longToEntry(-1L, key);
            Cursor cursor = null;
            BasicLocker locker = null;
            try {
                locker = BasicLocker.createBasicLocker(envImpl);
                cursor = DbInternal.makeCursor(mappingDbImpl, locker, CursorConfig.DEFAULT);
                DbInternal.getCursorImpl(cursor).setAllowEviction(false);
                OperationStatus status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    VLSNRange.VLSNRangeBinding rangeBinding = new VLSNRange.VLSNRangeBinding();
                    this.range = (VLSNRange)rangeBinding.entryToObject(data);
                    this.lastOnDiskVLSN = this.range.getLast();
                    break block7;
                }
                if (status == OperationStatus.NOTFOUND) {
                    this.range = VLSNRange.EMPTY;
                    break block7;
                }
                throw EnvironmentFailureException.unexpectedState("VLSNTracker init: status=" + (Object)((Object)status));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd(true);
                }
            }
        }
    }

    VLSNTracker(EnvironmentImpl envImpl, int stride, int maxMappings, int maxDistance) {
        this.firstTrackedVLSN = VLSN.NULL_VLSN;
        this.lastOnDiskVLSN = VLSN.NULL_VLSN;
        this.envImpl = envImpl;
        this.stride = stride;
        this.maxMappings = maxMappings;
        this.maxDistance = maxDistance;
        StatGroup statistics = new StatGroup("VLSNIndex", "VLSN Index related stats.");
        this.nBucketsCreated = new LongStat(statistics, VLSNIndexStatDefinition.N_BUCKETS_CREATED);
        this.initEmpty();
    }

    void initEmpty() {
        this.bucketCache = new TreeMap<Long, VLSNBucket>();
        this.range = VLSNRange.EMPTY;
    }

    synchronized VLSNBucket getGTEBucket(VLSN vlsn) {
        if (this.lastOnDiskVLSN.compareTo(vlsn) >= 0) {
            return null;
        }
        Long pivot = vlsn.getSequence() + 1L;
        SortedMap<Long, VLSNBucket> head = this.bucketCache.headMap(pivot);
        VLSNBucket prevBucket = null;
        if (head.size() > 0 && (prevBucket = (VLSNBucket)head.get(head.lastKey())).owns(vlsn)) {
            return prevBucket;
        }
        SortedMap<Long, VLSNBucket> tail = this.bucketCache.tailMap(pivot);
        if (tail.size() > 0) {
            VLSNBucket bucket = (VLSNBucket)tail.get(tail.firstKey());
            assert (bucket.owns(vlsn) || bucket.follows(vlsn)) : "VLSN " + vlsn + " got wrong bucket " + bucket;
            return bucket;
        }
        throw EnvironmentFailureException.unexpectedState(this.envImpl, "VLSN " + vlsn + " should be held within this tracker. " + this + " prevBucket=" + prevBucket);
    }

    synchronized VLSNBucket getLTEBucket(VLSN vlsn) {
        if (this.firstTrackedVLSN.equals(VLSN.NULL_VLSN) || this.firstTrackedVLSN.compareTo(vlsn) > 0) {
            return null;
        }
        Long pivot = vlsn.getSequence() + 1L;
        SortedMap<Long, VLSNBucket> head = this.bucketCache.headMap(pivot);
        if (head.size() > 0) {
            return (VLSNBucket)head.get(head.lastKey());
        }
        SortedMap<Long, VLSNBucket> tail = this.bucketCache.tailMap(pivot);
        VLSNBucket nextBucket = null;
        if (tail.size() > 0) {
            nextBucket = (VLSNBucket)tail.get(tail.firstKey());
        }
        throw EnvironmentFailureException.unexpectedState(this.envImpl, "VLSN " + vlsn + " should be held within this tracker. " + this + " nextBucket=" + nextBucket);
    }

    synchronized void track(VLSN vlsn, long lsn, byte entryTypeNum) {
        VLSNBucket currentBucket = null;
        if (vlsn.compareTo(this.lastOnDiskVLSN) < 0) {
            this.updateRange(vlsn, entryTypeNum);
            return;
        }
        if (this.bucketCache.size() == 0) {
            currentBucket = new VLSNBucket(DbLsn.getFileNumber(lsn), this.stride, this.maxMappings, this.maxDistance, vlsn);
            this.nBucketsCreated.increment();
            this.bucketCache.put(currentBucket.getFirst().getSequence(), currentBucket);
        } else {
            currentBucket = (VLSNBucket)this.bucketCache.get(this.bucketCache.lastKey());
        }
        if (currentBucket.follows(vlsn)) {
            this.updateRange(vlsn, entryTypeNum);
            return;
        }
        if (!currentBucket.put(vlsn, lsn)) {
            currentBucket = new VLSNBucket(DbLsn.getFileNumber(lsn), this.stride, this.maxMappings, this.maxDistance, vlsn);
            this.nBucketsCreated.increment();
            this.bucketCache.put(currentBucket.getFirst().getSequence(), currentBucket);
            if (!currentBucket.put(vlsn, lsn)) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't put VLSN " + vlsn + " into " + currentBucket);
            }
        }
        this.updateRange(vlsn, entryTypeNum);
        if (this.firstTrackedVLSN == VLSN.NULL_VLSN) {
            this.firstTrackedVLSN = vlsn;
        }
    }

    private void updateRange(VLSN vlsn, byte entryTypeNum) {
        VLSNRange currentRange = this.range;
        this.range = currentRange.getUpdateForNewMapping(vlsn, entryTypeNum);
    }

    synchronized void flushToDatabase(DatabaseImpl mappingDbImpl, Txn txn) {
        VLSNRange flushRange = this.range;
        if (this.bucketCache.size() == 0) {
            if (this.rangeTruncated) {
                this.lastOnDiskVLSN = flushRange.writeToDatabase(this.envImpl, mappingDbImpl, txn);
                this.rangeTruncated = false;
            }
            return;
        }
        VLSNBucket lastBucket = (VLSNBucket)this.bucketCache.get(this.bucketCache.lastKey());
        lastBucket.close();
        VLSN currentLastVLSN = this.lastOnDiskVLSN;
        for (Long key : this.bucketCache.keySet()) {
            VLSNBucket target;
            this.validateBeforeWrite(target, flushRange, currentLastVLSN, (target = (VLSNBucket)this.bucketCache.get(key)) == lastBucket);
            target.writeToDatabase(this.envImpl, mappingDbImpl, txn);
            currentLastVLSN = target.getLast();
        }
        this.lastOnDiskVLSN = flushRange.writeToDatabase(this.envImpl, mappingDbImpl, txn);
        this.rangeTruncated = false;
        this.bucketCache.clear();
        this.firstTrackedVLSN = VLSN.NULL_VLSN;
    }

    private void validateBeforeWrite(VLSNBucket target, VLSNRange flushRange, VLSN currentLastVLSN, boolean isLastBucket) {
        if (!currentLastVLSN.equals(VLSN.NULL_VLSN) && target.getFirst().compareTo(currentLastVLSN) <= 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "target bucket overlaps previous bucket. currentLastVLSN= " + currentLastVLSN + " target=" + target);
        }
        if (target.getLast().compareTo(flushRange.getLast()) > 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "target bucket exceeds flush range. range= " + flushRange + " target=" + target);
        }
        if (isLastBucket && target.getLast().compareTo(flushRange.getLast()) != 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "end of last bucket should match end of range. range= " + flushRange + " target=" + target);
        }
    }

    synchronized void truncateFromHead(VLSN deleteEnd, long deleteFileNum) {
        VLSNRange oldRange = this.range;
        this.range = oldRange.shortenFromHead(deleteEnd);
        this.rangeTruncated = true;
        VLSN afterDelete = deleteEnd.getNext();
        if (!this.lastOnDiskVLSN.equals(VLSN.NULL_VLSN) && this.lastOnDiskVLSN.compareTo(deleteEnd) >= 0) {
            if (this.lastOnDiskVLSN.equals(deleteEnd)) {
                if (this.firstTrackedVLSN.compareTo(afterDelete) > 0) {
                    this.checkForGhostBucket(this.bucketCache, deleteFileNum);
                }
                this.lastOnDiskVLSN = VLSN.NULL_VLSN;
            }
            return;
        }
        assert (!this.firstTrackedVLSN.equals(VLSN.NULL_VLSN));
        if (this.firstTrackedVLSN.equals(afterDelete)) {
            this.lastOnDiskVLSN = VLSN.NULL_VLSN;
            return;
        }
        if (this.firstTrackedVLSN.compareTo(afterDelete) > 0) {
            this.checkForGhostBucket(this.bucketCache, deleteFileNum);
            this.lastOnDiskVLSN = VLSN.NULL_VLSN;
            return;
        }
        VLSNBucket owningBucket = this.getLTEBucket(deleteEnd);
        Long retainBucketKey = owningBucket.getFirst().getNext().getSequence();
        try {
            SortedMap<Long, VLSNBucket> tail = this.bucketCache.tailMap(retainBucketKey);
            this.checkForGhostBucket(tail, deleteFileNum);
            this.bucketCache = tail;
        }
        catch (NoSuchElementException e) {
            this.firstTrackedVLSN = VLSN.NULL_VLSN;
            this.bucketCache = new TreeMap<Long, VLSNBucket>();
        }
        this.lastOnDiskVLSN = VLSN.NULL_VLSN;
    }

    private void checkForGhostBucket(SortedMap<Long, VLSNBucket> buckets, long deleteFileNum) {
        Long firstKey = buckets.firstKey();
        VLSNBucket firstBucket = (VLSNBucket)buckets.get(firstKey);
        VLSN firstRangeVLSN = this.range.getFirst();
        VLSN firstBucketVLSN = firstBucket.getFirst();
        if (!firstBucketVLSN.equals(firstRangeVLSN)) {
            long nextFile = this.envImpl.getFileManager().getFollowingFileNum(deleteFileNum, true);
            long lastPossibleLsn = firstBucket.getLsn(firstBucketVLSN);
            GhostBucket placeholder = new GhostBucket(firstRangeVLSN, DbLsn.makeLsn(nextFile, 0), lastPossibleLsn);
            buckets.put(firstRangeVLSN.getSequence(), placeholder);
        }
    }

    synchronized void truncateFromTail(VLSN deleteStart, long prevLsn) {
        VLSNRange oldRange = this.range;
        this.range = oldRange.shortenFromEnd(deleteStart);
        this.rangeTruncated = true;
        if (this.firstTrackedVLSN.equals(VLSN.NULL_VLSN)) {
            return;
        }
        if (this.firstTrackedVLSN.compareTo(deleteStart) >= 0) {
            this.bucketCache.clear();
            this.firstTrackedVLSN = VLSN.NULL_VLSN;
            return;
        }
        VLSNBucket targetBucket = this.getGTEBucket(deleteStart);
        Long targetKey = targetBucket.getFirst().getSequence();
        TreeMap<Long, VLSNBucket> newCache = new TreeMap<Long, VLSNBucket>(this.bucketCache.headMap(targetKey));
        targetBucket.removeFromTail(deleteStart, prevLsn);
        if (!targetBucket.empty()) {
            newCache.put(targetBucket.getFirst().getSequence(), targetBucket);
        }
        this.bucketCache = newCache;
        boolean needEndMapping = false;
        if (this.bucketCache.isEmpty()) {
            needEndMapping = true;
        } else {
            VLSNBucket lastBucket = (VLSNBucket)this.bucketCache.get(this.bucketCache.lastKey());
            boolean bl = needEndMapping = lastBucket.getLast().compareTo(this.range.getLast()) < 0;
        }
        if (needEndMapping) {
            this.addEndMapping(this.range.getLast(), prevLsn);
        }
    }

    synchronized void ensureRangeEndIsMapped(VLSN lastVLSN, long lastLsn) {
        if (this.lastOnDiskVLSN.compareTo(lastVLSN) < 0) {
            if (!this.firstTrackedVLSN.equals(VLSN.NULL_VLSN)) {
                if (lastVLSN.compareTo(this.firstTrackedVLSN) < 0) {
                    throw EnvironmentFailureException.unexpectedState(this.envImpl, "Expected this tracker to cover vlsn " + lastVLSN + " after truncateFromTail. LastOnDiskVLSN= " + this.lastOnDiskVLSN + " tracker=" + this);
                }
                return;
            }
            this.addEndMapping(lastVLSN, lastLsn);
        }
    }

    private void addEndMapping(VLSN lastVLSN, long lastLsn) {
        assert (lastVLSN.compareTo(this.range.getLast()) == 0) : "lastVLSN=" + lastVLSN + " lastLsn = " + lastLsn + " range=" + this.range;
        VLSNBucket addBucket = new VLSNBucket(DbLsn.getFileNumber(lastLsn), this.stride, this.maxMappings, this.maxDistance, lastVLSN);
        addBucket.put(lastVLSN, lastLsn);
        this.nBucketsCreated.increment();
        this.bucketCache.put(addBucket.getFirst().getSequence(), addBucket);
        if (this.firstTrackedVLSN.equals(VLSN.NULL_VLSN)) {
            this.firstTrackedVLSN = lastVLSN;
        }
    }

    void merge(VLSN prunedLastOnDiskVLSN, VLSNRecoveryTracker recoveryTracker) {
        VLSNRange oldRange = this.range;
        this.range = oldRange.merge(recoveryTracker.range);
        VLSN recoveryFirst = recoveryTracker.getRange().getFirst();
        this.lastOnDiskVLSN = prunedLastOnDiskVLSN;
        if (this.bucketCache.size() == 0) {
            this.bucketCache = recoveryTracker.bucketCache;
        } else {
            VLSNBucket targetBucket = this.getGTEBucket(recoveryFirst);
            Long targetKey = targetBucket.getFirst().getSequence();
            TreeMap<Long, VLSNBucket> newCache = new TreeMap<Long, VLSNBucket>(this.bucketCache.headMap(targetKey));
            targetBucket.removeFromTail(recoveryFirst, -1L);
            if (!targetBucket.empty()) {
                newCache.put(targetBucket.getFirst().getSequence(), targetBucket);
            }
            newCache.putAll(recoveryTracker.bucketCache);
            this.bucketCache = newCache;
        }
        if (this.bucketCache.size() > 0) {
            VLSNBucket firstBucket = (VLSNBucket)this.bucketCache.get(this.bucketCache.firstKey());
            this.firstTrackedVLSN = firstBucket.getFirst();
        }
    }

    void append(VLSNRecoveryTracker recoveryTracker) {
        if (!this.range.getLast().isNull() && this.range.getLast().compareTo(recoveryTracker.getFirstTracked()) >= 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Expected this tracker to precede recovery tracker. This tracker= " + this + " recoveryTracker = " + recoveryTracker);
        }
        this.bucketCache.putAll(recoveryTracker.bucketCache);
        VLSNRange currentRange = this.range;
        this.range = currentRange.getUpdate(recoveryTracker.getRange());
        if (this.bucketCache.size() > 0) {
            VLSNBucket firstBucket = (VLSNBucket)this.bucketCache.get(this.bucketCache.firstKey());
            this.firstTrackedVLSN = firstBucket.getFirst();
        }
    }

    VLSNRange getRange() {
        return this.range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.range);
        sb.append(" firstTracked=").append(this.firstTrackedVLSN);
        sb.append(" lastOnDiskVLSN=").append(this.lastOnDiskVLSN);
        for (VLSNBucket bucket : this.bucketCache.values()) {
            sb.append("\n");
            sb.append(bucket);
        }
        return sb.toString();
    }

    synchronized boolean verify(boolean verbose) {
        if (!this.range.verify(verbose)) {
            return false;
        }
        ArrayList<VLSN> firstVLSN = new ArrayList<VLSN>();
        ArrayList<VLSN> lastVLSN = new ArrayList<VLSN>();
        for (VLSNBucket b : this.bucketCache.values()) {
            firstVLSN.add(b.getFirst());
            lastVLSN.add(b.getLast());
        }
        if (!VLSNTracker.verifyBucketBoundaries(firstVLSN, lastVLSN)) {
            return false;
        }
        if (firstVLSN.size() > 0) {
            if (!firstVLSN.get(0).equals(this.firstTrackedVLSN)) {
                if (verbose) {
                    System.err.println("firstBucketVLSN = " + firstVLSN.get(0) + " should equal " + this.firstTrackedVLSN);
                }
                return false;
            }
            VLSN lastBucketVLSN = lastVLSN.get(lastVLSN.size() - 1);
            if (!lastBucketVLSN.equals(this.range.getLast())) {
                if (verbose) {
                    System.err.println("lastBucketVLSN = " + lastBucketVLSN + " should equal " + this.range.getLast());
                }
                return false;
            }
        }
        return true;
    }

    static boolean verifyBucketBoundaries(ArrayList<VLSN> firstVLSN, ArrayList<VLSN> lastVLSN) {
        for (int i = 1; i < firstVLSN.size(); ++i) {
            VLSN prevLast;
            VLSN first = firstVLSN.get(i);
            if (first.compareTo((prevLast = lastVLSN.get(i - 1)).getNext()) >= 0) continue;
            System.out.println("Boundary problem: bucket " + i + " first " + first + " follows bucket.last " + prevLast);
            return false;
        }
        return true;
    }

    VLSN getFirstTracked() {
        return this.firstTrackedVLSN;
    }

    VLSN getLastOnDisk() {
        return this.lastOnDiskVLSN;
    }

    void setLastOnDiskVLSN(VLSN lastOnDisk) {
        this.lastOnDiskVLSN = lastOnDisk;
    }

    boolean isFlushedToDisk() {
        return this.lastOnDiskVLSN.equals(this.range.getLast());
    }
}

