/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.je.utilint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class JarMain {
    private static final String USAGE = "usage: java <utility> [options...]";
    private static HashMap<String, String> utilPrefixMap = new HashMap();

    private static String availableUtilities() {
        StringBuilder sbuf = new StringBuilder();
        for (String util : utilPrefixMap.keySet()) {
            sbuf.append(utilPrefixMap.get(util));
            sbuf.append(util);
            sbuf.append("\n");
        }
        return sbuf.toString();
    }

    public static void main(String[] args) {
        try {
            String utilPrefix;
            if (args.length < 1) {
                JarMain.usage("Missing utility name");
            }
            if ((utilPrefix = utilPrefixMap.get(args[0])) == null) {
                System.out.println("Available utilities are: ");
                System.out.println(JarMain.availableUtilities());
                JarMain.usage("No such utility");
            }
            Class<?> cls = Class.forName(utilPrefix + args[0]);
            Method mainMethod = cls.getMethod("main", String[].class);
            String[] mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (InvocationTargetException ITE) {
            if (ITE.getCause() != null) {
                JarMain.usage(ITE.getCause().toString());
            } else {
                System.err.println("Problem invoking main method:");
                ITE.printStackTrace(System.err);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            JarMain.usage(e.toString());
        }
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.err.println(USAGE);
        System.exit(-1);
    }

    static {
        utilPrefixMap.put("DbCacheSize", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbDump", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbFilterStats", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbLoad", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbPrintLog", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbTruncateLog", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbRunAction", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbScavenger", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbSpace", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbStat", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbVerify", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbVerifyLog", "com.tangosol.internal.sleepycat.je.util.");
        utilPrefixMap.put("DbEnableReplication", "com.tangosol.internal.sleepycat.je.rep.util.");
        utilPrefixMap.put("DbGroupAdmin", "com.tangosol.internal.sleepycat.je.rep.util.");
        utilPrefixMap.put("DbPing", "com.tangosol.internal.sleepycat.je.rep.util.");
        utilPrefixMap.put("LDiff", "com.tangosol.internal.sleepycat.je.rep.util.ldiff.");
        utilPrefixMap.put("DbDumpGroup", "com.tangosol.internal.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbFeederPrintLog", "com.tangosol.internal.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbStreamVerify", "com.tangosol.internal.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbSync", "com.tangosol.internal.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbRepRunAction", "com.tangosol.internal.sleepycat.je.rep.utilint.");
        utilPrefixMap.put("DbNullNode", "com.tangosol.internal.sleepycat.je.rep.utilint.");
    }
}

