/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.impl;

import com.tangosol.internal.sleepycat.persist.impl.Format;
import com.tangosol.internal.sleepycat.persist.impl.PersistCatalog;
import com.tangosol.internal.sleepycat.persist.model.ClassMetadata;
import com.tangosol.internal.sleepycat.persist.model.EntityMetadata;
import com.tangosol.internal.sleepycat.persist.model.EntityModel;
import java.util.Set;

class StoredModel
extends EntityModel {
    private volatile PersistCatalog catalog;
    private volatile Set<String> knownClasses;

    StoredModel(PersistCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    protected void setCatalog(PersistCatalog newCatalog) {
        super.setCatalog(newCatalog);
        this.catalog = newCatalog;
        this.knownClasses = newCatalog.getModelClasses();
    }

    @Override
    public ClassMetadata getClassMetadata(String className) {
        ClassMetadata metadata = null;
        Format format = this.catalog.getFormat(className);
        if (format != null && format.isCurrentVersion()) {
            metadata = format.getClassMetadata();
        }
        return metadata;
    }

    @Override
    public EntityMetadata getEntityMetadata(String className) {
        EntityMetadata metadata = null;
        Format format = this.catalog.getFormat(className);
        if (format != null && format.isCurrentVersion()) {
            metadata = format.getEntityMetadata();
        }
        return metadata;
    }

    @Override
    public Set<String> getKnownClasses() {
        return this.knownClasses;
    }
}

