/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.persist.raw;

import com.tangosol.internal.sleepycat.compat.DbCompat;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.persist.PrimaryIndex;
import com.tangosol.internal.sleepycat.persist.SecondaryIndex;
import com.tangosol.internal.sleepycat.persist.StoreConfig;
import com.tangosol.internal.sleepycat.persist.StoreExistsException;
import com.tangosol.internal.sleepycat.persist.StoreNotFoundException;
import com.tangosol.internal.sleepycat.persist.evolve.IncompatibleClassException;
import com.tangosol.internal.sleepycat.persist.evolve.Mutations;
import com.tangosol.internal.sleepycat.persist.impl.Store;
import com.tangosol.internal.sleepycat.persist.model.EntityModel;
import com.tangosol.internal.sleepycat.persist.raw.RawObject;
import java.io.Closeable;

public class RawStore
implements Closeable {
    private Store store;

    public RawStore(Environment env, String storeName, StoreConfig config) throws StoreNotFoundException, DatabaseException {
        try {
            this.store = new Store(env, storeName, config, true);
        }
        catch (StoreExistsException e) {
            throw DbCompat.unexpectedException(e);
        }
        catch (IncompatibleClassException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    public PrimaryIndex<Object, RawObject> getPrimaryIndex(String entityClass) throws DatabaseException {
        return this.store.getPrimaryIndex(Object.class, null, RawObject.class, entityClass);
    }

    public SecondaryIndex<Object, Object, RawObject> getSecondaryIndex(String entityClass, String keyName) throws DatabaseException {
        return this.store.getSecondaryIndex(this.getPrimaryIndex(entityClass), RawObject.class, entityClass, Object.class, null, keyName);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    @Override
    public void close() throws DatabaseException {
        this.store.close();
    }
}

