/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.sleepycat.utilint;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class StringUtils {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static byte[] toUTF8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer toUTF8(CharBuffer chars) {
        try {
            CharsetEncoder utf8Encoder = UTF8.newEncoder();
            return utf8Encoder.encode(chars);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUTF8(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromUTF8(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static CharBuffer fromUTF8(ByteBuffer bytes) {
        try {
            CharsetDecoder utf8Decoder = UTF8.newDecoder();
            return utf8Decoder.decode(bytes);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toASCII(String str) {
        try {
            return str.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteBuffer toASCII(CharBuffer chars) {
        try {
            CharsetEncoder asciiEncoder = ASCII.newEncoder();
            return asciiEncoder.encode(chars);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromASCII(byte[] bytes) {
        try {
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fromASCII(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static CharBuffer fromASCII(ByteBuffer bytes) {
        try {
            CharsetDecoder asciiDecoder = ASCII.newDecoder();
            return asciiDecoder.decode(bytes);
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }
}

