/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.tracing;

import com.tangosol.internal.tracing.NoopAware;
import com.tangosol.internal.tracing.Span;
import com.tangosol.internal.tracing.Tracer;
import com.tangosol.util.Base;
import java.util.Objects;

public interface TracingShim
extends NoopAware {
    public Control initialize(Dependencies var1);

    public boolean isEnabled();

    public Tracer getTracer();

    public Span getNoopSpan();

    public Span.Builder getNoopSpanBuilder();

    public Dependencies getDependencies();

    public static final class Noop
    implements TracingShim {
        public static final TracingShim INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        public Control initialize(Dependencies dependencies) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Tracer getTracer() {
            return Tracer.Noop.INSTANCE;
        }

        @Override
        public Span getNoopSpan() {
            return Span.Noop.INSTANCE;
        }

        @Override
        public Span.Builder getNoopSpanBuilder() {
            return Span.Builder.Noop.INSTANCE;
        }

        @Override
        public Dependencies getDependencies() {
            return new DefaultDependencies();
        }

        @Override
        public boolean isNoop() {
            return true;
        }

        public String toString() {
            return "TracingShim.Noop";
        }
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected String m_sIdentity;
        protected float m_nSamplingRatio = -1.0f;

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.setIdentity(deps.getIdentity());
                this.setSamplingRatio(deps.getSamplingRatio());
            }
        }

        @Override
        public String getIdentity() {
            return this.m_sIdentity;
        }

        public DefaultDependencies setIdentity(String sIdentity) {
            this.m_sIdentity = sIdentity;
            return this;
        }

        @Override
        public float getSamplingRatio() {
            return Math.min(this.m_nSamplingRatio, 1.0f);
        }

        public DefaultDependencies setSamplingRatio(float nSamplingRatio) {
            this.m_nSamplingRatio = nSamplingRatio;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultDependencies that = (DefaultDependencies)o;
            return Float.compare(that.m_nSamplingRatio, this.m_nSamplingRatio) == 0 && Base.equals(this.m_sIdentity, that.m_sIdentity);
        }

        public int hashCode() {
            return Objects.hash(this.m_sIdentity, Float.valueOf(this.m_nSamplingRatio));
        }

        public String toString() {
            return "DefaultDependencies(Identity='" + this.m_sIdentity + '\'' + ", SamplingRatio=" + this.m_nSamplingRatio + ')';
        }
    }

    public static interface Dependencies {
        public String getIdentity();

        public float getSamplingRatio();
    }

    public static interface Control
    extends AutoCloseable {
        @Override
        public void close();

        public Dependencies getDependencies();
    }
}

