/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util;

import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;

public class DefaultDaemonPoolDependencies
implements DaemonPoolDependencies {
    private Guardian m_guardian;
    private String m_sName;
    private int m_cThreads;
    private int m_cThreadsMax = Integer.MAX_VALUE;
    private int m_cThreadsMin = 1;
    private ThreadGroup m_group;
    private int m_nPriority = 5;

    public DefaultDaemonPoolDependencies() {
        this(null);
    }

    public DefaultDaemonPoolDependencies(DaemonPoolDependencies deps) {
        if (deps != null) {
            this.setGuardian(deps.getGuardian());
            this.setName(deps.getName());
            this.setThreadCount(deps.getThreadCount());
            this.setThreadCountMax(deps.getThreadCountMax());
            this.setThreadCountMin(deps.getThreadCountMin());
            this.setThreadGroup(deps.getThreadGroup());
            this.setThreadPriority(deps.getThreadPriority());
        }
    }

    @Override
    public Guardian getGuardian() {
        return this.m_guardian;
    }

    public void setGuardian(Guardian guardian) {
        this.m_guardian = guardian;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    @Override
    public int getThreadCount() {
        return this.m_cThreads;
    }

    public void setThreadCount(int cThreads) {
        this.m_cThreads = cThreads;
    }

    @Override
    public int getThreadCountMax() {
        return this.m_cThreadsMax;
    }

    public void setThreadCountMax(int cThreads) {
        this.m_cThreadsMax = cThreads;
    }

    @Override
    public int getThreadCountMin() {
        return this.m_cThreadsMin;
    }

    public void setThreadCountMin(int cThreads) {
        this.m_cThreadsMin = cThreads;
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.m_group;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.m_group = group;
    }

    @Override
    public int getThreadPriority() {
        return this.m_nPriority;
    }

    public void setThreadPriority(int nPriority) {
        this.m_nPriority = nPriority;
    }

    @Override
    public boolean isDynamic() {
        return this.getThreadCountMin() < this.getThreadCountMax();
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "{Guardian=" + this.getGuardian() + ", Name=" + this.getName() + ", ThreadCount=" + this.getThreadCount() + ", ThreadCountMax=" + this.getThreadCountMax() + ", ThreadCountMin=" + this.getThreadCountMin() + ", ThreadGroup=" + this.getThreadGroup() + ", ThreadPriority=" + this.getThreadPriority() + ", Dynamic=" + this.isDynamic() + "}";
    }

    public DefaultDaemonPoolDependencies validate() {
        Base.azzert(this.getThreadCount() >= 1, "ThreadCount cannot be less than 1");
        Base.azzert(this.getThreadCountMax() >= 1, "ThreadCountMax cannot be less than 1");
        Base.azzert(this.getThreadCountMin() >= 1, "ThreadCountMin cannot be less than 1");
        Base.azzert(this.getThreadCountMax() >= this.getThreadCountMin(), "ThreadCountMax must be greater than or equal to ThreadCountMin");
        Base.azzert(this.getThreadPriority() >= 1, "ThreadPriority cannot be less than 1");
        Base.azzert(this.getThreadPriority() <= 10, "ThreadPriority cannot be more than 10");
        return this;
    }
}

