/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal.js;

import com.tangosol.internal.util.graal.ScriptDescriptor;
import com.tangosol.internal.util.graal.ScriptHandler;
import com.tangosol.internal.util.graal.js.JavaScriptModuleManager;
import com.tangosol.util.ScriptException;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class JavaScriptHandler
implements ScriptHandler {
    @Override
    public String getLanguage() {
        return "js";
    }

    @Override
    public void configure(Context.Builder builder) {
        builder.option("js.nashorn-compat", "true");
    }

    @Override
    public void initContext(Context context) {
        context.getBindings("js").putMember("require", JavaScriptHandler.getRequireFunction());
    }

    @Override
    public void onReady(Context context) {
        try {
            ScriptDescriptor desc = new ScriptDescriptor("js", "/");
            for (String script : desc.listScripts()) {
                Value global = this.evaluateScript(script);
                if (global == null) continue;
                for (String key : global.getMemberKeys()) {
                    context.getBindings("js").putMember(key, (Object)global.getMember(key));
                }
            }
        }
        catch (Throwable e) {
            throw new ScriptException("error during script preloading", e);
        }
    }

    @Override
    public Value evaluateScript(String script) throws ScriptException {
        return JavaScriptModuleManager.getInstance().createAndLoadModule(new ScriptDescriptor("js", script)).getValue();
    }

    static Function<String, Object> getRequireFunction() {
        return moduleName -> JavaScriptModuleManager.getInstance().require((String)moduleName);
    }
}

