/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.graal.js;

import com.tangosol.internal.util.graal.ScriptDescriptor;
import com.tangosol.internal.util.graal.ScriptManager;
import com.tangosol.internal.util.graal.js.JavaScriptHandler;
import com.tangosol.internal.util.graal.js.Module;
import com.tangosol.util.ScriptException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class JavaScriptModuleManager {
    private static final JavaScriptModuleManager INSTANCE = new JavaScriptModuleManager();
    private final ArrayDeque<Module> f_partialModules = new ArrayDeque();
    private final HashMap<String, Module> f_cachedModules = new HashMap();

    private JavaScriptModuleManager() {
    }

    public synchronized Object require(String sModuleName) {
        Module result;
        if (sModuleName.startsWith("./") || sModuleName.startsWith("/") || sModuleName.startsWith("../")) {
            ScriptDescriptor descriptor = this.getParent().getDescriptor().resolve(sModuleName);
            result = this.loadAsFile(descriptor);
            if (result == null) {
                result = this.loadAsDirectory(descriptor);
            }
        } else {
            result = this.loadAsNodeModule(sModuleName);
        }
        if (result != null) {
            this.f_cachedModules.put(result.getDescriptor().getScriptUrl().toString(), result);
            this.getParent().addDependentModule(result);
            return result.getExports();
        }
        throw new ScriptException("Cannot load module: " + sModuleName);
    }

    private Module loadAsFile(ScriptDescriptor desc) throws ScriptException {
        for (String extn : new String[]{"", ".js", ".mjs", ".json"}) {
            String resourceName = desc.getSimpleName() + extn;
            ScriptDescriptor descriptor = desc.resolve(resourceName);
            if (!descriptor.exists() || descriptor.isDirectory()) continue;
            return this.createAndLoadModule(descriptor);
        }
        return null;
    }

    private Module loadAsDirectory(ScriptDescriptor module) {
        String mainField;
        ScriptDescriptor descriptor = module.resolve("package.json");
        if (descriptor.exists() && !descriptor.isDirectory() && (mainField = this.getMainFieldFromJSON(descriptor.getScriptUrl())) != null) {
            ScriptDescriptor mainFieldDesc = module.resolve(mainField);
            Module m = this.loadAsFile(mainFieldDesc);
            if (m != null) {
                return m;
            }
            m = this.loadIndex(module);
            if (m != null) {
                return m;
            }
        }
        return this.loadIndex(module);
    }

    private Module loadAsNodeModule(String sModuleName) {
        Module result = null;
        for (ScriptDescriptor nodeModulesDir : this.toNodeModulesPaths(this.getParent().getDescriptor())) {
            ScriptDescriptor desc = nodeModulesDir.resolve(sModuleName);
            result = this.loadAsFile(desc);
            if (result == null) {
                result = this.loadAsDirectory(desc);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    private Module loadIndex(ScriptDescriptor module) {
        for (String indexFileName : new String[]{"index.js", "index.json"}) {
            ScriptDescriptor descriptor = module.resolve(indexFileName);
            if (!descriptor.exists() || descriptor.isDirectory()) continue;
            return this.createAndLoadModule(descriptor);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMainFieldFromJSON(URL pkgJsonUrl) {
        String mainFieldValue = null;
        int level = 0;
        boolean inMainField = false;
        try (InputStream is = pkgJsonUrl.openStream();
             JsonParser parser = Json.createParser((InputStream)is);){
            block26: while (parser.hasNext()) {
                JsonParser.Event event = parser.next();
                switch (event) {
                    case START_OBJECT: {
                        ++level;
                        continue block26;
                    }
                    case END_OBJECT: {
                        --level;
                        continue block26;
                    }
                    case KEY_NAME: {
                        inMainField = "main".equals(parser.getString());
                        continue block26;
                    }
                    case VALUE_STRING: {
                        String string = parser.getString();
                        if (level != 1 || !inMainField) continue block26;
                        mainFieldValue = string;
                        continue block26;
                    }
                }
                if (inMainField) throw new IllegalStateException("main field value specified but it is not a string");
            }
            return mainFieldValue;
        }
        catch (IOException ioEx) {
            throw new ScriptException("Error while parsing: " + pkgJsonUrl);
        }
    }

    private Module getParent() {
        return this.f_partialModules.peekLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Module createAndLoadModule(ScriptDescriptor descriptor) throws ScriptException {
        if (!descriptor.exists()) {
            throw new IllegalArgumentException("specified script does not exist. Descriptor: " + descriptor);
        }
        if (descriptor.isDirectory()) {
            throw new IllegalArgumentException("script path must point to a file. Descriptor: " + descriptor);
        }
        String cachingKey = descriptor.getScriptUrl().toString();
        Module module = this.f_cachedModules.get(cachingKey);
        if (module != null) {
            return module;
        }
        Context context = ScriptManager.getInstance().getContext();
        try {
            module = new Module(descriptor);
            this.f_cachedModules.put(cachingKey, module);
            this.f_partialModules.addLast(module);
            this.setupContextForModule(context, module);
            module.load(context);
            this.getParent().addDependentModule(module);
        }
        finally {
            Module prevModule = this.f_partialModules.pollLast();
            this.setupContextForModule(context, prevModule);
        }
        return module;
    }

    public List<ScriptDescriptor> toNodeModulesPaths(ScriptDescriptor base) {
        ArrayList<ScriptDescriptor> dirs = new ArrayList<ScriptDescriptor>();
        for (ScriptDescriptor current = base.getParentDescriptor(); current != null; current = current.getParentDescriptor()) {
            if (current.getSimpleName().equals("node_modules")) continue;
            dirs.add(current.resolve("node_modules/"));
        }
        return dirs;
    }

    public HashMap<String, Module> getCachedModules() {
        return this.f_cachedModules;
    }

    public static JavaScriptModuleManager getInstance() {
        return INSTANCE;
    }

    private void setupContextForModule(Context context, Module module) {
        Value bindings = context.getBindings("js");
        if (module != null) {
            bindings.putMember("module", (Object)module);
            bindings.putMember("exports", module.getExports());
            bindings.putMember("__dirname", (Object)module.getDescriptor().getDirectory());
            bindings.putMember("__filename", (Object)module.getDescriptor().getScriptPath());
            bindings.putMember("require", JavaScriptHandler.getRequireFunction());
        } else {
            bindings.removeMember("module");
            bindings.removeMember("exports");
            bindings.removeMember("__filename");
            bindings.removeMember("__dirname");
            bindings.removeMember("require");
        }
    }
}

