/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.invoke;

import com.tangosol.coherence.config.Config;
import com.tangosol.internal.util.invoke.ClassDefinition;
import com.tangosol.internal.util.invoke.ClassIdentity;
import com.tangosol.internal.util.invoke.Classes;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.internal.util.invoke.Remotable;
import com.tangosol.internal.util.invoke.RemoteConstructor;
import com.tangosol.internal.util.invoke.lambda.LambdaIdentity;
import com.tangosol.util.Base;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class RemotableSupport
extends ClassLoader {
    private static final String DUMP_REMOTABLE = Config.getProperty("coherence.server.remotable.dumpClasses");
    private static final Map<ClassLoader, RemotableSupport> s_mapByClassLoader = Collections.synchronizedMap(new WeakHashMap());
    protected final Map<ClassIdentity, ClassDefinition> f_mapDefinitions = new ConcurrentHashMap<ClassIdentity, ClassDefinition>();

    public RemotableSupport(ClassLoader parent) {
        super(parent);
    }

    public static RemotableSupport get(ClassLoader loader) {
        return loader instanceof RemotableSupport ? (RemotableSupport)loader : s_mapByClassLoader.computeIfAbsent(Base.ensureClassLoader(loader), RemotableSupport::new);
    }

    public <T extends Serializable> RemoteConstructor<T> createRemoteConstructor(T lambda) {
        assert (Lambdas.isLambda(lambda));
        SerializedLambda lambdaMetadata = Lambdas.getSerializedLambda(lambda);
        String sImplClassFile = lambdaMetadata.getImplClass() + ".class";
        ClassLoader loaderTmp = this.getParent();
        if (loaderTmp.getResource(sImplClassFile) == null && (loaderTmp = lambda.getClass().getClassLoader()).getResource(sImplClassFile) == null) {
            throw new IllegalStateException("ClassFile for the remote lambda could not be introspected. " + loaderTmp + ".getResource(" + sImplClassFile + ") unexpectedly returned null");
        }
        ClassLoader loader = loaderTmp;
        LambdaIdentity identity = Lambdas.createIdentity(lambdaMetadata, this.getParent());
        ClassDefinition definition = this.f_mapDefinitions.computeIfAbsent(identity, id -> Lambdas.createDefinition(id, lambda, loader));
        return new RemoteConstructor(definition, Lambdas.getCapturedArguments(lambdaMetadata));
    }

    public <T> RemoteConstructor<T> createRemoteConstructor(Class<? extends T> clzImpl, Object ... args) {
        ClassDefinition definition = this.f_mapDefinitions.computeIfAbsent(new ClassIdentity(clzImpl), id -> Classes.createDefinition(id, clzImpl));
        return new RemoteConstructor(definition, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T realize(RemoteConstructor<T> constructor) {
        ClassDefinition definition = this.registerIfAbsent(constructor.getDefinition());
        Class<? extends Remotable> clz = definition.getRemotableClass();
        if (clz == null) {
            ClassDefinition classDefinition = definition;
            synchronized (classDefinition) {
                clz = definition.getRemotableClass();
                if (clz == null) {
                    definition.setRemotableClass(this.defineClass(definition));
                }
            }
        }
        Remotable instance = (Remotable)definition.createInstance(constructor.getArguments());
        instance.setRemoteConstructor(constructor);
        return (T)instance;
    }

    protected ClassDefinition registerIfAbsent(ClassDefinition definition) {
        assert (definition != null);
        ClassDefinition rtn = this.f_mapDefinitions.putIfAbsent(definition.getId(), definition);
        return rtn == null ? definition : rtn;
    }

    protected Class<? extends Remotable> defineClass(ClassDefinition definition) {
        String sBinClassName = definition.getId().getName();
        String sClassName = sBinClassName.replace('/', '.');
        byte[] abClass = definition.getBytes();
        definition.dumpClass(DUMP_REMOTABLE);
        return this.defineClass(sClassName, abClass, 0, abClass.length);
    }

    public String toString() {
        return "RemotableSupport{parent=" + this.getParent() + ", definitions=" + this.f_mapDefinitions.keySet() + '}';
    }
}

