/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class CollectionCollector<T, C extends Collection<T>>
implements RemoteCollector<T, C, C>,
ExternalizableLite,
PortableObject {
    protected static final Set<Collector.Characteristics> S_CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    @JsonbProperty(value="supplier")
    protected Supplier<C> m_supplier;

    public CollectionCollector() {
    }

    public CollectionCollector(Supplier<C> supplier) {
        this.m_supplier = supplier;
    }

    public CollectionCollector(Remote.Supplier<C> supplier) {
        this.m_supplier = supplier;
    }

    @Override
    public Supplier<C> supplier() {
        return this.m_supplier;
    }

    @Override
    public BiConsumer<C, T> accumulator() {
        return Collection::add;
    }

    @Override
    public BinaryOperator<C> combiner() {
        return (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        };
    }

    @Override
    public Function<C, C> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_supplier = (Supplier)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_supplier);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_supplier = (Supplier)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_supplier);
    }
}

