/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.util.stream.collectors;

import com.tangosol.internal.util.LongSummaryStatistics;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import com.tangosol.util.stream.RemoteCollector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import javax.json.bind.annotation.JsonbProperty;

public class SummarizingLongCollector<T>
implements RemoteCollector<T, LongSummaryStatistics, LongSummaryStatistics>,
ExternalizableLite,
PortableObject {
    protected static final Set<Collector.Characteristics> S_CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    @JsonbProperty(value="mapper")
    protected ToLongFunction<? super T> m_mapper;

    public SummarizingLongCollector() {
    }

    public SummarizingLongCollector(Remote.ToLongFunction<? super T> mapper) {
        this.m_mapper = Lambdas.ensureRemotable(mapper);
    }

    @Override
    public Supplier<LongSummaryStatistics> supplier() {
        return LongSummaryStatistics::new;
    }

    @Override
    public BiConsumer<LongSummaryStatistics, T> accumulator() {
        ToLongFunction mapper = this.m_mapper;
        return (a, t) -> a.accept(mapper.applyAsLong(t));
    }

    @Override
    public BinaryOperator<LongSummaryStatistics> combiner() {
        return (a, b) -> {
            a.combine((java.util.LongSummaryStatistics)b);
            return a;
        };
    }

    @Override
    public Function<LongSummaryStatistics, LongSummaryStatistics> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return S_CHARACTERISTICS;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_mapper = (ToLongFunction)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_mapper);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_mapper = (ToLongFunction)in.readObject(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_mapper);
    }
}

