/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.AbstractReadBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.json.bind.annotation.JsonbProperty;

public abstract class AbstractByteArrayReadBuffer
extends AbstractReadBuffer {
    @JsonbProperty(value="byteArray")
    protected byte[] m_ab;
    @JsonbProperty(value="offset")
    protected int m_of;
    @JsonbProperty(value="length")
    protected int m_cb;

    protected AbstractByteArrayReadBuffer() {
    }

    protected AbstractByteArrayReadBuffer(byte[] ab, int of, int cb) {
        this.m_ab = ab;
        this.resetRange(of, cb);
    }

    @Override
    public int length() {
        return this.m_cb;
    }

    @Override
    public byte byteAt(int of) {
        if (of >= 0 && of < this.m_cb) {
            return this.m_ab[this.m_of + of];
        }
        throw new IndexOutOfBoundsException("of=" + of + ", length()=" + this.m_cb);
    }

    @Override
    public void copyBytes(int ofBegin, int ofEnd, byte[] abDest, int ofDest) {
        if (ofBegin < 0 || ofEnd > this.m_cb || ofBegin > ofEnd) {
            throw new IndexOutOfBoundsException("ofBegin=" + ofBegin + ", ofEnd=" + ofEnd + ", Binary.length=" + this.m_cb);
        }
        System.arraycopy(this.m_ab, this.m_of + ofBegin, abDest, ofDest, ofEnd - ofBegin);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    @Override
    public void writeTo(OutputStream out, int of, int cb) throws IOException {
        out.write(this.m_ab, this.m_of + of, cb);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    @Override
    public void writeTo(DataOutput out, int of, int cb) throws IOException {
        out.write(this.m_ab, this.m_of + of, cb);
    }

    @Override
    public void writeTo(ByteBuffer buf) {
        buf.put(this.m_ab, this.m_of, this.m_cb);
    }

    @Override
    public void writeTo(ByteBuffer buf, int of, int cb) throws IOException {
        buf.put(this.m_ab, this.m_of + of, cb);
    }

    @Override
    public byte[] toByteArray(int of, int cb) {
        this.checkBounds(of, cb);
        if (cb == 0) {
            return NO_BYTES;
        }
        byte[] ab = this.m_ab;
        if ((of += this.m_of) == 0 && cb == ab.length && !this.isByteArrayPrivate()) {
            return ab;
        }
        byte[] abNew = new byte[cb];
        System.arraycopy(ab, of, abNew, 0, cb);
        return abNew;
    }

    @Override
    public Binary toBinary() {
        int cb = this.m_cb;
        return cb == 0 ? NO_BINARY : new Binary(this.m_ab, this.m_of, cb);
    }

    @Override
    public Binary toBinary(int of, int cb) {
        this.checkBounds(of, cb);
        return cb == 0 ? NO_BINARY : new Binary(this.m_ab, this.m_of + of, cb);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.m_ab, this.m_of, this.m_cb).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer toByteBuffer(int of, int cb) {
        this.checkBounds(of, cb);
        return ByteBuffer.wrap(this.m_ab, this.m_of + of, cb).asReadOnlyBuffer();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractByteArrayReadBuffer) {
            AbstractByteArrayReadBuffer that = (AbstractByteArrayReadBuffer)o;
            if (this == that) {
                return true;
            }
            int cb = this.m_cb;
            return cb == that.m_cb && Binary.equals(this.m_ab, this.m_of, that.m_ab, that.m_of, cb);
        }
        return super.equals(o);
    }

    @Override
    protected ReadBuffer.BufferInput instantiateBufferInput() {
        return new ByteArrayBufferInput();
    }

    protected void resetRange(int of, int cb) {
        byte[] ab = this.m_ab;
        if (of < 0 || cb < 0 || of + cb > ab.length) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", ab.length=" + ab.length);
        }
        this.m_of = of;
        this.m_cb = cb;
    }

    protected abstract boolean isByteArrayPrivate();

    public final class ByteArrayBufferInput
    extends AbstractReadBuffer.AbstractBufferInput {
        @Override
        public int read() throws IOException {
            int of = this.getOffset();
            if (of < AbstractByteArrayReadBuffer.this.m_cb) {
                this.setOffsetInternal(of + 1);
                return AbstractByteArrayReadBuffer.this.m_ab[AbstractByteArrayReadBuffer.this.m_of + of] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] ab, int of, int cb) throws IOException {
            int cbDest = ab.length;
            if (of < 0 || cb < 0 || of + cb > cbDest) {
                throw new IndexOutOfBoundsException("ab.length=" + cbDest + ", of=" + of + ", cb=" + cb);
            }
            if (cb == 0) {
                return 0;
            }
            int ofIn = this.getOffset();
            int cbRead = Math.min(cb, AbstractByteArrayReadBuffer.this.m_cb - ofIn);
            if (cbRead == 0) {
                return -1;
            }
            System.arraycopy(AbstractByteArrayReadBuffer.this.m_ab, AbstractByteArrayReadBuffer.this.m_of + ofIn, ab, of, cbRead);
            this.setOffsetInternal(ofIn + cbRead);
            return cbRead;
        }

        @Override
        public byte readByte() throws IOException {
            int ofAdd = this.getOffset();
            if (ofAdd < AbstractByteArrayReadBuffer.this.m_cb) {
                this.setOffsetInternal(ofAdd + 1);
                return AbstractByteArrayReadBuffer.this.m_ab[AbstractByteArrayReadBuffer.this.m_of + ofAdd];
            }
            throw new EOFException();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            int ofAdd = this.getOffset();
            if (AbstractByteArrayReadBuffer.this.m_cb - ofAdd < 2) {
                this.setOffsetInternal(AbstractByteArrayReadBuffer.this.m_cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 2);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            return (ab[of] & 0xFF) << 8 | ab[of + 1] & 0xFF;
        }

        @Override
        public int readInt() throws IOException {
            int ofAdd = this.getOffset();
            if (AbstractByteArrayReadBuffer.this.m_cb - ofAdd < 4) {
                this.setOffsetInternal(AbstractByteArrayReadBuffer.this.m_cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 4);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            return ab[of] << 24 | (ab[of + 1] & 0xFF) << 16 | (ab[of + 2] & 0xFF) << 8 | ab[of + 3] & 0xFF;
        }

        @Override
        public long readLong() throws IOException {
            int ofAdd = this.getOffset();
            if (AbstractByteArrayReadBuffer.this.m_cb - ofAdd < 8) {
                this.setOffsetInternal(AbstractByteArrayReadBuffer.this.m_cb);
                throw new EOFException();
            }
            this.setOffsetInternal(ofAdd + 8);
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int of = AbstractByteArrayReadBuffer.this.m_of + ofAdd;
            long n1 = ab[of] << 24 | (ab[of + 1] & 0xFF) << 16 | (ab[of + 2] & 0xFF) << 8 | ab[of + 3] & 0xFF;
            long n2 = ab[of + 4] << 24 | (ab[of + 5] & 0xFF) << 16 | (ab[of + 6] & 0xFF) << 8 | ab[of + 7] & 0xFF;
            return n1 << 32 | n2 & 0xFFFFFFFFL;
        }

        @Override
        public int readPackedInt() throws IOException {
            boolean fNeg;
            int cb;
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int ofRaw = AbstractByteArrayReadBuffer.this.m_of;
            int of = ofRaw + this.getOffset();
            if (of >= (cb = ofRaw + AbstractByteArrayReadBuffer.this.m_cb)) {
                throw new EOFException();
            }
            int b = ab[of++] & 0xFF;
            int n = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                if (of >= cb) {
                    throw new EOFException();
                }
                b = ab[of++] & 0xFF;
                n |= (b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                n ^= 0xFFFFFFFF;
            }
            this.setOffsetInternal(of - ofRaw);
            return n;
        }

        @Override
        public long readPackedLong() throws IOException {
            boolean fNeg;
            int cb;
            byte[] ab = AbstractByteArrayReadBuffer.this.m_ab;
            int ofRaw = AbstractByteArrayReadBuffer.this.m_of;
            int of = ofRaw + this.getOffset();
            if (of >= (cb = ofRaw + AbstractByteArrayReadBuffer.this.m_cb)) {
                throw new EOFException();
            }
            int b = ab[of++] & 0xFF;
            long l = b & 0x3F;
            int cBits = 6;
            boolean bl = fNeg = (b & 0x40) != 0;
            while ((b & 0x80) != 0) {
                if (of >= cb) {
                    throw new EOFException();
                }
                b = ab[of++] & 0xFF;
                l |= (long)(b & 0x7F) << cBits;
                cBits += 7;
            }
            if (fNeg) {
                l ^= 0xFFFFFFFFFFFFFFFFL;
            }
            this.setOffsetInternal(of - ofRaw);
            return l;
        }

        @Override
        protected String convertUTF(int of, int cb) throws IOException {
            return ExternalizableHelper.convertUTF(AbstractByteArrayReadBuffer.this.m_ab, AbstractByteArrayReadBuffer.this.m_of + of, cb, this.getCharBuf(cb));
        }
    }
}

