/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.OutputStreaming;
import com.tangosol.util.Base;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DebugDataOutputStream
extends FilterOutputStream
implements DataOutput,
OutputStreaming {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public DebugDataOutputStream(OutputStream stream) {
        super(stream);
        try {
            this.println("::DebugDataOutputStream()");
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] ab) throws IOException {
        this.write(ab, 0, ab.length);
    }

    @Override
    public void write(byte[] ab, int of, int cb) throws IOException {
        if (cb < 0) {
            throw new IndexOutOfBoundsException();
        }
        int cch = cb * 2;
        char[] ach = new char[cch];
        int ofch = 0;
        while (ofch < cch) {
            int n = ab[of] & 0xFF;
            ach[ofch++] = HEX[n >>> 4];
            ach[ofch++] = HEX[n & 0xF];
            ++of;
        }
        this.println("byte[] 0x" + new String(ach));
    }

    @Override
    public void writeBoolean(boolean f) throws IOException {
        this.println("boolean " + String.valueOf(f));
    }

    @Override
    public void writeByte(int b) throws IOException {
        int n = b & 0xFF;
        this.println("byte 0x" + HEX[n >>> 4] + HEX[n & 0xF]);
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.println("short " + String.valueOf(n));
    }

    @Override
    public void writeChar(int ch) throws IOException {
        this.println("char '" + String.valueOf(ch) + '\'');
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.println("int " + String.valueOf(n));
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.println("long " + String.valueOf(l));
    }

    @Override
    public void writeFloat(float fl) throws IOException {
        this.println("float " + String.valueOf(fl));
    }

    @Override
    public void writeDouble(double dfl) throws IOException {
        this.println("double " + String.valueOf(dfl));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.println("String as byte[] \"" + s + '\"');
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.println("String as char[] \"" + s + '\"');
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.println("String as UTF \"" + s + '\"');
    }

    @Override
    public void flush() throws IOException {
        this.println("::flush()");
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.println("::close()");
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
    }

    protected void println(String s) throws IOException {
        OutputStream out = this.out;
        block12: for (char ch : s.toCharArray()) {
            switch (ch) {
                case '\b': {
                    out.write(92);
                    out.write(98);
                    continue block12;
                }
                case '\t': {
                    out.write(92);
                    out.write(116);
                    continue block12;
                }
                case '\n': {
                    out.write(92);
                    out.write(110);
                    continue block12;
                }
                case '\f': {
                    out.write(92);
                    out.write(102);
                    continue block12;
                }
                case '\r': {
                    out.write(92);
                    out.write(114);
                    continue block12;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block12;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    out.write(92);
                    out.write(48);
                    out.write((char)(ch / 8 + 48));
                    out.write((char)(ch % 8 + 48));
                    continue block12;
                }
                default: {
                    switch (Character.getType(ch)) {
                        default: {
                            if (ch > '\u00ff') break;
                            out.write(ch);
                            continue block12;
                        }
                        case 0: 
                        case 15: 
                        case 18: 
                    }
                    char n = ch;
                    out.write(92);
                    out.write(117);
                    out.write(HEX[n >> 12]);
                    out.write(HEX[n >> 8 & 0xF]);
                    out.write(HEX[n >> 4 & 0xF]);
                    out.write(HEX[n & 0xF]);
                }
            }
        }
        out.write(10);
    }

    public static void main(String[] asArg) throws Exception {
        DebugDataOutputStream stream = new DebugDataOutputStream(System.out);
        for (int i = 0; i <= 255; i += 64) {
            stream.write(i);
            stream.writeChar((char)i);
            stream.writeShort((short)(i * i));
            stream.writeInt(i * i);
            stream.writeLong(i * i);
            stream.writeFloat(1.0f / (float)i);
            stream.writeDouble(1.0 / (double)i);
        }
        String s = "start-test \u0007\r\n\b\t\\\ufeff end-test";
        stream.writeBytes(s);
        stream.writeChars(s);
        stream.writeUTF(s);
    }
}

