/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io;

import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.inject.Named;

@Named(value="java")
public final class DefaultSerializer
implements Serializer,
ClassLoaderAware {
    private WeakReference<ClassLoader> m_refLoader;

    public DefaultSerializer() {
    }

    public DefaultSerializer(ClassLoader loader) {
        this.setContextClassLoader(loader);
    }

    @Override
    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        try {
            ExternalizableHelper.writeObject(out, o);
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        try {
            return ExternalizableHelper.readObject(in, this.getContextClassLoader());
        }
        catch (RuntimeException e) {
            IOException ioex = new IOException(e.getMessage());
            ioex.initCause(e);
            throw ioex;
        }
    }

    @Override
    public ClassLoader getContextClassLoader() {
        WeakReference<ClassLoader> refLoader = this.m_refLoader;
        return refLoader == null ? null : (ClassLoader)refLoader.get();
    }

    @Override
    public void setContextClassLoader(ClassLoader loader) {
        assert (this.m_refLoader == null);
        this.m_refLoader = loader == null ? null : new WeakReference<ClassLoader>(loader);
    }

    public String toString() {
        return this.getClass().getName() + " {loader=" + this.getContextClassLoader() + '}';
    }
}

