/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.bdb;

import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.CursorConfig;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.EnvironmentConfig;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.ThreadInterruptedException;
import com.tangosol.io.bdb.BerkeleyDBBinaryStoreManager;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DatabaseFactory
extends Base {
    protected EnvironmentHolder m_envHolder;
    protected DatabaseConfig m_dbConfig = new DatabaseConfig();
    protected long m_cDbId;

    public DatabaseFactory(BerkeleyDBBinaryStoreManager bdbManager) throws DatabaseException {
        this.m_envHolder = this.instantiateEnvironment(bdbManager);
        this.m_dbConfig.setAllowCreate(true);
        this.m_dbConfig.setTransactional(this.m_envHolder.getEnvironment().getConfig().getTransactional());
    }

    public String toString() {
        return "DatabaseFactory { Holder: " + this.getEnvHolder() + " DB Id Counter: " + this.getDbIdCounter() + '}';
    }

    protected void finalize() throws Throwable {
        this.m_envHolder.closeEnvironment(true);
        super.finalize();
    }

    public Database createNamedDatabase(String sName) throws DatabaseException {
        EnvironmentHolder env = this.m_envHolder;
        Database db = env.getEnvironment().openDatabase(null, sName, this.m_dbConfig);
        env.trackDatabase(db);
        return db;
    }

    public synchronized String getUniqueDbName() {
        return Long.toString(this.m_cDbId++);
    }

    protected EnvironmentHolder instantiateEnvironment(BerkeleyDBBinaryStoreManager bdbManager) throws DatabaseException {
        return new EnvironmentHolder(bdbManager);
    }

    public void forgetDatabase(Database db) {
        this.m_envHolder.forgetDatabase(db);
    }

    public EnvironmentHolder getEnvHolder() {
        return this.m_envHolder;
    }

    public DatabaseConfig getDbConfig() {
        return this.m_dbConfig;
    }

    public synchronized long getDbIdCounter() {
        return this.m_cDbId;
    }

    protected static class EnvironmentHolder
    implements Runnable {
        public static final String SUB_DIR_NAME = "coherence" + File.separator + "bdb";
        public static final String ENVIRONMENT_NAME_PREFIX = "bdbtemp";
        public static final String TEMP_FILE_NAME_PREFIX = "cohbdb";
        public static final String JE_PROPERTY_PREFIX = "je.";
        public static final String SLEEPYCAT_JE_PROPERTY_PREFIX = "com.tangosol.internal.sleepycat.je.";
        protected XmlElement m_xmlConfig;
        protected File m_dirParent;
        protected File m_dirEnv;
        protected EnvironmentConfig m_envConfig = new EnvironmentConfig();
        protected Environment m_env;
        protected Collection m_colRegisteredDbs = new LinkedList();
        protected DirectoryLock m_dirLock;
        protected boolean m_fTemporary;
        protected Thread m_threadShutdownHook;

        public EnvironmentHolder(BerkeleyDBBinaryStoreManager bdbManager) throws DatabaseException {
            this.configure(bdbManager);
            if (this.isTemporary()) {
                this.createTemporaryEnvironment();
            } else {
                this.createPersistentEnvironment();
            }
            this.m_threadShutdownHook = Base.makeThread(null, this, "BdbShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.m_threadShutdownHook);
        }

        public String toString() {
            return "EnvironmentHolder { Directory: " + this.getDirEnv() + " Temporary: " + this.isTemporary() + " Config: " + this.getXmlConfig() + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forgetDatabase(Database db) {
            Collection colDbs;
            Collection collection = colDbs = this.m_colRegisteredDbs;
            synchronized (collection) {
                colDbs.remove(db);
            }
        }

        @Override
        public void run() {
            try {
                this.closeEnvironment(false);
            }
            catch (Throwable e) {
                Base.log("Ignoring exception during shutdown: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeEnvironment(boolean fDeregister) {
            File dirEnv;
            DirectoryLock dirLock;
            if (fDeregister) {
                Runtime.getRuntime().removeShutdownHook(this.m_threadShutdownHook);
            }
            boolean fTemporary = this.isTemporary();
            Environment env = this.m_env;
            if (env != null) {
                Collection colDbs;
                Collection collection = colDbs = this.m_colRegisteredDbs;
                synchronized (collection) {
                    if (fTemporary) {
                        Iterator iter = colDbs.iterator();
                        while (iter.hasNext()) {
                            try {
                                ((Database)iter.next()).close();
                            }
                            catch (DatabaseException databaseException) {}
                        }
                    } else {
                        DatabaseEntry dbEntry = new DatabaseEntry();
                        Iterator iter = colDbs.iterator();
                        while (iter.hasNext()) {
                            try {
                                Database db = (Database)iter.next();
                                Cursor csr = db.openCursor(null, CursorConfig.READ_UNCOMMITTED);
                                OperationStatus status = csr.getNext(dbEntry, dbEntry, null);
                                csr.close();
                                if (status == OperationStatus.NOTFOUND) {
                                    String sDbName = db.getDatabaseName();
                                    db.close();
                                    env.removeDatabase(null, sDbName);
                                    continue;
                                }
                                db.close();
                            }
                            catch (DatabaseException db) {}
                        }
                    }
                }
                try {
                    env.close();
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            if ((dirLock = this.m_dirLock) != null) {
                try {
                    dirLock.tryUnlock();
                }
                catch (IOException e) {
                    Base.log("Error releasing lock on Berkeley DB Environment. " + e);
                }
            }
            if ((dirEnv = this.m_dirEnv) != null && fTemporary) {
                File[] aFile = dirEnv.listFiles();
                boolean fErrorReported = false;
                for (File file : aFile) {
                    if (file == null || file.delete() || fErrorReported) continue;
                    fErrorReported = true;
                    Base.log("Error deleting contents of Berkeley DB Environment directory " + dirEnv);
                }
                if (!dirEnv.delete() && !fErrorReported) {
                    Base.log("Error deleting Berkeley DB Environment directory " + dirEnv);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackDatabase(Database db) {
            Collection colDbs;
            Collection collection = colDbs = this.m_colRegisteredDbs;
            synchronized (collection) {
                colDbs.add(db);
            }
        }

        protected void configure(BerkeleyDBBinaryStoreManager bdbManager) {
            List listElement;
            File dirParent = bdbManager.getParentDirectory();
            XmlElement xmlConfig = bdbManager.getConfig();
            this.m_fTemporary = bdbManager.isTemporary();
            if (dirParent == null) {
                dirParent = this.isTemporary() ? new File(this.computeTmpDir(), SUB_DIR_NAME) : new File((File)null, SUB_DIR_NAME);
            }
            if (dirParent.isFile()) {
                throw new IllegalArgumentException("The specified parent directory for Berkeley DB \"" + dirParent + "\" is a file.");
            }
            this.m_dirParent = dirParent;
            EnvironmentConfig envConfig = this.m_envConfig;
            this.m_xmlConfig = xmlConfig;
            envConfig.setAllowCreate(true);
            envConfig.setCachePercent(1);
            if (!this.isTemporary()) {
                envConfig.setTransactional(true);
            }
            if (xmlConfig != null && !(listElement = xmlConfig.getElementList()).isEmpty()) {
                for (XmlElement xmlParam : listElement) {
                    String sKey = xmlParam.getName();
                    if (!sKey.startsWith(JE_PROPERTY_PREFIX) && !sKey.startsWith(SLEEPYCAT_JE_PROPERTY_PREFIX)) continue;
                    envConfig.setConfigParam(sKey, xmlParam.getString());
                }
            }
        }

        protected File computeTmpDir() {
            try {
                File fileTmp = File.createTempFile(TEMP_FILE_NAME_PREFIX, null);
                fileTmp.delete();
                return fileTmp.getParentFile();
            }
            catch (IOException e) {
                return null;
            }
        }

        protected void createTemporaryEnvironment() throws DatabaseException {
            File dirEnv = null;
            try {
                DirectoryLock dirLock;
                File dirParent = this.m_dirParent;
                while (true) {
                    if ((dirEnv = new File(dirParent, this.generateEnvironmentName())).exists()) {
                        continue;
                    }
                    if (!dirEnv.mkdirs()) {
                        throw new IllegalStateException("Unable to create TemporaryEnvironment directory " + dirEnv);
                    }
                    dirLock = new DirectoryLock(dirEnv, "Locked Coherence temporary Berkeley DB directory, will be auto-deleted.");
                    if (dirLock.tryLock()) break;
                }
                this.m_env = new Environment(dirEnv, this.m_envConfig);
                this.m_dirEnv = dirEnv;
                this.m_dirLock = dirLock;
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e, "Error locking directory " + dirEnv);
            }
        }

        protected void createPersistentEnvironment() throws DatabaseException {
            this.m_dirEnv = this.m_dirParent;
            File dirEnv = this.m_dirEnv;
            if (!dirEnv.exists() && !dirEnv.mkdirs()) {
                throw new IllegalStateException("Unable to create Environment directory " + dirEnv);
            }
            DirectoryLock dirLock = new DirectoryLock(dirEnv, "Locked Coherence persistent Berkeley DB directory.");
            try {
                if (!dirLock.tryLock()) {
                    throw new UnsupportedOperationException("Unable to open environment " + dirEnv + " already locked.");
                }
                this.m_env = new Environment(dirEnv, this.m_envConfig);
                this.m_dirEnv = dirEnv;
                this.m_dirLock = dirLock;
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException(e, "Error locking directory " + dirEnv);
            }
        }

        protected String generateEnvironmentName() {
            return ENVIRONMENT_NAME_PREFIX + Base.getRandom().nextInt();
        }

        public Environment getEnvironment() throws DatabaseException {
            try {
                this.m_env.getDatabaseNames();
            }
            catch (ThreadInterruptedException e) {
                this.closeEnvironment(false);
                if (this.isTemporary()) {
                    this.createTemporaryEnvironment();
                }
                this.createPersistentEnvironment();
            }
            return this.m_env;
        }

        public XmlElement getXmlConfig() {
            return this.m_xmlConfig;
        }

        public File getDirParent() {
            return this.m_dirParent;
        }

        public File getDirEnv() {
            return this.m_dirEnv;
        }

        public EnvironmentConfig getEnvConfig() {
            return this.m_envConfig;
        }

        public Collection getRegisteredDbs() {
            return this.m_colRegisteredDbs;
        }

        public DirectoryLock getDirLock() {
            return this.m_dirLock;
        }

        public boolean isTemporary() {
            return this.m_fTemporary;
        }

        protected static class DirectoryLock {
            public static final String LOCK_FILE_NAME = "coherence.lck";
            protected File m_dir;
            protected FileOutputStream m_fstreamLocked;
            protected FileLock m_lockDir;
            protected String m_sLockText;

            public DirectoryLock(File dir, String sLockText) {
                this.m_dir = dir;
                this.m_sLockText = sLockText;
            }

            public boolean tryLock() throws IOException {
                FileLock lockDir;
                File fileLocked = new File(this.m_dir, LOCK_FILE_NAME);
                FileOutputStream fstreamLocked = new FileOutputStream(fileLocked);
                try {
                    lockDir = fstreamLocked.getChannel().tryLock();
                }
                catch (IOException e) {
                    fstreamLocked.close();
                    throw e;
                }
                if (lockDir == null) {
                    fstreamLocked.close();
                    return false;
                }
                if (this.m_sLockText != null) {
                    PrintStream pstreamLocked = new PrintStream(fstreamLocked);
                    pstreamLocked.println(this.m_sLockText);
                    pstreamLocked.flush();
                }
                this.m_fstreamLocked = fstreamLocked;
                this.m_lockDir = lockDir;
                return true;
            }

            public boolean tryUnlock() throws IOException {
                if (this.m_lockDir == null) {
                    return false;
                }
                this.m_lockDir.release();
                this.m_lockDir = null;
                this.m_fstreamLocked.close();
                File fileLocked = new File(this.m_dir, LOCK_FILE_NAME);
                fileLocked.delete();
                return true;
            }

            protected void finalize() throws Throwable {
                this.tryUnlock();
                super.finalize();
            }
        }
    }
}

