/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.generator;

import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.io.pof.generator.PofConfigGenerator;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

public class Executor {
    protected static final String[] COMMANDS = new String[]{"root", "out", "config", "include", "packages", "startTypeId", "help"};
    protected String[] m_asArguments;

    public void execute() {
        String[] stringArray;
        String[] asArgs = this.getArguments();
        ListMap mapArgs = CommandLineTool.parseArguments(asArgs, COMMANDS, true);
        if (mapArgs.containsKey("help")) {
            this.usage(null);
            return;
        }
        String sRoot = (String)mapArgs.get("root");
        if (sRoot == null) {
            this.usage("-root is a mandatory argument");
            return;
        }
        String sPackages = (String)mapArgs.get("packages");
        if (sPackages == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = sPackages.split(",");
        }
        HashSet<String> setPackages = new HashSet<String>(Arrays.asList(stringArray));
        Integer ITypeId = null;
        String sTypeId = (String)mapArgs.get("startTypeId");
        if (sTypeId != null && !sTypeId.isEmpty()) {
            try {
                ITypeId = Integer.parseInt(sTypeId);
            }
            catch (NumberFormatException e) {
                this.usage("-startTypeId must be a valid integer");
            }
        }
        PofConfigGenerator.Dependencies deps = new PofConfigGenerator.Dependencies().setPathRoot(Arrays.asList(sRoot.split(File.pathSeparator))).setOutputPath((String)mapArgs.get("out")).setPofConfig((String)mapArgs.get("config")).setInclude(mapArgs.containsKey("include")).setPackages(setPackages).setStartTypeId(ITypeId);
        CacheFactory.log("Generating POF Configuration...", 0);
        PofConfigGenerator generator = this.createPofConfigGenerator(deps);
        generator.generate();
        try {
            CacheFactory.log("POF Configuration generated: " + new File(generator.getWrittenPath()).getCanonicalPath(), 0);
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "Error in generating POF configuration");
        }
    }

    public String[] getArguments() {
        return this.m_asArguments;
    }

    public Executor setArguments(String[] asArgs) {
        this.m_asArguments = asArgs;
        return this;
    }

    protected PofConfigGenerator createPofConfigGenerator(PofConfigGenerator.Dependencies deps) {
        return new PofConfigGenerator(deps);
    }

    protected void usage(String sMsg) {
        StringBuilder sb = new StringBuilder();
        sb.append("POF Configuration Generator\n").append("Copyright (C) Oracle Coherence\n").append("http://coherence.oracle.com\n\n");
        if (sMsg != null) {
            sb.append("Error: ").append(sMsg).append("\n\n");
        }
        sb.append("POF Configuration Generator is tool to generate a POF configuration XML file.\n").append("The configuration is generated based upon scanning a referenced directory\n").append("or the classpath of this application for classes annotated with a Portable\n").append("annotation.\n\n");
        sb.append("Usage: pof-config-gen.sh  [OPTIONS] -root\n").append("  or   pof-config-gen.bat [OPTIONS] -root\n").append("  or   java ").append(this.getClass().getName()).append(" [OPTIONS] -root\n").append("Search for all classes annotated with Portable outputting the generated file\n").append("to specified (-out) directory or the current working directory.\n").append("Example: pof-config-gen.sh -root /tmp/jar-folder\n\n");
        sb.append("Required\n").append("  -root           root may be one of the following:\n").append("                    a path separator separated string of directories or jar\n").append("                    files\n").append("                    a directory containing jar files or the root of classes\n").append("                    a jar file\n").append("                    a gar file\n\n").append("Options\n").append("  -out            destination of the generated file. Either a file or \n").append("                  directory with the current working directory as the\n").append("                  default\n").append("  -config         a POF Configuration file to honor user types\n").append("  -include        indicates to include the previous POF configuration\n").append("                  by reference opposed to inline the user types\n").append("  -packages       comma separated list of packages to scan for\n").append("  -startTypeId    the user type id to start allocations from\n").append("  -help           show this help\n");
        CacheFactory.log(sb.toString(), 0);
    }

    public static void main(String[] asArgs) {
        System.setProperty("coherence.log.level", "0");
        new Executor().setArguments(asArgs).execute();
    }
}

