/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof.reflect.internal;

import com.tangosol.io.pof.reflect.internal.InvocationStrategy;
import com.tangosol.util.Base;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvocationStrategies {

    public static class MethodInvocationStrategy<PT, T>
    implements InvocationStrategy<PT, T> {
        private Method m_methGetter;
        private Method m_methSetter;

        public MethodInvocationStrategy(Method method) {
            Method methGet = null;
            Method methSet = null;
            if (method != null) {
                Method methComp = this.getCompliment(method);
                boolean fSetter = method.getReturnType() == null || Void.TYPE.equals(method.getReturnType());
                methGet = fSetter ? methComp : method;
                methSet = fSetter ? method : methComp;
            }
            this.initialize(methGet, methSet);
        }

        public MethodInvocationStrategy(Method methGetter, Method methSetter) {
            this.initialize(methGetter, methSetter);
        }

        @Override
        public T get(PT container) {
            Object value;
            try {
                value = this.m_methGetter.invoke(container, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata accessor is unable to access get accessor " + this.m_methGetter.getName());
            }
            catch (InvocationTargetException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata received an error when attempting to access get accessor " + this.m_methGetter.getName());
            }
            return (T)value;
        }

        @Override
        public void set(PT container, T value) {
            try {
                if (value != null || !this.m_methSetter.getParameterTypes()[0].isPrimitive()) {
                    this.m_methSetter.invoke(container, value);
                }
            }
            catch (IllegalAccessException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata accessor is unable to access set accessor" + this.m_methSetter.getName());
            }
            catch (InvocationTargetException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata accessor is unable to invoke set accessor" + this.m_methSetter.getName() + " with value " + value);
            }
        }

        public Class<T> getType() {
            return this.m_methGetter.getReturnType();
        }

        protected Method getCompliment(Method method) {
            Method methComp;
            if (method == null) {
                return null;
            }
            int nSetter = 0;
            if (method.getReturnType() == null || Void.TYPE.equals(method.getReturnType())) {
                if (method.getParameterTypes().length <= 0) {
                    throw new IllegalArgumentException("Method (" + method + ") should have a parameter");
                }
                nSetter = Boolean.TYPE.equals(method.getParameterTypes()[0]) || Boolean.class.equals(method.getParameterTypes()[0]) ? 2 : 1;
            }
            String sMethodName = String.format("%s%s", nSetter == 2 ? "is" : (nSetter == 1 ? "get" : "set"), method.getName().substring(method.getName().startsWith("is") ? 2 : 3));
            try {
                methComp = nSetter == 0 ? method.getDeclaringClass().getDeclaredMethod(sMethodName, method.getReturnType()) : method.getDeclaringClass().getDeclaredMethod(sMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw Base.ensureRuntimeException(e, "An error occurred in discovering the compliment of method = " + method + ", assuming compliment method name is " + sMethodName);
            }
            if (methComp == null) {
                throw Base.ensureRuntimeException(new NoSuchMethodException("Could not derive the compliment method of " + method + ", assuming compliment method name is " + sMethodName));
            }
            return methComp;
        }

        protected void initialize(Method methGetter, Method methSetter) {
            if (methGetter == null || methSetter == null) {
                throw new IllegalArgumentException("The getter or setter can not be null in constructing a MethodInvocationStrategy");
            }
            this.ensureAccessible(methGetter);
            this.ensureAccessible(methSetter);
            this.m_methGetter = methGetter;
            this.m_methSetter = methSetter;
        }

        protected void ensureAccessible(Method method) {
            if ((method.getModifiers() & 1) != 1) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException se) {
                    throw new IllegalArgumentException("A security manager has been registered with access to method " + method.getName() + " being rejected", se);
                }
            }
        }
    }

    public static class FieldInvocationStrategy<PT, T>
    implements InvocationStrategy<PT, T> {
        private final Field m_field;

        public FieldInvocationStrategy(Field field) {
            if (field == null) {
                throw new IllegalArgumentException("A non-null field must be supplied to a FieldInvocationStrategy");
            }
            this.m_field = field;
            if ((field.getModifiers() & 1) != 1) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException se) {
                    throw new IllegalArgumentException("A security manager has been registered with access to field " + field.getName() + "being rejected", se);
                }
            }
        }

        @Override
        public T get(PT container) {
            try {
                return (T)this.m_field.get(container);
            }
            catch (IllegalAccessException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata accessor is unable to access field " + this.m_field.getName());
            }
        }

        @Override
        public void set(PT container, T value) {
            try {
                if (value != null || !this.m_field.getType().isPrimitive()) {
                    this.m_field.set(container, value);
                }
            }
            catch (IllegalAccessException e) {
                throw Base.ensureRuntimeException(e, "AttributeMetadata accessor is unable to set field " + this.m_field.getName() + " to value " + value);
            }
        }
    }
}

