/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.license;

import com.tangosol.coherence.config.Config;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.UID;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ProcessorInfo
extends Base {
    protected String m_sUid;
    protected Map m_mapEnv;
    protected Map[] m_amapCpu;
    protected int m_cSocket;
    protected int m_cCpu;
    protected Map[] m_amapCpuTemplate;
    protected boolean m_fForceLookup = Config.getBoolean("coherence.cpu.forcelookup");
    protected boolean m_fVerbose = Config.getBoolean("coherence.cpu.verbose");
    public static final String ENVIRONMENT = "environment";
    public static final String DESCRIPTION = "description";
    public static final String ARCHITECTURE = "architecture";
    public static final String VENDOR = "vendor";
    public static final String COHERENCE_UID = "coherence-uid";
    public static final String FAMILY = "family";
    public static final String MODEL = "model";
    public static final String STEPPING = "stepping";
    public static final String EXECUTION_UNITS = "execution-units";
    public static final String DICTIONARY_XML = "processor-dictionary.xml";
    public static final String MACHINE = "machine";
    public static final String DICTIONARY = "processor-dictionary";
    public static final String DESCRIPTOR = "processor-descriptor";
    public static final String TEMPLATE = "processor-template";
    public static final String SIGNATURE = "signature";

    public ProcessorInfo() {
        this.inspectMachine();
    }

    public ProcessorInfo(UID uid) {
        this.m_sUid = uid.toString();
        this.inspectMachine();
    }

    public ProcessorInfo(Map[] amapCpu) {
        this.loadDictionary();
        this.m_amapCpu = amapCpu;
        this.m_cSocket = this.getSocketCount(amapCpu);
        this.m_cCpu = this.computeCpuCount(amapCpu.length);
    }

    public Map[] getDescriptors() {
        return (Map[])this.m_amapCpu.clone();
    }

    public int getExecutionUnitCount() {
        return this.getExecutionUnitCount(this.m_amapCpu);
    }

    public int getSocketCount() {
        return this.m_cSocket;
    }

    public int getCpuCount() {
        return this.m_cCpu;
    }

    public String toString() {
        int cSockets = this.getSocketCount();
        int cUnits = this.getExecutionUnitCount();
        int cCpus = this.getCpuCount();
        StringBuffer sb = new StringBuffer().append(this.toXml()).append("\n\n<!-- Machine has ").append(this.getExecutionUnitCount()).append(" total cores");
        if (cUnits > cCpus) {
            sb.append(" (").append(cUnits - cCpus).append(" virtual)");
        }
        sb.append(" on ").append(cSockets).append(" sockets -->\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDictionary() {
        Signature signature;
        XmlDocument xmlDoc;
        SimpleParser sp = new SimpleParser();
        ClassLoader cl = Base.class.getClassLoader();
        if (cl == null) {
            cl = ProcessorInfo.getContextClassLoader();
        }
        InputStream in = null;
        try {
            in = cl.getResourceAsStream(DICTIONARY_XML);
            if (in == null) {
                throw new Exception("processor-dictionary.xml not found");
            }
            xmlDoc = sp.parseXml(in);
            if (!xmlDoc.getName().equals(DICTIONARY)) {
                throw new Exception("processor-dictionary.xml does not contain processor-dictionary element");
            }
        }
        catch (Exception e) {
            ProcessorInfo.log("Error loading processor-dictionary.xml: " + e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            in = cl.getResourceAsStream("tangosol.cer");
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(in);
            signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(cert.getPublicKey());
        }
        catch (Exception e) {
            ProcessorInfo.log("Error during signature preparation: " + e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException cert) {}
            }
        }
        ArrayList<Map> listTemplates = new ArrayList<Map>();
        Iterator i = xmlDoc.getElements(TEMPLATE);
        while (i.hasNext()) {
            XmlElement xml = (XmlElement)i.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            List list = xml.getElementList();
            StringBuffer sbConcat = new StringBuffer();
            XmlElement xmlExUnits = null;
            String sSig = null;
            ListIterator j = list.listIterator();
            while (j.hasNext()) {
                XmlElement xmlSub = (XmlElement)j.next();
                String sName = xmlSub.getName();
                String sValue = xmlSub.getString();
                if (sName.equals(SIGNATURE)) {
                    sSig = sValue;
                    continue;
                }
                sbConcat.append(xmlSub);
                if (sName.equals(EXECUTION_UNITS)) {
                    xmlExUnits = xmlSub;
                }
                if (xmlSub.getSafeAttribute("regex").getBoolean()) {
                    Pattern pat = Pattern.compile(sValue);
                    map.put(sName, pat);
                    continue;
                }
                map.put(sName, sValue);
            }
            if (sSig == null || xmlExUnits == null) continue;
            try {
                ByteArrayOutputStream streamRaw = new ByteArrayOutputStream();
                DataOutputStream streamSig = new DataOutputStream(streamRaw);
                streamSig.writeUTF(sbConcat.toString());
                signature.update(streamRaw.toByteArray());
                if (signature.verify(Base.parseHex(sSig))) {
                    listTemplates.add(map);
                    int cThreads = xmlExUnits.getSafeAttribute("thread-count").getInt(0);
                    int cExUnits = xmlExUnits.getInt(0);
                    if (cThreads <= 0) continue;
                    Map mapClone = (Map)map.clone();
                    mapClone.put(EXECUTION_UNITS, Integer.toString(cExUnits - cThreads));
                    listTemplates.add(mapClone);
                    continue;
                }
                ProcessorInfo.log("Skipping processor template with invalid signature:\n" + xml);
            }
            catch (Exception e) {
                if (!this.m_fVerbose) continue;
                ProcessorInfo.log("Error while validating template:\n" + xml);
                ProcessorInfo.log(e);
            }
        }
        this.m_amapCpuTemplate = listTemplates.toArray(new Map[listTemplates.size()]);
    }

    protected String getEnv(String sEnvName) {
        if (this.m_mapEnv == null) {
            try {
                return System.getenv(sEnvName);
            }
            catch (Throwable e) {
                if (this.m_fVerbose) {
                    ProcessorInfo.log("getEnv unavailable: " + e);
                    ProcessorInfo.log(e);
                }
                try {
                    Runtime rt = Runtime.getRuntime();
                    String[] asCmd = System.getProperty("os.name").indexOf("Windows") == -1 ? new String[]{"sh", "-c", "set"} : new String[]{"cmd", "/c", "set"};
                    Process proc = rt.exec(asCmd);
                    InputStream in = proc.getInputStream();
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
                    HashMap<String, String> mapEnv = new HashMap<String, String>();
                    String sLine = reader.readLine();
                    while (sLine != null) {
                        int ofEq = sLine.indexOf(61);
                        if (ofEq > 0 && ofEq + 1 < sLine.length()) {
                            String sName = sLine.substring(0, ofEq).trim();
                            String sValue = sLine.substring(ofEq + 1).trim();
                            mapEnv.put(sName.toUpperCase(), sValue);
                        }
                        sLine = reader.readLine();
                    }
                    this.m_mapEnv = mapEnv;
                }
                catch (Exception e2) {
                    if (this.m_fVerbose) {
                        ProcessorInfo.log("Environment variables unavailable: " + e2);
                        ProcessorInfo.log(e2);
                    }
                    try {
                        this.m_mapEnv = System.getProperties();
                    }
                    catch (Exception e22) {
                        if (this.m_fVerbose) {
                            ProcessorInfo.log("System property map unavailable: " + e2);
                            ProcessorInfo.log(e2);
                        }
                        return System.getProperty(sEnvName.toUpperCase());
                    }
                }
            }
        }
        return (String)this.m_mapEnv.get(sEnvName.toUpperCase());
    }

    protected Map[] inspectWindows() {
        Map<String, String> mapInfo = new HashMap<String, String>();
        mapInfo.put(ENVIRONMENT, "Windows");
        mapInfo.put(ARCHITECTURE, this.getEnv("PROCESSOR_ARCHITECTURE"));
        if (this.m_sUid != null) {
            mapInfo.put(COHERENCE_UID, this.m_sUid);
        }
        String sId = this.getEnv("PROCESSOR_IDENTIFIER");
        mapInfo.put(DESCRIPTION, sId);
        String[] sTok = sId.split(" |,");
        int cTokens = sTok.length;
        mapInfo.put(VENDOR, sTok[cTokens - 1]);
        for (int i = 0; i < cTokens; ++i) {
            if (sTok[i].equals("Family") && i + 1 < cTokens) {
                mapInfo.put(FAMILY, sTok[++i]);
                continue;
            }
            if (sTok[i].equals("Model") && i + 1 < cTokens) {
                mapInfo.put(MODEL, sTok[++i]);
                continue;
            }
            if (!sTok[i].equals("Stepping") || i + 1 >= cTokens) continue;
            mapInfo.put(STEPPING, sTok[++i]);
        }
        mapInfo = Collections.unmodifiableMap(mapInfo);
        Object[] amapCpu = new Map[Runtime.getRuntime().availableProcessors()];
        Arrays.fill(amapCpu, mapInfo);
        return amapCpu;
    }

    protected Map[] inspectLinux() throws Exception {
        FileInputStream in = new FileInputStream("/proc/cpuinfo");
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
        String sArch = System.getProperty("os.arch");
        ArrayList listInfo = new ArrayList();
        HashMap<String, String> mapInfo = null;
        String sLine = reader.readLine();
        while (sLine != null) {
            int iColon = sLine.indexOf(58);
            if (iColon > 0 && iColon + 1 < sLine.length()) {
                String sName = sLine.substring(0, iColon).trim();
                String sValue = sLine.substring(iColon + 1).trim();
                if (sName.equals("processor")) {
                    if (mapInfo != null) {
                        listInfo.add(Collections.unmodifiableMap(mapInfo));
                    }
                    mapInfo = new HashMap<String, String>();
                    mapInfo.put(ENVIRONMENT, "Linux");
                    mapInfo.put(ARCHITECTURE, sArch);
                    if (this.m_sUid != null) {
                        mapInfo.put(COHERENCE_UID, this.m_sUid);
                    }
                } else if (sName.equals("vendor_id")) {
                    mapInfo.put(VENDOR, sValue);
                } else if (sName.equals("cpu family")) {
                    mapInfo.put(FAMILY, sValue);
                } else if (sName.equals(MODEL)) {
                    mapInfo.put(MODEL, sValue);
                } else if (sName.equals(STEPPING)) {
                    mapInfo.put(STEPPING, sValue);
                } else if (sName.equals("cpu cores")) {
                    mapInfo.put(EXECUTION_UNITS, sValue);
                } else {
                    sName = sName.replace(' ', '-');
                    mapInfo.put(sName, sValue);
                }
            }
            sLine = reader.readLine();
        }
        in.close();
        if (mapInfo != null) {
            listInfo.add(Collections.unmodifiableMap(mapInfo));
        }
        return listInfo.toArray(new Map[listInfo.size()]);
    }

    protected Map[] inspectJava() {
        Map<String, String> mapInfo = new HashMap<String, String>();
        mapInfo.put(ENVIRONMENT, System.getProperty("os.name"));
        mapInfo.put(ARCHITECTURE, System.getProperty("os.arch"));
        if (this.m_sUid != null) {
            mapInfo.put(COHERENCE_UID, this.m_sUid);
        }
        mapInfo = Collections.unmodifiableMap(mapInfo);
        Object[] amapCpu = new Map[Runtime.getRuntime().availableProcessors()];
        Arrays.fill(amapCpu, mapInfo);
        return amapCpu;
    }

    public void inspectMachine() {
        try {
            Map[] amapCpu;
            block8: {
                this.loadDictionary();
                amapCpu = null;
                try {
                    String sOs = System.getProperty("os.name");
                    if (sOs.indexOf("Windows") != -1) {
                        amapCpu = this.inspectWindows();
                    } else if (sOs.indexOf("Linux") != -1) {
                        amapCpu = this.inspectLinux();
                    }
                }
                catch (Throwable e) {
                    if (!this.m_fVerbose) break block8;
                    ProcessorInfo.log("Error in OS specific analysis falling back on pure Java approach: " + e);
                    ProcessorInfo.log(e);
                }
            }
            if (amapCpu == null || amapCpu.length == 0) {
                amapCpu = this.inspectJava();
            }
            int cCfgSocket = Config.getInteger("coherence.socket", 1);
            int cCfgCpu = Config.getInteger("coherence.cpu", 1);
            this.m_amapCpu = amapCpu;
            this.m_cSocket = Math.max(cCfgSocket, this.getSocketCount(amapCpu));
            this.m_cCpu = Math.max(cCfgCpu, this.computeCpuCount(Runtime.getRuntime().availableProcessors()));
        }
        catch (Throwable t) {
            ProcessorInfo.log("unable to identify processor info");
            ProcessorInfo.log(t);
            this.m_cSocket = this.m_cCpu = Runtime.getRuntime().availableProcessors();
        }
    }

    public XmlElement toXml() {
        Map[] amapCpu = this.m_amapCpu;
        SimpleElement xmlRoot = new SimpleElement(MACHINE);
        List listXml = xmlRoot.getElementList();
        int c = amapCpu.length;
        for (int i = 0; i < c; ++i) {
            listXml.add(ProcessorInfo.toXml(DESCRIPTOR, amapCpu[i]));
        }
        return xmlRoot;
    }

    public static XmlElement toXml(String sParent, Map map) {
        SimpleElement xml = new SimpleElement(sParent);
        for (Map.Entry entry : map.entrySet()) {
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (oKey == null || oValue == null) continue;
            xml.addElement(oKey.toString()).setString(oValue.toString());
        }
        return xml;
    }

    public static Map[] fromXml(XmlElement xmlDoc) {
        if (xmlDoc == null) {
            return null;
        }
        ArrayList listMaps = new ArrayList();
        Iterator i = xmlDoc.getElements(DESCRIPTOR);
        while (i.hasNext()) {
            XmlElement xml = (XmlElement)i.next();
            HashMap<String, Object> map = new HashMap<String, Object>();
            List list = xml.getElementList();
            ListIterator j = list.listIterator();
            while (j.hasNext()) {
                XmlElement xmlSub = (XmlElement)j.next();
                map.put(xmlSub.getName(), xmlSub.getValue());
            }
            listMaps.add(map);
        }
        return listMaps.toArray(new Map[listMaps.size()]);
    }

    public int getSocketCount(Map[] amapCpu) {
        if (amapCpu == null) {
            return 1;
        }
        try {
            int cSocket;
            block2: while (true) {
                int cCpus = amapCpu.length;
                int[] acUnits = new int[cCpus];
                for (int i = 0; i < cCpus; ++i) {
                    acUnits[i] = this.lookupExecutionUnits(amapCpu[i]);
                }
                cSocket = 0;
                for (int i = 0; i < cCpus; ++i) {
                    int cUnits = acUnits[i];
                    if (cUnits <= 0) continue;
                    ++cSocket;
                    int cClones = cUnits - 1;
                    for (int j = i + 1; j < cCpus && cClones > 0; ++j) {
                        if (acUnits[j] != cUnits) continue;
                        acUnits[j] = 0;
                        --cClones;
                    }
                    if (cClones <= 0) continue;
                    if (this.m_fVerbose) {
                        ProcessorInfo.log("Missing " + cClones + " siblings for " + ProcessorInfo.toXml(DESCRIPTOR, amapCpu[i]));
                    }
                    if (this.removeDefinition(amapCpu[i])) {
                        if (!this.m_fVerbose) continue block2;
                        ProcessorInfo.log("Definition dropped, rechecking");
                        continue block2;
                    }
                    ProcessorInfo.log("Unable to resolve " + cClones + " siblings for " + ProcessorInfo.toXml(DESCRIPTOR, amapCpu[i]));
                    return Math.max(cCpus, 1);
                }
                break;
            }
            return Math.max(cSocket, 1);
        }
        catch (Throwable e) {
            if (this.m_fVerbose) {
                ProcessorInfo.log("Error in matching CPUs: " + e);
                ProcessorInfo.log(e);
            }
            return Math.max(amapCpu.length, 1);
        }
    }

    protected int computeCpuCount(int cCores) {
        block4: {
            try {
                int nFactor;
                if (cCores % 2 == 0 && Config.getBoolean("coherence.smt.enabled")) {
                    return Math.max(cCores >>> 1, 1);
                }
                String sFactor = Config.getProperty("coherence.smt.factor");
                if (sFactor != null && cCores % (nFactor = Integer.parseInt(sFactor)) == 0) {
                    return Math.max(cCores / nFactor, 1);
                }
            }
            catch (Throwable e) {
                if (!this.m_fVerbose) break block4;
                ProcessorInfo.log("Error in counting physical cores: " + e);
                ProcessorInfo.log(e);
            }
        }
        return Math.max(cCores, 1);
    }

    public Map lookupCpu(Map mapCpu) {
        Map[] amapTemplate = this.m_amapCpuTemplate;
        if (amapTemplate == null) {
            return null;
        }
        if (this.m_fVerbose) {
            ProcessorInfo.log("Searching for matching template for CPU:\n" + ProcessorInfo.toXml(DESCRIPTOR, mapCpu));
        }
        Map mapMatch = null;
        int c = amapTemplate.length;
        int cMatchSize = 0;
        block0: for (int i = 0; i < c; ++i) {
            Map mapTemplate = amapTemplate[i];
            if (mapTemplate == null || mapTemplate.size() <= cMatchSize) continue;
            for (Map.Entry entry : mapTemplate.entrySet()) {
                String sDescriptorValue;
                boolean fMatch;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                if (oKey.equals(EXECUTION_UNITS) || (fMatch = (sDescriptorValue = (String)mapCpu.get(oKey)) != null && (oValue instanceof String && oValue.equals(sDescriptorValue) || oValue instanceof Pattern && ((Pattern)oValue).matcher(sDescriptorValue).matches()))) continue;
                continue block0;
            }
            if (this.m_fVerbose) {
                if (mapMatch == null) {
                    ProcessorInfo.log("Found matching template\n" + ProcessorInfo.toXml(TEMPLATE, mapTemplate));
                } else {
                    ProcessorInfo.log("Found better match\n" + ProcessorInfo.toXml(TEMPLATE, mapTemplate));
                }
            }
            cMatchSize = mapTemplate.size();
            mapMatch = mapTemplate;
        }
        if (mapMatch == null && this.m_fVerbose) {
            ProcessorInfo.log("No matching template found");
        }
        return mapMatch;
    }

    public int lookupExecutionUnits(Map mapCpu) {
        String sUnits;
        if (mapCpu == null) {
            return 0;
        }
        String string = sUnits = this.m_fForceLookup ? null : (String)mapCpu.get(EXECUTION_UNITS);
        if (sUnits == null) {
            Map mapMatch = this.lookupCpu(mapCpu);
            if (mapMatch != null) {
                sUnits = (String)mapMatch.get(EXECUTION_UNITS);
            }
        } else if (this.m_fVerbose) {
            ProcessorInfo.log("Using descriptor supplied execution units of " + sUnits);
        }
        return sUnits == null ? 1 : Integer.parseInt(sUnits);
    }

    public boolean removeDefinition(Map mapCpu) {
        Map[] amapTemplate = this.m_amapCpuTemplate;
        Map mapMatch = this.lookupCpu(mapCpu);
        if (mapMatch != null) {
            int c = amapTemplate.length;
            for (int i = 0; i < c; ++i) {
                if (amapTemplate[i] != mapMatch) continue;
                amapTemplate[i] = null;
                return true;
            }
        }
        return false;
    }

    public int getExecutionUnitCount(Map[] amapCpu) {
        return amapCpu == null ? 0 : amapCpu.length;
    }

    public static void log(String sMsg) {
        CacheFactory.log(sMsg, 7);
    }

    public static void log(Throwable t) {
        ProcessorInfo.log(ProcessorInfo.printStackTrace(t));
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            try {
                FileInputStream in = new FileInputStream(asArg[0]);
                SimpleParser sp = new SimpleParser();
                System.out.println(new ProcessorInfo(ProcessorInfo.fromXml(sp.parseXml(in))));
            }
            catch (IOException e) {
                ProcessorInfo.log("Error reading " + asArg[0] + ": " + e);
            }
        } else {
            System.out.println(new ProcessorInfo());
        }
    }
}

