/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.internal.net.DemultiplexedSocketProvider;
import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.SSLSettings;
import com.oracle.coherence.common.net.SSLSocketProvider;
import com.oracle.coherence.common.net.SdpSocketProvider;
import com.oracle.coherence.common.net.SocketProvider;
import com.oracle.coherence.common.net.TcpSocketProvider;
import com.tangosol.coherence.config.builder.SSLSocketProviderDependenciesBuilder;
import com.tangosol.coherence.config.builder.SocketProviderBuilder;
import com.tangosol.internal.net.LegacyXmlSocketProviderFactoryDependencies;
import com.tangosol.internal.net.ssl.LegacyXmlSSLSocketProviderDependencies;
import com.tangosol.net.DatagramSocketProvider;
import com.tangosol.net.SystemDatagramSocketProvider;
import com.tangosol.net.TcpDatagramSocketProvider;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.SafeHashMap;
import java.io.IOException;
import java.net.MulticastSocket;
import java.util.Map;

public class SocketProviderFactory {
    protected Map m_mapSocketProvider = new SafeHashMap();
    protected Map m_mapDatagramSocketProvider = new SafeHashMap();
    protected Dependencies m_Dependencies;
    public static final SocketProvider DEFAULT_SOCKET_PROVIDER = TcpSocketProvider.MULTIPLEXED;
    public static final SocketProvider DEFAULT_LEGACY_SOCKET_PROVIDER = TcpSocketProvider.DEMULTIPLEXED;
    public static final DatagramSocketProvider DEFAULT_DATAGRAM_SOCKET_PROVIDER = SystemDatagramSocketProvider.INSTANCE;
    public static final String UNNAMED_PROVIDER_ID = "";

    public SocketProviderFactory() {
        this(null);
    }

    public SocketProviderFactory(Dependencies dependencies) {
        this.m_Dependencies = dependencies == null ? new DefaultDependencies() : dependencies;
        this.m_Dependencies.setSocketProviderFactory(this);
    }

    public Dependencies getDependencies() {
        return this.m_Dependencies;
    }

    @Deprecated
    public SocketProvider getLegacySocketProvider(XmlElement xml) {
        String sId = LegacyXmlSocketProviderFactoryDependencies.getProviderId(xml);
        if (sId == null) {
            return DEFAULT_LEGACY_SOCKET_PROVIDER;
        }
        if (sId.equals(UNNAMED_PROVIDER_ID)) {
            LegacyXmlSocketProviderFactoryDependencies depsUnnamed = new LegacyXmlSocketProviderFactoryDependencies(sId, xml);
            depsUnnamed.setSocketProviderFactory(this);
            return this.ensureSocketProvider(sId, depsUnnamed, -1);
        }
        return this.ensureSocketProvider(sId, this.getDependencies(), -1);
    }

    @Deprecated
    public SocketProvider getSocketProvider(XmlElement xml) {
        String sId = LegacyXmlSocketProviderFactoryDependencies.getProviderId(xml);
        if (sId == null) {
            return DEFAULT_SOCKET_PROVIDER;
        }
        if (sId.equals(UNNAMED_PROVIDER_ID)) {
            LegacyXmlSocketProviderFactoryDependencies depsUnnamed = new LegacyXmlSocketProviderFactoryDependencies(sId, xml);
            depsUnnamed.setSocketProviderFactory(this);
            return this.ensureSocketProvider(sId, depsUnnamed, 0);
        }
        return this.ensureSocketProvider(sId, this.getDependencies(), 0);
    }

    public SocketProvider getSocketProvider(String sId) {
        return this.getSocketProvider(sId, this.getDependencies(), 0);
    }

    public SocketProvider getSocketProvider(String sId, Dependencies deps, int nSubport) {
        if (sId == null) {
            return DEFAULT_SOCKET_PROVIDER;
        }
        return this.ensureSocketProvider(sId, deps, 0);
    }

    @Deprecated
    public SocketProvider getDemultiplexedSocketProvider(XmlElement xml, int nSubport) {
        String sId = LegacyXmlSocketProviderFactoryDependencies.getProviderId(xml);
        if (sId == null) {
            return new DemultiplexedSocketProvider(TcpSocketProvider.MULTIPLEXED, nSubport);
        }
        if (sId.equals(UNNAMED_PROVIDER_ID)) {
            LegacyXmlSocketProviderFactoryDependencies depsUnnamed = new LegacyXmlSocketProviderFactoryDependencies(sId, xml);
            depsUnnamed.setSocketProviderFactory(this);
            return this.ensureSocketProvider(sId, depsUnnamed, nSubport);
        }
        return this.ensureSocketProvider(sId, this.getDependencies(), nSubport);
    }

    public SocketProvider getDemultiplexedSocketProvider(String sId, Dependencies deps, int nSubport) {
        return sId == null ? new DemultiplexedSocketProvider(TcpSocketProvider.MULTIPLEXED, nSubport) : this.ensureSocketProvider(sId, deps, nSubport);
    }

    public SocketProvider getDemultiplexedSocketProvider(SocketProviderBuilder builder, int nSubport) {
        return this.getDemultiplexedSocketProvider(builder.getId(), builder.getDependencies(), nSubport);
    }

    @Deprecated
    public DatagramSocketProvider getDatagramSocketProvider(XmlElement xml, int nSubport) {
        String sId = LegacyXmlSocketProviderFactoryDependencies.getProviderId(xml);
        if (sId == null) {
            return DEFAULT_DATAGRAM_SOCKET_PROVIDER;
        }
        if (sId.equals(UNNAMED_PROVIDER_ID)) {
            LegacyXmlSocketProviderFactoryDependencies depsUnnamed = new LegacyXmlSocketProviderFactoryDependencies(sId, xml);
            depsUnnamed.setSocketProviderFactory(this);
            return this.ensureDatagramSocketProvider(sId, depsUnnamed, nSubport);
        }
        return this.ensureDatagramSocketProvider(sId, this.getDependencies(), nSubport);
    }

    public DatagramSocketProvider getDatagramSocketProvider(String sId, Dependencies deps, int nSubport) {
        return sId == null ? DEFAULT_DATAGRAM_SOCKET_PROVIDER : this.ensureDatagramSocketProvider(sId, deps, nSubport);
    }

    public DatagramSocketProvider getDefaultDatagramSocketProvider(SocketProviderBuilder builder, int nSubport) {
        return this.getDatagramSocketProvider(builder.getId(), builder.getDependencies(), nSubport);
    }

    @Deprecated
    public SSLSettings getSSLSettings(XmlElement xml) {
        String sId = LegacyXmlSocketProviderFactoryDependencies.getProviderId(xml);
        SSLSocketProvider.Dependencies depsSSL = this.getDependencies().getSSLDependencies(sId);
        if (depsSSL == null) {
            if (sId.equals(UNNAMED_PROVIDER_ID)) {
                LegacyXmlSocketProviderFactoryDependencies depsUnnamed = new LegacyXmlSocketProviderFactoryDependencies(sId, xml);
                depsUnnamed.setSocketProviderFactory(this);
                depsSSL = depsUnnamed.getSSLDependencies(sId);
            } else {
                depsSSL = new LegacyXmlSSLSocketProviderDependencies(xml);
            }
        }
        SSLSettings settingsSSL = new SSLSettings();
        settingsSSL.setSSLContext(depsSSL.getSSLContext()).setClientAuthenticationRequired(depsSSL.isClientAuthenticationRequired()).setHostnameVerifier(depsSSL.getHostnameVerifier()).setEnabledCipherSuites(depsSSL.getEnabledCipherSuites()).setEnabledProtocolVersions(depsSSL.getEnabledProtocolVersions());
        return settingsSSL;
    }

    public SSLSettings getSSLSettings(SocketProvider socketProvider) {
        if (socketProvider instanceof SSLSocketProvider) {
            SSLSocketProvider providerSSL = (SSLSocketProvider)socketProvider;
            SSLSocketProvider.Dependencies depsSSL = providerSSL.getDependencies();
            return SocketProviderFactory.createSSLSettings(depsSSL);
        }
        return null;
    }

    public SSLSettings getSSLSettings(SocketProviderBuilder builder) {
        Dependencies deps = this.getDependencies();
        if (deps != null) {
            SSLSocketProvider.Dependencies depsSSL = this.getDependencies().getSSLDependencies(builder.getId());
            if (depsSSL != null) {
                return SocketProviderFactory.createSSLSettings(depsSSL);
            }
        } else {
            return this.getSSLSettings(builder.realize(null, null, null));
        }
        return null;
    }

    public static SSLSettings createSSLSettings(SSLSocketProvider.Dependencies depsSSL) {
        SSLSettings settingsSSL = new SSLSettings();
        settingsSSL.setSSLContext(depsSSL.getSSLContext()).setClientAuthenticationRequired(depsSSL.isClientAuthenticationRequired()).setHostnameVerifier(depsSSL.getHostnameVerifier()).setEnabledCipherSuites(depsSSL.getEnabledCipherSuites()).setEnabledProtocolVersions(depsSSL.getEnabledProtocolVersions());
        return settingsSSL;
    }

    protected SocketProvider ensureSocketProvider(String sId, Dependencies deps, int nSubport) {
        String sKey;
        SocketProvider provider = null;
        String string = sKey = nSubport == 0 ? sId : sId + ":" + nSubport;
        if (!sId.equals(UNNAMED_PROVIDER_ID)) {
            provider = (SocketProvider)this.m_mapSocketProvider.get(sKey);
        }
        if (provider == null) {
            Dependencies.ProviderType providerType = deps.getProviderType(sId);
            if (providerType == null) {
                throw new IllegalArgumentException("Unknown SocketProvider: " + sId);
            }
            switch (providerType) {
                case SYSTEM: 
                case TCP: {
                    provider = nSubport == 0 ? TcpSocketProvider.MULTIPLEXED : new DemultiplexedSocketProvider(TcpSocketProvider.MULTIPLEXED, nSubport);
                    break;
                }
                case SSL: {
                    SSLSocketProvider.Dependencies depsSSL = deps.getSSLDependencies(sId);
                    SocketProvider delegate = depsSSL.getDelegateSocketProvider();
                    if (delegate instanceof SdpSocketProvider) {
                        delegate = SdpSocketProvider.MULTIPLEXED;
                    } else if (delegate instanceof TcpSocketProvider) {
                        delegate = TcpSocketProvider.MULTIPLEXED;
                    }
                    if (nSubport != 0) {
                        delegate = new DemultiplexedSocketProvider((MultiplexedSocketProvider)delegate, nSubport);
                    }
                    provider = new SSLSocketProvider(new SSLSocketProvider.DefaultDependencies(depsSSL).setDelegate(delegate));
                    break;
                }
                case SDP: {
                    provider = nSubport == 0 ? SdpSocketProvider.MULTIPLEXED : new DemultiplexedSocketProvider(SdpSocketProvider.MULTIPLEXED, nSubport);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Socket provider type: " + sId);
                }
            }
            this.m_mapSocketProvider.put(sKey, provider);
        }
        return provider;
    }

    protected DatagramSocketProvider ensureDatagramSocketProvider(String sId, Dependencies providerDeps, int nSubport) {
        String sKey;
        DatagramSocketProvider provider = null;
        String string = sKey = nSubport == 0 ? sId : sId + ":" + nSubport;
        if (!sId.equals(UNNAMED_PROVIDER_ID)) {
            provider = (DatagramSocketProvider)this.m_mapDatagramSocketProvider.get(sKey);
        }
        if (provider == null) {
            Dependencies.ProviderType providerType = providerDeps.getProviderType(sId);
            if (providerType == null) {
                throw new IllegalArgumentException("Unknown DatagramSocketProvider: " + sId);
            }
            switch (providerType) {
                case SYSTEM: {
                    provider = SystemDatagramSocketProvider.INSTANCE;
                    break;
                }
                case TCP: 
                case SDP: {
                    TcpDatagramSocketProvider.DefaultDependencies deps = new TcpDatagramSocketProvider.DefaultDependencies(providerDeps.getTcpDatagramSocketDependencies(sId));
                    deps.setDelegateSocketProvider(this.ensureSocketProvider(sId, providerDeps, nSubport));
                    provider = new TcpDatagramSocketProvider(deps);
                    break;
                }
                case SSL: {
                    TcpDatagramSocketProvider.DefaultDependencies deps = new TcpDatagramSocketProvider.DefaultDependencies(providerDeps.getTcpDatagramSocketDependencies(sId));
                    deps.setDelegateSocketProvider(this.ensureSocketProvider(sId, providerDeps, nSubport));
                    provider = new TcpDatagramSocketProvider(deps){

                        @Override
                        public MulticastSocket openMulticastSocket() throws IOException {
                            throw new IOException("MulticastSocket is not supported with SSL");
                        }

                        @Override
                        public boolean isSecure() {
                            return true;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Socket provider type: " + sId);
                }
            }
            this.m_mapDatagramSocketProvider.put(sKey, provider);
        }
        return provider;
    }

    public String toString() {
        return "SocketProviderFactory, SocketProviderMap=        " + this.m_mapSocketProvider + ", DatagramSocketProviderMap=" + this.m_mapDatagramSocketProvider + "}";
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected Map m_mapSSLDependencies = new SafeHashMap();
        protected Map m_mapSSLDependenciesBuilder = new SafeHashMap();
        protected Map m_mapTCPDatagramDependencies = new SafeHashMap();
        protected Map m_mapProvider = new SafeHashMap();
        protected SocketProviderFactory m_providerFactory;

        public DefaultDependencies() {
            Map mapProvider = this.m_mapProvider;
            mapProvider.put(Dependencies.ProviderType.SYSTEM.getName(), Dependencies.ProviderType.SYSTEM);
            mapProvider.put(Dependencies.ProviderType.TCP.getName(), Dependencies.ProviderType.TCP);
            mapProvider.put(Dependencies.ProviderType.SSL.getName(), Dependencies.ProviderType.SSL);
            mapProvider.put(Dependencies.ProviderType.SDP.getName(), Dependencies.ProviderType.SDP);
            this.m_mapTCPDatagramDependencies.put(Dependencies.ProviderType.TCP.getName(), new TcpDatagramSocketProvider.DefaultDependencies());
        }

        @Override
        public TcpDatagramSocketProvider.Dependencies getTcpDatagramSocketDependencies(String sId) {
            return (TcpDatagramSocketProvider.Dependencies)this.m_mapTCPDatagramDependencies.get(sId);
        }

        @Override
        public synchronized SSLSocketProvider.Dependencies getSSLDependencies(String sId) {
            SSLSocketProviderDependenciesBuilder bldr;
            SSLSocketProvider.Dependencies deps = (SSLSocketProvider.Dependencies)this.m_mapSSLDependencies.get(sId);
            if (deps == null && (bldr = (SSLSocketProviderDependenciesBuilder)this.m_mapSSLDependenciesBuilder.get(sId)) != null) {
                deps = bldr.realize();
                this.addNamedSSLDependencies(sId, deps);
                this.m_mapSSLDependenciesBuilder.remove(sId);
            }
            return deps;
        }

        @Override
        public Dependencies.ProviderType getProviderType(String sId) {
            return (Dependencies.ProviderType)((Object)this.m_mapProvider.get(sId));
        }

        @Override
        public void setSocketProviderFactory(SocketProviderFactory factory) {
            this.m_providerFactory = factory;
        }

        @Override
        public SocketProviderFactory getSocketProviderFactory() {
            SocketProviderFactory factory = this.m_providerFactory;
            if (factory == null) {
                factory = this.m_providerFactory = new SocketProviderFactory(this);
            }
            return factory;
        }

        public void addNamedProviderType(String sId, Dependencies.ProviderType type) {
            this.m_mapProvider.put(sId, type);
        }

        public void addNamedSSLDependencies(String sId, SSLSocketProvider.Dependencies deps) {
            this.m_mapSSLDependencies.put(sId, deps);
        }

        public void addNamedTCPDatagramDependencies(String sId, TcpDatagramSocketProvider.Dependencies deps) {
            this.m_mapTCPDatagramDependencies.put(sId, deps);
        }

        public void addNamedSSLDependenciesBuilder(String sId, SSLSocketProviderDependenciesBuilder bldr) {
            this.m_mapSSLDependenciesBuilder.put(sId, bldr);
        }
    }

    public static interface Dependencies {
        public ProviderType getProviderType(String var1);

        public TcpDatagramSocketProvider.Dependencies getTcpDatagramSocketDependencies(String var1);

        public SSLSocketProvider.Dependencies getSSLDependencies(String var1);

        public void setSocketProviderFactory(SocketProviderFactory var1);

        public SocketProviderFactory getSocketProviderFactory();

        public static enum ProviderType {
            SYSTEM("system"),
            TCP("tcp"),
            SSL("ssl"),
            SDP("sdp");

            final String m_sName;

            private ProviderType(String name) {
                this.m_sName = name;
            }

            public String getName() {
                return this.m_sName;
            }
        }
    }
}

