/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.TopicMapping;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCollection;

public interface ValueTypeAssertion<V>
extends NamedCollection.Option {
    public static final ValueTypeAssertion WITHOUT_TYPE_CHECKING = new ValueTypeAssertion(){

        @Override
        public void assertTypeSafety(String sTopicName, TopicMapping topicMapping) throws IllegalArgumentException {
        }

        public String toString() {
            return "WITHOUT_TYPE_CHECKING";
        }
    };
    public static final ValueTypeAssertion WITH_RAW_TYPES = new ValueTypeAssertion(){

        @Override
        public void assertTypeSafety(String sTopicName, TopicMapping topicMapping) throws IllegalArgumentException {
            if (!topicMapping.usesRawTypes()) {
                CacheFactory.log("The topic \"" + sTopicName + "\" has been configured as NamedTopic<" + topicMapping.getValueClassName() + "> but the application is requesting the topic using raw types", 3);
                return;
            }
        }

        public String toString() {
            return "WITH_RAW_TYPES";
        }
    };

    public void assertTypeSafety(String var1, TopicMapping var2) throws IllegalArgumentException;

    public static <V> ValueTypeAssertion<V> withType(Class<V> clsElement) {
        return new WithValueTypeAssertion<V>(clsElement);
    }

    @Options.Default
    public static <V> ValueTypeAssertion<V> withRawTypes() {
        return WITH_RAW_TYPES;
    }

    public static <V> ValueTypeAssertion<V> withoutTypeChecking() {
        return WITHOUT_TYPE_CHECKING;
    }

    public static class WithValueTypeAssertion<V>
    implements ValueTypeAssertion<V> {
        private final String m_sValueClassName;

        public WithValueTypeAssertion(Class<V> clsValue) {
            if (clsValue == null) {
                throw new IllegalArgumentException(clsValue == null ? "valueClass" : " valueClass parameter must be non-null");
            }
            this.m_sValueClassName = clsValue.getName();
        }

        @Override
        public void assertTypeSafety(String sTopicName, TopicMapping mapping) throws IllegalArgumentException {
            if (mapping.usesRawTypes()) {
                CacheFactory.log("The topic \"" + sTopicName + "\" is configured without a value type but the application is requesting NamedTopic<" + this.getValueClassName() + ">", 3);
                return;
            }
            if (!this.getValueClassName().equals(mapping.getValueClassName())) {
                throw new IllegalArgumentException("The topic mapping for \"" + sTopicName + "\" has been configured as NamedTopic<" + mapping.getValueClassName() + ">, but the application is requesting NamedTopic<" + this.getValueClassName() + ">");
            }
        }

        public String getValueClassName() {
            return this.m_sValueClassName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WithValueTypeAssertion) {
                WithValueTypeAssertion a = (WithValueTypeAssertion)o;
                return this.m_sValueClassName.equals(a.getValueClassName());
            }
            return false;
        }

        public int hashCode() {
            return this.m_sValueClassName.hashCode();
        }

        public String toString() {
            return "WithValueAssertion_" + this.m_sValueClassName;
        }
    }
}

