/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;

public class BackingMapBinaryEntry
extends Base
implements BinaryEntry,
MapTrigger.Entry {
    protected BackingMapManagerContext m_ctx;
    protected Binary m_binKey;
    protected Binary m_binValue;
    protected Binary m_binValueOrig;
    protected long m_ldtExpiry = 0L;
    protected Object m_oKey = NO_VALUE;
    protected Object m_oValue = NO_VALUE;
    protected Object m_oValueOrig = NO_VALUE;
    protected boolean m_fSynthetic;
    private static final Binary NO_VALUE = new Binary();

    public BackingMapBinaryEntry(Binary binKey, Binary binValue, Binary binValueOrig, BackingMapManagerContext ctx) {
        this(binKey, binValue, binValueOrig, 0L, ctx);
    }

    public BackingMapBinaryEntry(Binary binKey, Binary binValue, Binary binValueOrig, long cDelay, BackingMapManagerContext ctx) {
        BackingMapBinaryEntry.azzert(binKey != null, "Null key");
        this.m_ctx = ctx;
        this.m_binKey = binKey;
        this.m_binValue = binValue;
        this.m_binValueOrig = binValueOrig;
        this.m_ldtExpiry = BackingMapBinaryEntry.calculateExpiry(cDelay);
    }

    @Override
    public Binary getBinaryKey() {
        return this.m_binKey;
    }

    @Override
    public Binary getBinaryValue() {
        Binary binValue = this.m_binValue;
        if (binValue == NO_VALUE) {
            Object oValue = this.m_oValue;
            BackingMapBinaryEntry.azzert(oValue != NO_VALUE);
            this.m_binValue = binValue = (Binary)this.m_ctx.getValueToInternalConverter().convert(oValue);
        }
        return binValue;
    }

    @Override
    public Binary getOriginalBinaryValue() {
        return this.m_binValueOrig;
    }

    @Override
    public Object getKey() {
        Object oKey = this.m_oKey;
        if (oKey == NO_VALUE) {
            this.m_oKey = oKey = this.m_ctx.getKeyFromInternalConverter().convert(this.getBinaryKey());
        }
        return oKey;
    }

    @Override
    public Object getValue() {
        Object oValue = this.m_oValue;
        if (oValue == NO_VALUE) {
            Binary binValue = this.getBinaryValue();
            BackingMapBinaryEntry.azzert(binValue != NO_VALUE);
            this.m_oValue = oValue = this.m_ctx.getValueFromInternalConverter().convert(binValue);
        }
        return oValue;
    }

    public Object getOriginalValue() {
        Object oValueOrig = this.m_oValueOrig;
        if (oValueOrig == NO_VALUE) {
            Binary binValueOrig = this.getOriginalBinaryValue();
            BackingMapBinaryEntry.azzert(binValueOrig != NO_VALUE);
            this.m_oValueOrig = oValueOrig = this.m_ctx.getValueFromInternalConverter().convert(binValueOrig);
        }
        return oValueOrig;
    }

    @Override
    public boolean isOriginalPresent() {
        return this.m_binValueOrig != null;
    }

    @Override
    public Object setValue(Object oValue) {
        Object oPrev = this.getValue();
        this.m_oValue = oValue;
        this.m_binValue = NO_VALUE;
        return oPrev;
    }

    @Override
    public void setValue(Object oValue, boolean fSynthetic) {
        this.setValue(oValue);
        this.m_fSynthetic = fSynthetic;
    }

    @Override
    public void updateBinaryValue(Binary binValue) {
        this.m_binValue = binValue;
        this.m_oValue = NO_VALUE;
    }

    @Override
    public void updateBinaryValue(Binary binValue, boolean fSynthetic) {
        this.updateBinaryValue(binValue);
        this.m_fSynthetic = fSynthetic;
    }

    @Override
    public Serializer getSerializer() {
        BackingMapManagerContext ctx = this.m_ctx;
        return ctx == null ? null : ctx.getCacheService().getSerializer();
    }

    @Override
    public BackingMapManagerContext getContext() {
        return this.m_ctx;
    }

    public ObservableMap getBackingMap() {
        return null;
    }

    @Override
    public BackingMapContext getBackingMapContext() {
        return null;
    }

    @Override
    public void expire(long cMillis) {
        this.m_ldtExpiry = BackingMapBinaryEntry.calculateExpiry(cMillis);
    }

    @Override
    public long getExpiry() {
        long ldtExpiry = this.m_ldtExpiry;
        return ldtExpiry == 0L || ldtExpiry == -1L ? ldtExpiry : Math.max(1L, ldtExpiry - Base.getLastSafeTimeMillis());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void update(ValueUpdater updater, Object oValue) {
        InvocableMapHelper.updateEntry(updater, this, oValue);
    }

    @Override
    public boolean isPresent() {
        return this.getOriginalBinaryValue() != null;
    }

    @Override
    public boolean isSynthetic() {
        return this.m_fSynthetic;
    }

    @Override
    public void remove(boolean fSynthetic) {
        this.updateBinaryValue(null, fSynthetic);
    }

    @Override
    public Object extract(ValueExtractor extractor) {
        return InvocableMapHelper.extractFromEntry(extractor, this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BackingMapBinaryEntry) {
            BackingMapBinaryEntry that = (BackingMapBinaryEntry)o;
            return BackingMapBinaryEntry.equals(this.getBinaryKey(), that.getBinaryKey()) && BackingMapBinaryEntry.equals(this.getBinaryValue(), that.getBinaryValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_binKey.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassHelper.getSimpleName(this.getClass())).append("{Key=");
        if (this.m_oKey == NO_VALUE) {
            sb.append(this.m_binKey);
        } else {
            sb.append(this.m_oKey);
        }
        sb.append(", Value=");
        if (this.m_oValue == NO_VALUE) {
            sb.append(this.m_binValue);
        } else {
            sb.append(this.m_oValue);
        }
        sb.append(", OrigValue=");
        if (this.m_oValueOrig == NO_VALUE) {
            sb.append(this.m_binValueOrig);
        } else {
            sb.append(this.m_oValueOrig);
        }
        sb.append('}');
        return sb.toString();
    }

    protected static long calculateExpiry(long cDelay) {
        return cDelay == 0L ? 0L : (cDelay < 0L ? -1L : (cDelay > 0x3FFFFFFFFFFFFFFFL ? Long.MAX_VALUE : Base.getLastSafeTimeMillis() + cDelay));
    }
}

