/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.Base;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LocalCache
extends OldCache
implements CacheMap {
    public static final int DEFAULT_UNITS = Integer.MAX_VALUE;
    public static final int DEFAULT_EXPIRE = 0;
    protected final KeyMask DEFAULT_KEY_MASK = new KeyMask(){
        private boolean m_fSynthetic = false;
        private boolean m_fExpired = false;

        @Override
        public boolean isSynthetic() {
            return this.m_fSynthetic;
        }

        @Override
        public void setSynthetic(boolean fSynthetic) {
            this.m_fSynthetic = fSynthetic;
        }

        @Override
        public boolean isExpired() {
            return this.m_fExpired;
        }

        @Override
        public void setExpired(boolean fExpired) {
            this.m_fExpired = fExpired;
        }
    };
    private CacheLoader m_loader;
    private CacheStore m_store;
    private MapListener m_listener;
    private ThreadLocal m_tloIgnore = new ThreadLocal();

    public LocalCache() {
        this(Integer.MAX_VALUE);
    }

    public LocalCache(int cUnits) {
        this(cUnits, 0);
    }

    public LocalCache(int cUnits, int cExpiryMillis) {
        super(cUnits, cExpiryMillis);
    }

    public LocalCache(int cUnits, int cExpiryMillis, CacheLoader loader) {
        this(cUnits, cExpiryMillis);
        this.setCacheLoader(loader);
    }

    @Override
    public synchronized void clear() {
        CacheStore store = this.getCacheStore();
        if (store != null) {
            store.eraseAll(Collections.unmodifiableCollection(this.keySet()));
        }
        super.clear();
    }

    @Override
    public synchronized Object remove(Object oKey) {
        OldCache.Entry entry = (OldCache.Entry)this.getEntryInternal(oKey);
        if (entry == null) {
            return null;
        }
        CacheStore store = this.getCacheStore();
        if (store != null) {
            store.erase(oKey);
        }
        return super.remove(oKey);
    }

    public CacheLoader getCacheLoader() {
        return this.m_loader;
    }

    public synchronized void setCacheLoader(CacheLoader loader) {
        if (loader != this.m_loader) {
            this.m_loader = null;
            this.m_store = null;
            MapListener listener = this.m_listener;
            if (listener != null) {
                this.removeMapListener(listener);
                this.m_listener = null;
            }
            this.m_loader = loader;
            if (loader instanceof CacheStore) {
                this.m_store = (CacheStore)loader;
                this.m_listener = listener = this.instantiateInternalListener();
                this.addMapListener(listener);
            }
        }
    }

    @Override
    public Object get(Object oKey) {
        return super.get(oKey);
    }

    @Override
    public SafeHashMap.Entry getEntry(Object oKey) {
        SafeHashMap.Entry entry = super.getEntry(oKey);
        if (entry == null && this.getCacheLoader() != null) {
            long ldtStart = this.getCurrentTimeMillis();
            this.load(oKey);
            entry = this.getEntryInternal(oKey);
            this.m_stats.registerMisses(0, ldtStart);
        }
        return entry;
    }

    @Override
    public Map getAll(Collection colKeys) {
        CacheLoader loader;
        long ldtStart = 0L;
        Map map = this.peekAll(colKeys);
        int cTotal = colKeys.size();
        int cHits = map.size();
        if (cHits < cTotal && (loader = this.getCacheLoader()) != null) {
            ldtStart = this.getCurrentTimeMillis();
            HashSet setRequest = new HashSet(colKeys);
            setRequest.removeAll(map.keySet());
            this.loadAll(setRequest);
            map.putAll(this.peekAll(setRequest));
        }
        this.m_stats.registerHits(cHits, ldtStart);
        this.m_stats.registerMisses(cTotal - cHits, ldtStart);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(final Object oKey) {
        Object oValue;
        CacheLoader loader = this.getCacheLoader();
        if (loader != null && this.getEntryInternal(oKey) == null && (oValue = loader.load(oKey)) != null) {
            KeyMask mask = new KeyMask(){

                @Override
                public boolean isIgnored(Object oCheckKey) {
                    return 1.equals(oKey, oCheckKey);
                }
            };
            this.setKeyMask(mask);
            try {
                super.put(oKey, oValue);
            }
            finally {
                this.setKeyMask(null);
            }
        }
    }

    public void loadAll() {
        CacheLoader loader = this.getCacheLoader();
        if (loader instanceof IterableCacheLoader) {
            Iterator iter = ((IterableCacheLoader)loader).keys();
            int cMaxUnits = this.getHighUnits();
            if (cMaxUnits > 0 && cMaxUnits < Integer.MAX_VALUE) {
                int cTarget = Math.max(this.getLowUnits(), (int)(0.9 * (double)cMaxUnits));
                int cCurrent = this.getUnits();
                while (iter.hasNext() && cCurrent < cTarget) {
                    this.load(iter.next());
                    int cUnits = this.getUnits();
                    if (cUnits >= cCurrent) {
                        cCurrent = cUnits;
                        continue;
                    }
                    break;
                }
            } else {
                this.loadAll(new ImmutableArrayList(SimpleEnumerator.toArray(iter)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll(Collection colKeys) {
        CacheLoader loader = this.getCacheLoader();
        if (loader != null && !colKeys.isEmpty()) {
            Map map;
            HashSet setRequest = new HashSet(colKeys);
            setRequest.removeAll(this.peekAll(colKeys).keySet());
            if (!setRequest.isEmpty() && !(map = loader.loadAll(setRequest)).isEmpty()) {
                final Set setKeys = map.keySet();
                KeyMask mask = new KeyMask(){

                    @Override
                    public boolean isIgnored(Object oCheckKey) {
                        return setKeys.contains(oCheckKey);
                    }
                };
                this.setKeyMask(mask);
                try {
                    super.putAll(map);
                }
                finally {
                    this.setKeyMask(null);
                }
            }
        }
    }

    public Object peek(Object oKey) {
        OldCache.Entry entry = (OldCache.Entry)this.getEntryInternal(oKey);
        return entry == null ? null : entry.getValue();
    }

    public Map peekAll(Collection colKeys) {
        HashMap map = new HashMap(colKeys.size());
        for (Object oKey : colKeys) {
            OldCache.Entry entry = (OldCache.Entry)this.getEntryInternal(oKey);
            if (entry == null) continue;
            map.put(oKey, entry.getValue());
        }
        return map;
    }

    protected CacheStore getCacheStore() {
        return this.m_store;
    }

    protected KeyMask getKeyMask() {
        KeyMask mask = (KeyMask)this.m_tloIgnore.get();
        return mask == null ? this.DEFAULT_KEY_MASK : mask;
    }

    protected void setKeyMask(KeyMask mask) {
        this.m_tloIgnore.set(mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean removeEvicted(OldCache.Entry entry) {
        long dtExpiry = entry.getExpiryMillis();
        boolean fExpired = dtExpiry != 0L && (dtExpiry & 0xFFFFFFFFFFFFFF00L) < this.getCurrentTimeMillis();
        KeyMask mask = this.getKeyMask();
        boolean fPrev = mask.ensureSynthetic();
        boolean fPrevExpired = fExpired ? mask.ensureExpired() : false;
        try {
            boolean bl = super.removeEvicted(entry);
            return bl;
        }
        finally {
            mask.setSynthetic(fPrev);
            mask.setExpired(fPrevExpired);
        }
    }

    @Override
    protected MapEvent instantiateMapEvent(int nId, Object oKey, Object oValueOld, Object oValueNew) {
        return new CacheEvent<Object, Object>(this, nId, oKey, oValueOld, oValueNew, this.getKeyMask().isSynthetic(), CacheEvent.TransformationState.TRANSFORMABLE, false, this.getKeyMask().isExpired());
    }

    protected MapListener instantiateInternalListener() {
        return new InternalListener();
    }

    @Override
    protected SafeHashMap.Entry instantiateEntry() {
        return new Entry();
    }

    public class Entry
    extends OldCache.Entry {
    }

    protected class KeyMask
    extends Base {
        protected KeyMask() {
        }

        public boolean isIgnored(Object oKey) {
            return false;
        }

        public boolean isSynthetic() {
            return true;
        }

        public void setSynthetic(boolean fSynthetic) {
        }

        public boolean isExpired() {
            return true;
        }

        public void setExpired(boolean fExpired) {
        }

        public boolean ensureSynthetic() {
            boolean f = this.isSynthetic();
            if (!f) {
                this.setSynthetic(true);
            }
            return f;
        }

        public boolean ensureExpired() {
            boolean f = this.isExpired();
            if (!f) {
                this.setExpired(true);
            }
            return f;
        }
    }

    protected class InternalListener
    extends Base
    implements MapListener {
        protected InternalListener() {
        }

        public void entryInserted(MapEvent evt) {
            this.onModify(evt);
        }

        public void entryUpdated(MapEvent evt) {
            this.onModify(evt);
        }

        public void entryDeleted(MapEvent evt) {
        }

        protected void onModify(MapEvent evt) {
            CacheStore store;
            if (!LocalCache.this.getKeyMask().isIgnored(evt.getKey()) && (store = LocalCache.this.getCacheStore()) != null) {
                store.store(evt.getKey(), evt.getNewValue());
            }
        }
    }
}

