/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.oracle.coherence.common.util.Options;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;

public interface TypeAssertion<K, V>
extends NamedCache.Option {
    public static final TypeAssertion WITHOUT_TYPE_CHECKING = new TypeAssertion(){

        @Override
        public boolean assertTypeSafety(String sCacheName, CacheMapping cacheMapping, boolean fLog) throws IllegalArgumentException {
            return true;
        }

        public String toString() {
            return "WITHOUT_TYPE_CHECKING";
        }
    };
    public static final TypeAssertion WITH_RAW_TYPES = new TypeAssertion(){

        @Override
        public boolean assertTypeSafety(String sCacheName, CacheMapping cacheMapping, boolean fLog) throws IllegalArgumentException {
            if (!cacheMapping.usesRawTypes() && fLog) {
                CacheFactory.log("The cache \"" + sCacheName + "\" has been configured as NamedCache<" + cacheMapping.getKeyClassName() + "," + cacheMapping.getValueClassName() + "> but the application is requesting the cache using raw types", 3);
                return false;
            }
            return true;
        }

        public String toString() {
            return "WITH_RAW_TYPES";
        }
    };

    public boolean assertTypeSafety(String var1, CacheMapping var2, boolean var3) throws IllegalArgumentException;

    default public boolean assertTypeSafety(String sCacheName, CacheMapping cacheMapping) throws IllegalArgumentException {
        return this.assertTypeSafety(sCacheName, cacheMapping, true);
    }

    public static <K, V> TypeAssertion<K, V> withTypes(Class<K> clsKey, Class<V> clsValue) {
        return new WithTypesAssertion<K, V>(clsKey, clsValue);
    }

    @Options.Default
    public static TypeAssertion withRawTypes() {
        return WITH_RAW_TYPES;
    }

    public static <K, V> TypeAssertion<K, V> withoutTypeChecking() {
        return WITHOUT_TYPE_CHECKING;
    }

    public static class WithTypesAssertion<K, V>
    implements TypeAssertion<K, V> {
        private final String m_sKeyClassName;
        private final String m_sValueClassName;

        public WithTypesAssertion(Class<K> keyClass, Class<V> valueClass) {
            if (keyClass == null || valueClass == null) {
                throw new IllegalArgumentException(keyClass == null ? "keyClass" : " valueClass parameter must be non-null");
            }
            this.m_sKeyClassName = keyClass.getName();
            this.m_sValueClassName = valueClass.getName();
        }

        @Override
        public boolean assertTypeSafety(String sCacheName, CacheMapping cacheMapping, boolean fLog) throws IllegalArgumentException {
            if (cacheMapping.usesRawTypes()) {
                if (fLog) {
                    CacheFactory.log("The cache \"" + sCacheName + "\" is configured without key and/or value types but the application is requesting NamedCache<" + this.getKeyClassName() + "," + this.getValueClassName() + ">", 3);
                    return false;
                }
            } else if (!this.getKeyClassName().equals(cacheMapping.getKeyClassName()) || !this.getValueClassName().equals(cacheMapping.getValueClassName())) {
                throw new IllegalArgumentException("The cache mapping for \"" + sCacheName + "\" has been configured as NamedCache<" + cacheMapping.getKeyClassName() + "," + cacheMapping.getValueClassName() + ">, but the application is requesting NamedCache<" + this.getKeyClassName() + "," + this.getValueClassName() + ">");
            }
            return true;
        }

        public String getKeyClassName() {
            return this.m_sKeyClassName;
        }

        public String getValueClassName() {
            return this.m_sValueClassName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof WithTypesAssertion) {
                WithTypesAssertion a = (WithTypesAssertion)o;
                return this.m_sKeyClassName.equals(a.getKeyClassName()) && this.m_sValueClassName.equals(a.getValueClassName());
            }
            return false;
        }

        public int hashCode() {
            return this.m_sKeyClassName.hashCode() + this.m_sValueClassName.hashCode();
        }

        public String toString() {
            return "WithTypesAssertion_" + this.m_sKeyClassName + "_" + this.m_sValueClassName;
        }
    }
}

