/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.common.base.Predicate;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.annotation.Interceptor;
import com.tangosol.net.events.internal.AbstractEvent;
import com.tangosol.net.events.internal.NamedEventInterceptor;
import com.tangosol.util.Base;
import com.tangosol.util.SubSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbstractEventDispatcher
implements EventDispatcher {
    protected final Set<Enum> f_setTypes;
    protected final ConcurrentMap<Enum, List<NamedEventInterceptor<?>>> f_mapInterceptors;
    protected final EventStats m_stats = new EventStats();

    public AbstractEventDispatcher() {
        this(new HashSet<Enum>());
    }

    public AbstractEventDispatcher(Set<Enum> setTypes) {
        this.f_mapInterceptors = new ConcurrentHashMap();
        List<EventDispatcher.InterceptorRegistrationEvent.Type> listTypes = Arrays.asList(EventDispatcher.InterceptorRegistrationEvent.Type.values());
        HashSet<Enum> setAllTypes = new HashSet<Enum>(setTypes.size() + listTypes.size());
        setAllTypes.addAll(setTypes);
        setAllTypes.addAll(listTypes);
        this.f_setTypes = Collections.unmodifiableSet(setAllTypes);
    }

    @Override
    public <E extends Event<? extends Enum>> void addEventInterceptor(EventInterceptor<E> incptr) {
        this.addEventInterceptor(null, incptr);
    }

    @Override
    public <T extends Enum<T>, E extends Event<T>> void addEventInterceptor(String sIdentifier, EventInterceptor<E> interceptor, Set<T> setTypes, boolean fFirst) {
        NamedEventInterceptor<E> incptrNamed;
        String sCacheName = null;
        String sServiceName = null;
        if (interceptor instanceof NamedEventInterceptor) {
            incptrNamed = (NamedEventInterceptor<E>)interceptor;
            interceptor = incptrNamed.getInterceptor();
            sCacheName = incptrNamed.getCacheName();
            sServiceName = incptrNamed.getServiceName();
        }
        incptrNamed = new NamedEventInterceptor<E>(sIdentifier, interceptor, sCacheName, sServiceName, fFirst ? Interceptor.Order.HIGH : Interceptor.Order.LOW, null, setTypes);
        this.addEventInterceptor(incptrNamed);
    }

    @Override
    public <E extends Event<? extends Enum>> void addEventInterceptor(String sIdentifier, EventInterceptor<E> incptr) {
        NamedEventInterceptor incptrNamed;
        NamedEventInterceptor namedEventInterceptor = incptrNamed = incptr instanceof NamedEventInterceptor ? (NamedEventInterceptor)incptr : new NamedEventInterceptor<E>(sIdentifier, incptr);
        if (incptrNamed.isAcceptable(this)) {
            Set<Enum> setTypes;
            Set<Enum> setEventTypes = incptrNamed.getEventTypes();
            if (setEventTypes == null) {
                setTypes = this.f_setTypes;
            } else {
                setTypes = new SubSet<Enum>(this.getSupportedTypes());
                setTypes.retainAll(setEventTypes);
            }
            final DispatcherInterceptorEvent<E> event = this.instantiateEvent(EventDispatcher.InterceptorRegistrationEvent.Type.INSERTING, incptrNamed, setTypes);
            this.dispatchEvent(event, new Continuation(){

                public void proceed(Object o) {
                    if (o instanceof Throwable) {
                        CacheFactory.log("An EventInterceptor veto'd the registration of " + event.getInterceptor() + " for the event types " + event.getEventTypes());
                        throw Base.ensureRuntimeException((Throwable)o);
                    }
                    ConcurrentMap<Enum, List<NamedEventInterceptor<?>>> mapInterceptors = AbstractEventDispatcher.this.getInterceptorMap();
                    NamedEventInterceptor incptrNamed = event.getNamedEventInterceptor();
                    for (Enum eventType : setTypes) {
                        if (!mapInterceptors.containsKey(eventType)) {
                            mapInterceptors.putIfAbsent(eventType, new CopyOnWriteArrayList());
                        }
                        List listIncptr = (List)mapInterceptors.get(eventType);
                        if (incptrNamed.isFirst()) {
                            listIncptr.add(0, incptrNamed);
                            continue;
                        }
                        listIncptr.add(incptrNamed);
                    }
                    AbstractEventDispatcher.this.dispatchEvent(AbstractEventDispatcher.this.instantiateEvent(EventDispatcher.InterceptorRegistrationEvent.Type.INSERTED, incptrNamed, setTypes), null);
                }
            });
        }
    }

    @Override
    public void removeEventInterceptor(final String sName) {
        this.removeEventInterceptor(new Predicate<NamedEventInterceptor>(){

            @Override
            public boolean evaluate(NamedEventInterceptor incptr) {
                return incptr != null && incptr.getRegisteredName().equals(sName);
            }
        });
    }

    public void removeEventInterceptor(final EventInterceptor interceptor) {
        this.removeEventInterceptor(new Predicate<NamedEventInterceptor>(){

            @Override
            public boolean evaluate(NamedEventInterceptor incptr) {
                return incptr != null && (incptr.getInterceptor() == interceptor || incptr == interceptor);
            }
        });
    }

    public ConcurrentMap<Enum, List<NamedEventInterceptor<?>>> getInterceptorMap() {
        return this.f_mapInterceptors;
    }

    @Override
    public Set<Enum> getSupportedTypes() {
        return this.f_setTypes;
    }

    public EventStats getStats() {
        return this.m_stats;
    }

    public boolean isSubscribed(Enum eventType) {
        return this.getInterceptorMap().containsKey(eventType);
    }

    protected Continuation getDispatchContinuation(final AbstractEvent event, final Continuation continuation) {
        return new Continuation(){

            public void proceed(Object oResult) {
                try {
                    List list = (List)AbstractEventDispatcher.this.getInterceptorMap().get(event.getType());
                    if (list != null) {
                        event.dispatch(list);
                    }
                }
                catch (RuntimeException e) {
                    if (continuation == null) {
                        throw e;
                    }
                    oResult = e;
                }
                finally {
                    if (continuation != null) {
                        continuation.proceed(oResult);
                    }
                }
            }
        };
    }

    protected void removeEventInterceptor(Predicate<NamedEventInterceptor> predicate) {
        HashSet<Enum> setEventTypes = new HashSet<Enum>();
        NamedEventInterceptor incptrNamed = null;
        Iterator iter = this.getInterceptorMap().entrySet().iterator();
        block0: while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List listInterceptors = (List)entry.getValue();
            for (NamedEventInterceptor interceptor : listInterceptors) {
                if (!predicate.evaluate(interceptor)) continue;
                incptrNamed = interceptor;
                setEventTypes.add((Enum)entry.getKey());
                listInterceptors.remove(interceptor);
                if (!listInterceptors.isEmpty()) continue block0;
                iter.remove();
                continue block0;
            }
        }
        if (incptrNamed != null && !setEventTypes.isEmpty()) {
            this.dispatchEvent(this.instantiateEvent(EventDispatcher.InterceptorRegistrationEvent.Type.REMOVED, incptrNamed, setEventTypes), null);
        }
    }

    protected void dispatchEvent(AbstractEvent<? extends Enum> event, Continuation<?> cont) {
        this.getDispatchContinuation(event, cont).proceed(null);
    }

    protected <E extends Event<? extends Enum>> DispatcherInterceptorEvent<E> instantiateEvent(EventDispatcher.InterceptorRegistrationEvent.Type eventType, NamedEventInterceptor<E> incptr, Set<Enum> setEventTypes) {
        return new DispatcherInterceptorEvent<E>(this, eventType, incptr, setEventTypes);
    }

    public class EventStats {
        protected volatile int m_cExceptions;
        protected volatile String m_sStackTrace;

        public void registerEventException(Exception e, Event event, EventInterceptor interceptor) {
            ++this.m_cExceptions;
            this.m_sStackTrace = new Date() + "\n" + Base.printStackTrace(e);
        }

        public void reset() {
            this.m_cExceptions = 0;
            this.m_sStackTrace = null;
        }

        public String[] toStringArray() {
            ArrayList<String> listStats = new ArrayList<String>();
            HashSet<String> setInterceptorNames = new HashSet<String>();
            for (List listInterceptor : AbstractEventDispatcher.this.getInterceptorMap().values()) {
                for (NamedEventInterceptor interceptor : listInterceptor) {
                    setInterceptorNames.add(interceptor.getRegisteredName());
                }
            }
            listStats.add("Interceptors: " + setInterceptorNames);
            listStats.add("ExceptionCount: " + this.m_cExceptions);
            String sStackTrace = this.m_sStackTrace;
            listStats.add("LastException: " + (sStackTrace == null ? "" : sStackTrace));
            return listStats.toArray(new String[listStats.size()]);
        }

        public String toString() {
            String[] asDisplay;
            StringBuilder builder = new StringBuilder();
            for (String s : asDisplay = this.toStringArray()) {
                builder.append(s).append('\n');
            }
            return builder.toString();
        }
    }

    public static class DispatcherInterceptorEvent<E extends Event<? extends Enum>>
    extends AbstractEvent<EventDispatcher.InterceptorRegistrationEvent.Type>
    implements EventDispatcher.InterceptorRegistrationEvent<E> {
        protected final Set<Enum> f_setEventTypes;
        protected NamedEventInterceptor<E> m_incptr;

        public DispatcherInterceptorEvent(EventDispatcher dispatcher, EventDispatcher.InterceptorRegistrationEvent.Type eventType, NamedEventInterceptor<E> incptr, Set<Enum> setEventTypes) {
            super(dispatcher, eventType);
            assert (incptr != null);
            this.m_incptr = incptr;
            this.f_setEventTypes = setEventTypes;
        }

        @Override
        protected boolean isMutableEvent() {
            return this.getType() == EventDispatcher.InterceptorRegistrationEvent.Type.INSERTING;
        }

        @Override
        public String getIdentifier() {
            return this.m_incptr.getRegisteredName();
        }

        @Override
        public Set<Enum> getEventTypes() {
            return this.f_setEventTypes;
        }

        @Override
        public EventInterceptor<E> getInterceptor() {
            return this.m_incptr.getInterceptor();
        }

        @Override
        public void setInterceptor(EventInterceptor<E> incptr) {
            if (!this.isMutableEvent()) {
                throw new IllegalStateException("Modifying the interceptor is not permitted for " + this.getType() + " events");
            }
            this.m_incptr = new NamedEventInterceptor<E>(incptr, this.m_incptr);
        }

        protected NamedEventInterceptor<E> getNamedEventInterceptor() {
            return this.m_incptr;
        }
    }
}

