/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.oracle.coherence.common.base.Continuation;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.internal.AbstractEventDispatcher;
import com.tangosol.net.events.partition.cache.CacheLifecycleEvent;
import com.tangosol.net.events.partition.cache.EntryEvent;
import com.tangosol.net.events.partition.cache.EntryProcessorEvent;
import com.tangosol.net.events.partition.cache.Event;
import com.tangosol.net.events.partition.cache.PartitionedCacheDispatcher;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StorageDispatcher
extends AbstractEventDispatcher
implements PartitionedCacheDispatcher {
    protected static final Set<Enum> EVENT_TYPES_STORAGE = new HashSet<Enum>();
    protected static final Set<Enum> EVENT_TYPES_CACHE = new HashSet<Enum>();
    protected final BackingMapContext f_ctxBM;
    protected final String f_sCacheName;
    protected final CacheService f_service;

    public StorageDispatcher(BackingMapContext ctx) {
        super(EVENT_TYPES_STORAGE);
        this.f_ctxBM = ctx;
        this.f_sCacheName = ctx.getCacheName();
        this.f_service = ctx.getManagerContext().getCacheService();
    }

    public StorageDispatcher(String sCacheName, CacheService service) {
        super(EVENT_TYPES_CACHE);
        this.f_ctxBM = null;
        this.f_sCacheName = sCacheName;
        this.f_service = service;
    }

    @Override
    public BackingMapContext getBackingMapContext() {
        return this.f_ctxBM;
    }

    @Override
    public String getCacheName() {
        return this.f_sCacheName;
    }

    @Override
    public String getServiceName() {
        return this.f_service.getInfo().getServiceName();
    }

    public Continuation getEntryEventContinuation(EntryEvent.Type eventType, Set<BinaryEntry> setBinEntry, Continuation continuation) {
        return this.getDispatchContinuation(new PartitionedCacheEntryEvent(this, eventType, setBinEntry), continuation);
    }

    public Continuation getEntryProcessorEventContinuation(EntryProcessorEvent.Type eventType, InvocableMap.EntryProcessor agent, Set<BinaryEntry> setBinEntry, Continuation continuation) {
        return this.getDispatchContinuation(new PartitionedCacheInvocationEvent(this, eventType, agent, setBinEntry), continuation);
    }

    public Continuation getCacheLifecycleEventContinuation(CacheLifecycleEvent.Type eventType, Continuation continuation) {
        return this.getDispatchContinuation(new StorageLifecycleEvent(this, eventType), continuation);
    }

    static {
        EVENT_TYPES_STORAGE.addAll(Arrays.asList(EntryEvent.Type.values()));
        EVENT_TYPES_STORAGE.addAll(Arrays.asList(EntryProcessorEvent.Type.values()));
        EVENT_TYPES_STORAGE.addAll(Arrays.asList(CacheLifecycleEvent.Type.values()));
        EVENT_TYPES_CACHE.addAll(Arrays.asList(CacheLifecycleEvent.Type.values()));
    }

    protected static class StorageLifecycleEvent
    extends AbstractEvent<CacheLifecycleEvent.Type>
    implements CacheLifecycleEvent {
        protected StorageLifecycleEvent(StorageDispatcher dispatcher, CacheLifecycleEvent.Type eventType) {
            super(dispatcher, eventType);
        }

        @Override
        protected boolean isMutableEvent() {
            return false;
        }

        @Override
        protected String getDescription() {
            StorageDispatcher dispatcher = (StorageDispatcher)this.m_dispatcher;
            return super.getDescription() + ", Service=" + dispatcher.getServiceName() + ", Cache=" + dispatcher.getCacheName();
        }

        @Override
        public String getCacheName() {
            StorageDispatcher dispatcher = (StorageDispatcher)this.m_dispatcher;
            return dispatcher.getCacheName();
        }
    }

    protected static class PartitionedCacheInvocationEvent
    extends AbstractEvent<EntryProcessorEvent.Type>
    implements EntryProcessorEvent {
        protected final Set<BinaryEntry> m_setBinEntry;
        protected final InvocableMap.EntryProcessor m_processor;

        protected PartitionedCacheInvocationEvent(EventDispatcher dispatcher, EntryProcessorEvent.Type eventType, InvocableMap.EntryProcessor agent, Set<BinaryEntry> setBinEntry) {
            super(dispatcher, eventType);
            this.m_processor = agent;
            this.m_setBinEntry = setBinEntry;
        }

        @Override
        protected boolean isMutableEvent() {
            return this.getType() == EntryProcessorEvent.Type.EXECUTING;
        }

        @Override
        protected String getDescription() {
            StorageDispatcher dispatcher = (StorageDispatcher)this.m_dispatcher;
            return super.getDescription() + ", Service=" + dispatcher.getServiceName() + ", Cache=" + dispatcher.getCacheName();
        }

        @Override
        public Set<BinaryEntry> getEntrySet() {
            return this.m_setBinEntry;
        }

        @Override
        public InvocableMap.EntryProcessor getProcessor() {
            return this.m_processor;
        }
    }

    protected static class PartitionedCacheEntryEvent<K, V>
    extends AbstractEvent<EntryEvent.Type>
    implements EntryEvent<K, V> {
        protected final Set<BinaryEntry<K, V>> m_setBinEntry;

        protected PartitionedCacheEntryEvent(EventDispatcher dispatcher, EntryEvent.Type eventType, Set<BinaryEntry<K, V>> setBinEntry) {
            super(dispatcher, eventType);
            this.m_setBinEntry = setBinEntry;
        }

        @Override
        protected boolean isMutableEvent() {
            switch ((EntryEvent.Type)((Object)this.getType())) {
                case INSERTING: 
                case UPDATING: 
                case REMOVING: {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected String getDescription() {
            StorageDispatcher dispatcher = (StorageDispatcher)this.m_dispatcher;
            return super.getDescription() + ", Service=" + dispatcher.getServiceName() + ", Cache=" + dispatcher.getCacheName();
        }

        @Override
        public Set<BinaryEntry<K, V>> getEntrySet() {
            return this.m_setBinEntry;
        }
    }

    protected static abstract class AbstractEvent<T extends Enum<T>>
    extends com.tangosol.net.events.internal.AbstractEvent<T>
    implements Event<T> {
        public AbstractEvent(EventDispatcher dispatcher, T eventType) {
            super(dispatcher, eventType);
        }

        @Override
        public PartitionedCacheDispatcher getDispatcher() {
            return (PartitionedCacheDispatcher)this.m_dispatcher;
        }
    }
}

