/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.common.base.Blocking;
import com.oracle.common.base.IdentityHolder;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.AbstractScopedReferenceStore;
import com.tangosol.net.internal.ScopedServiceReferenceStore;
import com.tangosol.net.security.Security;
import com.tangosol.util.SegmentedConcurrentMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ScopedCacheReferenceStore
extends AbstractScopedReferenceStore {
    protected Map<IdentityHolder<NamedCache>, Object> f_mapPending = new ConcurrentHashMap<IdentityHolder<NamedCache>, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInactiveCacheRefs() {
        Iterator iterByName = this.m_mapByName.values().iterator();
        while (iterByName.hasNext()) {
            Map mapByLoader;
            Map map = mapByLoader = (Map)iterByName.next();
            synchronized (map) {
                Iterator iter = mapByLoader.entrySet().iterator();
                while (iter.hasNext()) {
                    NamedCache cache;
                    Collection col;
                    Map.Entry entry = iter.next();
                    Object oHolder = entry.getValue();
                    if (oHolder instanceof NamedCache) {
                        NamedCache cache2 = (NamedCache)entry.getValue();
                        if (!cache2.isDestroyed() && !cache2.isReleased()) continue;
                        iter.remove();
                        this.internalReleaseCache(cache2);
                        continue;
                    }
                    if (!(oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) || (col = ((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values()).isEmpty() || !(cache = (NamedCache)col.iterator().next()).isDestroyed() && !cache.isReleased()) continue;
                    iter.remove();
                    this.internalReleaseCache(cache);
                }
                if (mapByLoader.isEmpty()) {
                    iterByName.remove();
                }
            }
        }
    }

    public NamedCache getCache(String sCacheName, ClassLoader loader) {
        Map mapByLoader = (Map)this.m_mapByName.get(sCacheName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == null || oHolder instanceof NamedCache) {
                    return (NamedCache)oHolder;
                }
                if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                    return (NamedCache)((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get();
                }
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllCaches() {
        HashSet setRef = new HashSet();
        Collection colLoader = this.m_mapByName.values();
        Iterator iterator = colLoader.iterator();
        while (iterator.hasNext()) {
            Map mapByLoader;
            Map map = mapByLoader = (Map)iterator.next();
            synchronized (map) {
                for (Object oHolder : mapByLoader.values()) {
                    if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        setRef.addAll(((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values());
                        continue;
                    }
                    if (oHolder instanceof NamedCache) {
                        setRef.add(oHolder);
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return setRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllCaches(String sCacheName) {
        HashSet setRef = new HashSet();
        Map mapByLoader = (Map)this.m_mapByName.get(sCacheName);
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                for (Object oHolder : col) {
                    if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        setRef.addAll(((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).values());
                        continue;
                    }
                    if (oHolder instanceof NamedCache) {
                        setRef.add(oHolder);
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        return setRef;
    }

    public void putCache(NamedCache cache, ClassLoader loader) {
        if (cache.isReleased()) {
            throw new IllegalArgumentException("Storing a released cache is not allowed: " + cache.getCacheName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        WeakHashMap<ClassLoader, Object> mapByLoader = (WeakHashMap<ClassLoader, Object>)mapByName.get(sCacheName);
        if (mapByLoader == null) {
            mapByLoader = new WeakHashMap<ClassLoader, Object>();
            mapByName.put(sCacheName, mapByLoader);
        }
        if (ScopedServiceReferenceStore.isRemoteServiceType(cache.getCacheService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)mapByLoader.get(loader);
            if (scopedRef == null) {
                scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference(this);
                mapByLoader.put(loader, scopedRef);
            }
            scopedRef.set(cache);
        } else {
            mapByLoader.put(loader, cache);
        }
    }

    public Object putCacheIfAbsent(NamedCache cache, ClassLoader loader) {
        Object oResult;
        Map mapByLoader;
        if (cache.isReleased()) {
            throw new IllegalArgumentException("Storing a released cache is not allowed: " + cache.getCacheName());
        }
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        do {
            Map mapTmp;
            if ((mapByLoader = (WeakHashMap)mapByName.get(sCacheName)) == null && (mapTmp = (Map)mapByName.putIfAbsent(sCacheName, mapByLoader = new WeakHashMap())) != null) {
                mapByLoader = mapTmp;
            }
            if (ScopedServiceReferenceStore.isRemoteServiceType(cache.getCacheService().getInfo().getServiceType()) && Security.SUBJECT_SCOPED) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference(this);
                oResult = this.putLoaderIfAbsent(mapByLoader, loader, scopedRef);
                if (oResult != null) {
                    scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oResult;
                }
                oResult = scopedRef.putIfAbsent(cache);
                continue;
            }
            oResult = this.putLoaderIfAbsent(mapByLoader, loader, cache);
        } while (mapByName.get(sCacheName) != mapByLoader);
        return oResult;
    }

    public boolean releaseCache(NamedCache cache, ClassLoader loader) {
        return this.releaseCache(cache, loader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseCache(NamedCache cache, ClassLoader loader, Runnable postRelease) {
        Map map;
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        Map mapByLoader = (Map)mapByName.get(sCacheName);
        boolean fFound = false;
        Object oPending = null;
        IdentityHolder<NamedCache> cacheId = new IdentityHolder<NamedCache>(cache);
        if (mapByLoader != null) {
            map = mapByLoader;
            synchronized (map) {
                AbstractScopedReferenceStore.SubjectScopedReference scopedRef;
                Object oHolder = mapByLoader.get(loader);
                if (oHolder == cache) {
                    mapByLoader.remove(loader);
                    fFound = true;
                } else if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference && (scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get() == cache) {
                    scopedRef.remove();
                    fFound = true;
                    if (scopedRef.isEmpty()) {
                        mapByLoader.remove(loader);
                    }
                }
                if (fFound && postRelease != null) {
                    oPending = new Object();
                    this.f_mapPending.put(cacheId, oPending);
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sCacheName);
                }
            }
        }
        if (oPending != null) {
            try {
                postRelease.run();
            }
            finally {
                this.f_mapPending.remove(cacheId, oPending);
                map = oPending;
                synchronized (map) {
                    oPending.notifyAll();
                }
            }
        }
        if (!fFound) {
            this.awaitPending(cacheId);
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseCache(NamedCache cache) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        String sCacheName = cache.getCacheName();
        Map mapByLoader = (Map)mapByName.get(sCacheName);
        boolean fFound = false;
        if (mapByLoader != null) {
            Map map = mapByLoader;
            synchronized (map) {
                Collection col = mapByLoader.values();
                fFound = col.remove(cache);
                if (!fFound) {
                    Object oHolder;
                    if (cache instanceof ClassLoaderAware) {
                        return this.releaseCache(cache, ((ClassLoaderAware)((Object)cache)).getContextClassLoader());
                    }
                    Iterator iter = col.iterator();
                    while (iter.hasNext() && (oHolder = iter.next()) instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
                        AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)oHolder;
                        if (scopedRef.get() != cache) continue;
                        scopedRef.remove();
                        fFound = true;
                        if (!scopedRef.isEmpty()) break;
                        iter.remove();
                        break;
                    }
                }
                if (mapByLoader.isEmpty()) {
                    mapByName.remove(sCacheName);
                }
            }
        }
        return fFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitPending(IdentityHolder<NamedCache> cacheId) {
        Object oPending = this.f_mapPending.get(cacheId);
        if (oPending != null) {
            Object object = oPending;
            synchronized (object) {
                if (oPending == this.f_mapPending.get(cacheId)) {
                    try {
                        Blocking.wait(oPending);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putLoaderIfAbsent(Map map, ClassLoader loader, Object oValue) {
        Object oResult;
        Map map2 = map;
        synchronized (map2) {
            oResult = map.get(loader);
            if (oResult == null) {
                map.put(loader, oValue);
            }
        }
        return oResult;
    }

    private void internalReleaseCache(NamedCache cache) {
        try {
            cache.release();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

