/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.Service;
import com.tangosol.net.internal.AbstractScopedReferenceStore;
import com.tangosol.net.security.Security;
import com.tangosol.util.SegmentedConcurrentMap;

public class ScopedServiceReferenceStore
extends AbstractScopedReferenceStore {
    public Service getService(String sServiceName) {
        Object oHolder = this.m_mapByName.get(sServiceName);
        if (oHolder == null || oHolder instanceof Service) {
            return (Service)oHolder;
        }
        if (oHolder instanceof AbstractScopedReferenceStore.SubjectScopedReference) {
            return (Service)((AbstractScopedReferenceStore.SubjectScopedReference)oHolder).get();
        }
        throw new UnsupportedOperationException();
    }

    public void putService(Service service, String sName, String sType) {
        SegmentedConcurrentMap mapByName = this.m_mapByName;
        if (ScopedServiceReferenceStore.isRemoteServiceType(sType) && Security.SUBJECT_SCOPED) {
            AbstractScopedReferenceStore.SubjectScopedReference scopedRef = (AbstractScopedReferenceStore.SubjectScopedReference)mapByName.get(sName);
            if (scopedRef == null) {
                scopedRef = new AbstractScopedReferenceStore.SubjectScopedReference(this);
                AbstractScopedReferenceStore.SubjectScopedReference refTmp = (AbstractScopedReferenceStore.SubjectScopedReference)this.m_mapByName.putIfAbsent(sName, scopedRef);
                scopedRef = refTmp == null ? scopedRef : refTmp;
            }
            scopedRef.set(service);
        } else {
            mapByName.put(sName, service);
        }
    }

    public static boolean isRemoteServiceType(String sType) {
        return sType.equals("RemoteCache") || sType.equals("RemoteInvocation");
    }
}

