/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.io.ReadBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.extractor.EntryExtractor;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Map;

public class SessionExpiryExtractor
extends EntryExtractor {
    public static final int MAGIC_V350 = 1785231208;
    public static final Long NEVER_EXPIRES = Long.MAX_VALUE;

    public Object extractFromEntry(Map.Entry entry) {
        try {
            Binary binSession = ((BinaryEntry)entry).getBinaryValue();
            if (binSession == null) {
                return NEVER_EXPIRES;
            }
            int of = SessionExpiryExtractor.validateBinarySession(binSession);
            ReadBuffer.BufferInput in = binSession.getBufferInput();
            in.setOffset(of + 4);
            long ldtAccessed = in.readLong();
            in.setOffset(of + 32);
            int cMaxSeconds = in.readInt();
            return cMaxSeconds < 0 ? NEVER_EXPIRES : Long.valueOf(ldtAccessed + (long)cMaxSeconds * 1000L);
        }
        catch (IOException e) {
            throw SessionExpiryExtractor.ensureRuntimeException(e);
        }
    }

    public static int validateBinarySession(Binary binSession) {
        try {
            ReadBuffer.BufferInput in = binSession.getBufferInput();
            if (SessionExpiryExtractor.isDecorated(binSession)) {
                long nMask;
                byte bFmt = in.readByte();
                long l = nMask = bFmt == 18 ? (long)in.readUnsignedByte() : in.readPackedLong();
                if (bFmt != 18 && bFmt != 19 || (nMask & 1L) == 0L) {
                    throw new InvalidClassException("Binary session model is decorated incorrectly.");
                }
                in.readPackedInt();
            }
            if (in.readUnsignedByte() != 10) {
                throw new InvalidClassException("Binary session model is not a serialized ExternalizableLite object");
            }
            in.skip(Math.max(0, in.readPackedInt()));
            int of = in.getOffset();
            if (in.readInt() != 1785231208) {
                throw new InvalidClassException("Session management version conflict; the Coherence*Web cluster must be upgraded to a consistent version.");
            }
            return of;
        }
        catch (IOException e) {
            throw SessionExpiryExtractor.ensureRuntimeException(e);
        }
    }
}

