/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.oracle.coherence.common.internal.net.MultiplexedSocketProvider;
import com.oracle.coherence.common.net.InetSocketAddress32;
import com.tangosol.net.InetAddressHelper;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SocketAddressHelper {
    public static String toString(SocketAddress address) {
        if (address == null || address instanceof InetSocketAddress) {
            return SocketAddressHelper.toString((InetSocketAddress)address);
        }
        if (address instanceof InetSocketAddress32) {
            return SocketAddressHelper.toString((InetSocketAddress32)address);
        }
        return address.toString();
    }

    public static String toString(InetSocketAddress address) {
        if (address == null) {
            return "null";
        }
        String sHost = address.isUnresolved() ? address.getHostName() : InetAddressHelper.toString(address.getAddress());
        return sHost + ':' + address.getPort();
    }

    public static String toString(InetSocketAddress32 address) {
        if (address == null) {
            return "null";
        }
        String sHost = address.isUnresolved() ? address.getHostName() : InetAddressHelper.toString(address.getAddress());
        int nPort = address.getPort();
        String sPort = Integer.toString(MultiplexedSocketProvider.getBasePort(nPort));
        if (MultiplexedSocketProvider.isPortExtended(nPort)) {
            sPort = sPort + '.' + MultiplexedSocketProvider.getSubPort(nPort);
        }
        return sHost + ':' + sPort;
    }
}

