/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.AddressProvider;
import com.tangosol.net.AddressProviderFactory;
import java.net.InetSocketAddress;

public class SubstitutionAddressProvider
implements AddressProvider {
    private final AddressProvider f_delegate;
    private final int f_nPort;

    public SubstitutionAddressProvider(AddressProvider delegate, int nPort) {
        this.f_delegate = delegate;
        this.f_nPort = nPort;
    }

    @Override
    public InetSocketAddress getNextAddress() {
        InetSocketAddress address = this.f_delegate.getNextAddress();
        if (address != null && this.f_nPort != 0 && address.getPort() == 0) {
            address = new InetSocketAddress(address.getAddress(), this.f_nPort);
        }
        return address;
    }

    @Override
    public void accept() {
        this.f_delegate.accept();
    }

    @Override
    public void reject(Throwable eCause) {
        this.f_delegate.reject(eCause);
    }

    public String toString() {
        return this.f_delegate.toString();
    }

    @Override
    public int hashCode() {
        return this.f_delegate.hashCode();
    }

    public static AddressProviderFactory createFactory(final AddressProviderFactory delegate, final int nPort) {
        return new AddressProviderFactory(){

            @Override
            public AddressProvider createAddressProvider(ClassLoader loader) {
                return new SubstitutionAddressProvider(delegate.createAddressProvider(loader), nPort);
            }
        };
    }
}

