/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.tangosol.internal.net.management.MBeanCollectorFunction;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanHelper;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanAccessor {
    protected final MBeanServerProxy f_mbeanServerProxy;
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String SERVICE = "service=".substring(0, "service=".indexOf(61));
    public static final String TIER = "tier";
    public static final String NODE_ID = "nodeId=".substring(0, "nodeId=".indexOf(61));
    public static final String MEMBER = "member=".substring(0, "member=".indexOf(61));
    public static final String CLUSTER = "cluster=".substring(0, "cluster=".indexOf(61));
    public static final String STORAGE_MANAGER_QUERY = ":type=StorageManager,cache=";

    public MBeanAccessor() {
        this(CacheFactory.getCluster().getManagement().getMBeanServerProxy());
    }

    public MBeanAccessor(MBeanServerProxy mBeanServerProxy) {
        this.f_mbeanServerProxy = mBeanServerProxy;
    }

    public Map<String, Map<String, Object>> getAttributes(QueryBuilder.ParsedQuery query) {
        return this.getAttributes(query, null, true);
    }

    public Map<String, Map<String, Object>> getAttributes(QueryBuilder.ParsedQuery query, Filter<MBeanAttributeInfo> filter, boolean fAddStorageMBeanAttributes) {
        return this.f_mbeanServerProxy.execute(new GetAttributes(query, filter, fAddStorageMBeanAttributes));
    }

    public Map<String, Object> invoke(QueryBuilder.ParsedQuery query, String sOperationName, Object[] aoArguments, String[] asSignature) {
        return this.f_mbeanServerProxy.execute(new Invoke(query, sOperationName, aoArguments, asSignature));
    }

    public Map<String, Map<String, Object>> update(QueryBuilder.ParsedQuery query, Map<String, Object> mapAttributes) {
        return this.f_mbeanServerProxy.execute(new SetAttributes(query, mapAttributes));
    }

    public Set<String> queryKeys(QueryBuilder.ParsedQuery query) {
        return this.f_mbeanServerProxy.queryNames(query.getQuery(), query.getObjectNameFilter());
    }

    public Map<String, Object> aggregate(QueryBuilder.ParsedQuery query, String sLocator, String sAttribute, String sCollector) {
        return this.f_mbeanServerProxy.execute(new MBeanCollectorFunction(sLocator, sAttribute, sCollector, query));
    }

    public static class GetAttributes
    implements Remote.Function<MBeanServer, Map<String, Map<String, Object>>>,
    Serializable {
        private static final long serialVersionUID = -1L;
        protected QueryBuilder.ParsedQuery m_query;
        protected Filter<MBeanAttributeInfo> m_filter = null;
        protected boolean m_fAddStorageMBeanAttributes;

        public GetAttributes() {
        }

        public GetAttributes(QueryBuilder.ParsedQuery query) {
            this(query, null, true);
        }

        public GetAttributes(QueryBuilder.ParsedQuery query, Filter<MBeanAttributeInfo> filter, boolean fAddStorageMBeanAttributes) {
            this.m_query = query;
            this.m_filter = filter;
            this.m_fAddStorageMBeanAttributes = fAddStorageMBeanAttributes;
        }

        @Override
        public Map<String, Map<String, Object>> apply(MBeanServer mBeanServer) {
            try {
                QueryBuilder.ParsedQuery query = this.m_query;
                HashMap<String, Map<String, Object>> mapMBeans = new HashMap<String, Map<String, Object>>();
                Set<ObjectName> setObjectNames = mBeanServer.queryNames(new ObjectName(query.getQuery()), new MBeanHelper.QueryExpFilter(query.getObjectNameFilter()));
                for (ObjectName oObjectName : setObjectNames) {
                    String sObjectName = oObjectName.toString();
                    HashMap<String, Object> mapAttributes = new HashMap<String, Object>();
                    try {
                        this.addMBeanAttributes(oObjectName, mapAttributes, mBeanServer, this.m_filter);
                    }
                    catch (InstanceNotFoundException e) {
                        CacheFactory.log("MBeanAccessor$GetAttributes#apply(objName=" + sObjectName + "): ignoring InstanceNotFoundException: " + e.getMessage(), 6);
                    }
                    ObjectName objName = new ObjectName(sObjectName);
                    if (this.m_fAddStorageMBeanAttributes && objName.getKeyProperty(MBeanAccessor.TYPE).equals("Cache") && objName.getKeyProperty(MBeanAccessor.TIER).equals("back")) {
                        QueryBuilder.ParsedQuery queryStorage;
                        String sCacheName = objName.getKeyProperty(MBeanAccessor.NAME);
                        String sServiceName = objName.getKeyProperty(SERVICE);
                        String sNodeId = objName.getKeyProperty(NODE_ID);
                        String sBaseQuery = MBeanAccessor.STORAGE_MANAGER_QUERY + sCacheName;
                        QueryBuilder bldrStorageQuery = new QueryBuilder().withBaseQuery(sBaseQuery).withMBeanDomainName(objName.getDomain()).withService(sServiceName).withMember(sNodeId);
                        String sCluster = objName.getKeyProperty(CLUSTER);
                        if (sCluster != null) {
                            bldrStorageQuery.withCluster(sCluster);
                        }
                        if ((setObjectNames = mBeanServer.queryNames(new ObjectName((queryStorage = bldrStorageQuery.build()).getQuery()), new MBeanHelper.QueryExpFilter(queryStorage.getObjectNameFilter()))).size() == 1) {
                            this.addMBeanAttributes(setObjectNames.iterator().next(), mapAttributes, mBeanServer, this.m_filter);
                        }
                    }
                    mapMBeans.put(sObjectName, mapAttributes);
                }
                return mapMBeans;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void addMBeanAttributes(ObjectName oObjName, Map<String, Object> mapAttributes, MBeanServer mBeanServer, Filter<MBeanAttributeInfo> filter) throws Exception {
            MBeanInfo info = mBeanServer.getMBeanInfo(oObjName);
            String[] arrAttributes = Arrays.stream(info.getAttributes()).filter(attrInfo -> filter == null ? true : filter.evaluate((MBeanAttributeInfo)attrInfo)).map(MBeanFeatureInfo::getName).collect(Collectors.toSet()).toArray(new String[0]);
            AttributeList attrList = mBeanServer.getAttributes(oObjName, arrAttributes);
            if (attrList != null && !attrList.isEmpty()) {
                for (Attribute attribute : attrList.asList()) {
                    mapAttributes.put(attribute.getName(), attribute.getValue());
                }
            }
        }
    }

    public static class Invoke
    implements Remote.Function<MBeanServer, Map<String, Object>>,
    Serializable {
        private static final long serialVersionUID = -1L;
        protected QueryBuilder.ParsedQuery m_query;
        protected String m_sOperationName;
        protected Object[] m_arguments;
        protected String[] m_signature;

        public Invoke() {
        }

        public Invoke(QueryBuilder.ParsedQuery query, String sOperationName, Object[] aoArguments, String[] asSignature) {
            this.m_query = query;
            this.m_sOperationName = sOperationName;
            this.m_arguments = aoArguments;
            this.m_signature = asSignature;
        }

        @Override
        public Map<String, Object> apply(MBeanServer mBeanServer) {
            try {
                QueryBuilder.ParsedQuery query = this.m_query;
                HashMap<String, Object> mapMBeans = new HashMap<String, Object>();
                Set<ObjectName> setObjectNames = mBeanServer.queryNames(new ObjectName(query.getQuery()), new MBeanHelper.QueryExpFilter(query.getObjectNameFilter()));
                for (ObjectName oObjectName : setObjectNames) {
                    String sObjectName = oObjectName.toString();
                    Object result = null;
                    try {
                        result = this.invokeOperation(mBeanServer, sObjectName);
                    }
                    catch (InstanceNotFoundException e) {
                        CacheFactory.log("MBeanAccessor$Invoke#apply(mbeanServer=" + mBeanServer + ", objName=" + sObjectName + "): ignoring InstanceNotFoundException: " + e.getMessage(), 6);
                        continue;
                    }
                    mapMBeans.put(sObjectName, result);
                }
                return mapMBeans;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected Object invokeOperation(MBeanServer mBeanServer, String sObjectName) throws InstanceNotFoundException {
            try {
                return mBeanServer.invoke(new ObjectName(sObjectName), this.m_sOperationName, this.m_arguments, this.m_signature);
            }
            catch (Exception e) {
                if ("vmUnlockCommercialFeatures".equals(this.m_sOperationName) && System.getProperty("java.runtime.version").contains("-perf-")) {
                    return null;
                }
                throw Base.ensureRuntimeException(e, "invoke operation " + this.m_sOperationName + " to MBean " + sObjectName + " failed with an exception");
            }
        }
    }

    public static class SetAttributes
    implements Remote.Function<MBeanServer, Map<String, Map<String, Object>>>,
    Serializable {
        private static final long serialVersionUID = -1L;
        protected QueryBuilder.ParsedQuery m_query;
        protected Map<String, Object> m_mapAttributes;

        public SetAttributes() {
        }

        public SetAttributes(QueryBuilder.ParsedQuery query, Map<String, Object> mapAttributes) {
            this.m_query = query;
            this.m_mapAttributes = mapAttributes;
        }

        @Override
        public Map<String, Map<String, Object>> apply(MBeanServer mBeanServer) {
            try {
                AttributeList attrList = this.getAttributeList(this.m_mapAttributes);
                QueryBuilder.ParsedQuery query = this.m_query;
                HashMap<String, Map<String, Object>> mapUpdatedMBeans = new HashMap<String, Map<String, Object>>();
                if (!attrList.isEmpty()) {
                    Set<ObjectName> setObjectNames = mBeanServer.queryNames(new ObjectName(query.getQuery()), new MBeanHelper.QueryExpFilter(query.getObjectNameFilter()));
                    for (ObjectName oObjectName : setObjectNames) {
                        try {
                            AttributeList attrResponseList = mBeanServer.setAttributes(oObjectName, attrList);
                            HashMap<String, Object> mapUpdatedAttributes = new HashMap<String, Object>();
                            if (attrResponseList != null && !attrResponseList.isEmpty()) {
                                for (Attribute attr : attrResponseList.asList()) {
                                    mapUpdatedAttributes.put(attr.getName(), attr.getValue());
                                }
                            }
                            mapUpdatedMBeans.put(oObjectName.toString(), mapUpdatedAttributes);
                        }
                        catch (InstanceNotFoundException e) {
                            CacheFactory.log("MBeanAccessor$SetAttributes#apply(objName=" + oObjectName + "): ignoring InstanceNotFoundException: " + e.getMessage(), 6);
                        }
                    }
                }
                return mapUpdatedMBeans;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected AttributeList getAttributeList(Map<String, Object> mapEntity) {
            return new AttributeList(mapEntity.entrySet().stream().map(e -> new Attribute((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
        }
    }

    public static class QueryBuilder
    implements Serializable {
        protected String m_sMemberKey;
        protected String m_sService;
        protected String m_sCluster;
        protected boolean m_fExact = false;
        protected String m_sMBeanDomainName;
        protected String m_sBaseQuery;
        protected Map<String, Filter<String>> m_mapFilters;
        private static final long serialVersionUID = -1L;

        public QueryBuilder withBaseQuery(String sBaseQuery) {
            this.m_sBaseQuery = sBaseQuery;
            return this;
        }

        public QueryBuilder withCluster(String sCluster) {
            this.m_sCluster = sCluster;
            return this;
        }

        public QueryBuilder withService(String sService) {
            this.m_sService = sService;
            return this;
        }

        public QueryBuilder withMember(String sMemberKey) {
            this.m_sMemberKey = sMemberKey;
            return this;
        }

        public QueryBuilder withMBeanDomainName(String sMBeanDomainName) {
            this.m_sMBeanDomainName = sMBeanDomainName;
            return this;
        }

        public QueryBuilder withFilter(String sKey, Filter<String> predicate) {
            Objects.requireNonNull(sKey);
            Objects.requireNonNull(predicate);
            this.ensureMapFilters().put(sKey, predicate);
            return this;
        }

        public QueryBuilder exact() {
            return this.exact(true);
        }

        public QueryBuilder exact(boolean fExact) {
            this.m_fExact = fExact;
            return this;
        }

        public ParsedQuery build() {
            String sBaseQuery = this.m_sBaseQuery;
            String sClusterName = this.m_sCluster;
            String sDomainName = this.m_sMBeanDomainName;
            String sMemberKey = this.m_sMemberKey;
            String sService = this.m_sService;
            StringBuilder sbQuery = new StringBuilder(sBaseQuery);
            if (sClusterName != null) {
                sbQuery.append(",").append("cluster=").append(sClusterName);
            }
            int ofDomain = sBaseQuery.indexOf(58);
            int ofEquals = sBaseQuery.indexOf(61);
            if (sDomainName != null && (ofDomain <= 0 || ofDomain > ofEquals)) {
                sbQuery.insert(0, sDomainName);
            }
            if (sMemberKey != null) {
                if (sMemberKey.matches("\\d+")) {
                    sbQuery.append(",").append(NODE_ID).append("=").append(sMemberKey);
                } else {
                    sbQuery.append(",").append(MEMBER).append("=").append(sMemberKey);
                }
            }
            if (sService != null) {
                sbQuery.append(",").append(SERVICE).append("=").append(sService);
            }
            if (!this.m_fExact) {
                sbQuery.append(",*");
            }
            try {
                Map<String, Filter<String>> mapFilters = this.m_mapFilters;
                if (mapFilters != null) {
                    mapFilters = Collections.unmodifiableMap(new HashMap<String, Filter<String>>(mapFilters));
                }
                return new ParsedQuery(MBeanHelper.quoteCanonical(sbQuery.toString()), mapFilters);
            }
            catch (MalformedObjectNameException e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        public String getCluster() {
            return this.m_sCluster;
        }

        public String getMBeanDomain() {
            return this.m_sMBeanDomainName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{member=" + this.m_sMemberKey + ", service=" + this.m_sService + ", cluster=" + this.m_sCluster + ", exact=" + this.m_fExact + ", domain=" + this.m_sMBeanDomainName + ", query=" + this.m_sBaseQuery + ", filtermap=" + this.m_mapFilters + '}';
        }

        protected Map<String, Filter<String>> ensureMapFilters() {
            Map<String, Filter<String>> map = this.m_mapFilters;
            if (map == null) {
                map = this.m_mapFilters = new ConcurrentHashMap<String, Filter<String>>(1);
            }
            return map;
        }

        public static class ParsedQuery
        implements Serializable {
            private static final long serialVersionUID = -1L;
            protected Map<String, Filter<String>> m_mapFilters;
            protected String m_sQuery;

            protected ParsedQuery() {
            }

            protected ParsedQuery(String sQuery, Map<String, Filter<String>> mapFilters) {
                this.m_sQuery = sQuery;
                this.m_mapFilters = mapFilters;
            }

            public String getQuery() {
                return this.m_sQuery;
            }

            public Map<String, Filter<String>> getMapFilters() {
                return this.m_mapFilters;
            }

            public Filter<ObjectName> getObjectNameFilter() {
                return ParsedQuery.instantiateObjectNameFilter(this.m_mapFilters);
            }

            private static Filter<ObjectName> instantiateObjectNameFilter(Map<String, Filter<String>> mapFilters) {
                return objectName -> {
                    if (mapFilters == null) {
                        return true;
                    }
                    for (Map.Entry entry : mapFilters.entrySet()) {
                        if (((Filter)entry.getValue()).evaluate(objectName.getKeyProperty((String)entry.getKey()))) continue;
                        return false;
                    }
                    return true;
                };
            }
        }
    }
}

