/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.function.Remote;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WrapperMBeanServerProxy
implements MBeanServerProxy {
    private final Supplier<MBeanServer> f_supplier;

    public WrapperMBeanServerProxy(MBeanServer server) {
        this(() -> server);
    }

    public WrapperMBeanServerProxy(Supplier<MBeanServer> supplier) {
        this.f_supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public MBeanInfo getMBeanInfo(String sName) {
        try {
            return this.getServer().getMBeanInfo(new ObjectName(sName));
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public <R> R execute(Remote.Function<MBeanServer, R> function) {
        return function.apply(this.getServer());
    }

    @Override
    public Map<String, Object> getAttributes(String sName, Filter<String> filter) {
        try {
            MBeanInfo info = this.getMBeanInfo(sName);
            String[] attributes = (String[])Arrays.stream(info.getAttributes()).filter(a -> this.evaluateAttributeName(a.getName(), filter)).map(MBeanFeatureInfo::getName).distinct().toArray(String[]::new);
            MBeanServer server = this.getServer();
            AttributeList listAttributes = server.getAttributes(new ObjectName(sName), attributes);
            Map<String, Object> mapValues = listAttributes != null ? listAttributes.asList().stream().filter(a -> a.getValue() != null).collect(Collectors.toMap(Attribute::getName, Attribute::getValue)) : null;
            return mapValues;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public Object getAttribute(String sName, String sAttr) {
        try {
            return this.getServer().getAttribute(new ObjectName(sName), sAttr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAttribute(String sName, String sAttr, Object oValue) {
        try {
            this.getServer().setAttribute(new ObjectName(sName), new Attribute(sAttr, oValue));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(String sName, String sOpName, Object[] aoParams, String[] asSignature) {
        try {
            return this.getServer().invoke(new ObjectName(sName), sOpName, aoParams, asSignature);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> queryNames(String sPattern, Filter<ObjectName> filter) {
        try {
            return this.queryNames(new ObjectName(sPattern), filter);
        }
        catch (MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public Set<String> queryNames(ObjectName pattern, Filter<ObjectName> filter) {
        try {
            Set setNames;
            MBeanServer server = this.getServer();
            Set<ObjectName> setObjectNames = server.queryNames(pattern, null);
            if (setObjectNames != null) {
                Stream<Object> stream = setObjectNames.stream();
                if (filter != null) {
                    stream = stream.filter(filter::evaluate);
                }
                setNames = stream.map(ObjectName::toString).collect(Collectors.toSet());
            } else {
                setNames = null;
            }
            return setNames;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public boolean isMBeanRegistered(String sName) {
        try {
            return this.getServer().isRegistered(new ObjectName(sName));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MBeanServerProxy local() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().addNotificationListener(new ObjectName(sName), listener, filter, oHandback);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener) {
        try {
            this.getServer().removeNotificationListener(new ObjectName(sName), listener);
        }
        catch (InstanceNotFoundException | ListenerNotFoundException | MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    @Override
    public void removeNotificationListener(String sName, NotificationListener listener, NotificationFilter filter, Object oHandback) {
        try {
            this.getServer().removeNotificationListener(new ObjectName(sName), listener, filter, oHandback);
        }
        catch (InstanceNotFoundException | ListenerNotFoundException | MalformedObjectNameException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private MBeanServer getServer() {
        return this.f_supplier.get();
    }

    private boolean evaluateAttributeName(String sName, Filter<String> filter) {
        return filter == null || filter.evaluate(sName) || filter.evaluate(sName.toUpperCase());
    }
}

