/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface MBeanMetric {
    public Identifier getIdentifier();

    default public String getName() {
        return this.getIdentifier().getName();
    }

    default public Scope getScope() {
        return this.getIdentifier().getScope();
    }

    default public Map<String, String> getTags() {
        return this.getIdentifier().getTags();
    }

    public String getMBeanName();

    public String getDescription();

    public Object getValue();

    public static class Identifier
    implements Comparable<Identifier> {
        private static final String CAMEL_CASE_PATTERN = String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])");
        private static final String DOT = ".";
        private static final Pattern DOUBLE_UNDERSCORE = Pattern.compile("__");
        private static final Pattern COLON_UNDERSCORE = Pattern.compile(":_");
        private static final Pattern CAMEL_CASE = Pattern.compile("(.)(\\p{Upper})");
        private final Scope f_scope;
        private final String f_sName;
        private final SortedMap<String, String> f_mapTags;
        private SortedMap<String, String> f_mapFormattedTags;
        private SortedMap<String, String> f_mapPrometheusTags;
        private final String f_sTags;
        private String m_sFormattedName;
        private String m_sLegacyName;
        private String m_sMicroprofileName;

        public Identifier(Scope scope, String sName, Map<String, String> mapTags) {
            Objects.requireNonNull(mapTags);
            this.f_scope = Objects.requireNonNull(scope);
            this.f_sName = Objects.requireNonNull(sName);
            this.f_mapTags = new TreeMap<String, String>(mapTags);
            this.f_sTags = this.f_mapTags.entrySet().stream().map(entry -> (String)entry.getKey() + "=\"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", "));
        }

        public String getName() {
            return this.f_sName;
        }

        public Scope getScope() {
            return this.f_scope;
        }

        public Map<String, String> getTags() {
            return Collections.unmodifiableMap(this.f_mapTags);
        }

        public String getFormattedName() {
            if (this.m_sFormattedName == null) {
                this.m_sFormattedName = this.formatName(this.f_sName);
            }
            return this.m_sFormattedName;
        }

        public String getLegacyName() {
            if (this.m_sLegacyName == null) {
                this.m_sLegacyName = this.prometheusName(this.f_scope, this.f_sName);
            }
            return this.m_sLegacyName;
        }

        public String getMicroprofileName() {
            if (this.m_sMicroprofileName == null) {
                this.m_sMicroprofileName = this.microprofileName(this.f_scope, this.f_sName);
            }
            return this.m_sMicroprofileName;
        }

        public Map<String, String> getFormattedTags() {
            if (this.f_mapFormattedTags == null) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (Map.Entry<String, String> entry : this.f_mapTags.entrySet()) {
                    map.put(this.formatName(entry.getKey()), entry.getValue());
                }
                this.f_mapFormattedTags = map;
            }
            return this.f_mapFormattedTags;
        }

        public Map<String, String> getPrometheusTags() {
            if (this.f_mapPrometheusTags == null) {
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (Map.Entry<String, String> entry : this.f_mapTags.entrySet()) {
                    map.put(this.prometheusName(null, entry.getKey()), entry.getValue());
                }
                this.f_mapPrometheusTags = map;
            }
            return this.f_mapPrometheusTags;
        }

        @Override
        public int compareTo(Identifier other) {
            int nResult = this.f_scope.compareTo(other.f_scope);
            if (nResult == 0) {
                nResult = this.f_sName.compareTo(other.f_sName);
            }
            if (nResult == 0) {
                nResult = this.f_sTags.compareTo(other.f_sTags);
            }
            return nResult;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.f_scope.equals((Object)that.f_scope) && this.f_sName.equals(that.f_sName) && this.f_mapTags.equals(that.f_mapTags);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.f_scope, this.f_sName, this.f_mapTags});
        }

        public String toString() {
            return (Object)((Object)this.f_scope) + ":" + this.f_sName + ", tags='" + this.f_sTags + '\'';
        }

        String formatName(String sName) {
            String[] asParts = sName.replaceAll("_", DOT).split("\\.");
            String sFormatted = Arrays.stream(asParts).map(this::camelToDot).collect(Collectors.joining(DOT));
            return sFormatted.toLowerCase();
        }

        private String prometheusName(Scope scope, String sName) {
            String orig;
            sName = sName.replaceAll("[^a-zA-Z0-9_]", "_");
            if (scope != null) {
                sName = scope.name().toLowerCase() + ":" + sName;
            }
            sName = Identifier.camelToSnake(sName);
            while (!(orig = sName).equals(sName = DOUBLE_UNDERSCORE.matcher(sName).replaceAll("_"))) {
            }
            while (!(orig = sName).equals(sName = COLON_UNDERSCORE.matcher(sName).replaceAll(":"))) {
            }
            return sName;
        }

        private String microprofileName(Scope scope, String sName) {
            sName = sName.replaceAll("[^a-zA-Z0-9_]", "_");
            return scope == null ? sName : scope.name().toLowerCase() + "_" + sName;
        }

        private String camelToDot(String s) {
            return s.replaceAll(CAMEL_CASE_PATTERN, DOT);
        }

        private static String camelToSnake(String name) {
            return CAMEL_CASE.matcher(name).replaceAll("$1_$2").toLowerCase();
        }
    }

    public static enum Scope {
        BASE,
        VENDOR,
        APPLICATION;


        public String getDescriptorValue() {
            return "metric.scope=" + this.name();
        }
    }
}

