/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Iterator;

public abstract class AbstractPartitionedIterator<T>
extends AbstractStableIterator<T> {
    public static final int OPT_BY_PARTITION = 0;
    public static final int OPT_BY_MEMBER = 2;
    public static final int OPT_RANDOMIZED = 4;
    protected NamedCache m_cache;
    protected PartitionedFilter m_filter;
    protected PartitionSet m_setPids;
    protected boolean m_fByMember;
    protected boolean m_fRandom;
    private int m_iPrevPid = -1;
    private Iterator m_iter;

    protected AbstractPartitionedIterator(Filter filter, NamedCache cache, PartitionSet setPids) {
        this(filter, cache, setPids, false, false);
    }

    protected AbstractPartitionedIterator(Filter filter, NamedCache cache, PartitionSet setPids, boolean fByMember, boolean fRandom) {
        this.m_filter = new PartitionedFilter(filter, new PartitionSet(setPids.getPartitionCount()));
        this.m_cache = cache;
        this.m_setPids = new PartitionSet(setPids);
        this.m_fByMember = fByMember;
        this.m_fRandom = fRandom;
    }

    protected abstract Iterable<T> nextIterable(PartitionedFilter var1);

    @Override
    protected void advance() {
        Iterator<T> iterKeys = this.m_iter;
        while (iterKeys == null || !iterKeys.hasNext()) {
            PartitionedFilter filter = this.m_filter;
            if (!this.advancePartitionSet(filter.getPartitionSet())) {
                this.m_iter = null;
                return;
            }
            Iterable<T> iterable = this.nextIterable(filter);
            this.m_iter = iterKeys = iterable.iterator();
        }
        this.setNext(iterKeys.next());
    }

    @Override
    protected void remove(Object oPrev) {
        throw new UnsupportedOperationException();
    }

    private boolean advancePartitionSet(PartitionSet setPids) {
        int iNextPid;
        PartitionSet setRemain = this.m_setPids;
        int iPrevPid = this.m_iPrevPid;
        int n = iNextPid = this.m_fRandom ? setRemain.rnd() : setRemain.next(iPrevPid + 1);
        if (iNextPid < 0) {
            return false;
        }
        if (this.m_fByMember) {
            setPids.clear();
            setPids.add(setRemain);
            PartitionedService service = (PartitionedService)((Object)this.m_cache.getCacheService());
            Member member = service.getPartitionOwner(iNextPid);
            block2: while (member == null) {
                try {
                    Blocking.sleep(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
                int iPid = setRemain.next(0);
                while (iPid >= 0) {
                    member = service.getPartitionOwner(iPid);
                    if (member != null) {
                        iNextPid = iPrevPid;
                        continue block2;
                    }
                    iPid = setRemain.next(iPid + 1);
                }
            }
            PartitionSet setColocated = service.getOwnedPartitions(member);
            setPids.retain(setColocated);
            setRemain.remove(setPids);
        } else {
            if (iPrevPid >= 0) {
                setPids.remove(iPrevPid);
            }
            setPids.add(iNextPid);
            setRemain.remove(iNextPid);
        }
        this.m_iPrevPid = iNextPid;
        return true;
    }
}

