/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.oracle.coherence.common.base.Disposable;
import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.partition.PartitionAwareBackingMap;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.ChainedEnumerator;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SparseArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionSplittingBackingMap
extends AbstractKeyBasedMap
implements Disposable,
PartitionAwareBackingMap {
    static final Object[] NO_OBJECTS = new Object[0];
    private BackingMapManager m_bmm;
    private BackingMapManagerContext m_ctx;
    private String m_sName;
    private volatile MapArray m_maparray;
    private AggregatingCacheStatistics m_stats;
    private boolean m_fStrict = true;

    public PartitionSplittingBackingMap(BackingMapManager bmm, String sName) {
        this.m_bmm = bmm;
        this.m_ctx = bmm.getContext();
        this.m_sName = sName;
        this.m_maparray = new MapArray(((PartitionedService)((Object)this.m_ctx.getCacheService())).getPartitionCount());
    }

    @Override
    public void clear() {
        Map[] amap = this.getMapArray().getBackingMaps();
        int c = amap.length;
        for (int i = 0; i < c; ++i) {
            amap[i].clear();
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        Map map = this.getBackingMap(oKey);
        return map != null && map.containsKey(oKey);
    }

    public Object get(Object oKey) {
        Map map = this.getBackingMap(oKey);
        return map == null ? null : map.get(oKey);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(this.getMapArray().getBackingMaps());
    }

    public Object put(Object oKey, Object oValue) {
        Map map = this.getBackingMap(oKey);
        if (map == null) {
            this.reportMissingPartition(oKey, -1);
            return null;
        }
        return this.putInternal(map, oKey, oValue);
    }

    public void putAll(Map map) {
        if (map.isEmpty()) {
            return;
        }
        BackingMapManagerContext ctx = this.getContext();
        Iterator iter = map.keySet().iterator();
        int nPid = ctx.getKeyPartition(iter.next());
        boolean fSame = true;
        while (iter.hasNext()) {
            int nPidNext = ctx.getKeyPartition(iter.next());
            if (nPidNext == nPid) continue;
            fSame = false;
            break;
        }
        if (fSame) {
            Map mapPart = this.getPartitionMap(nPid);
            if (mapPart == null) {
                this.reportMissingPartition(null, nPid);
            } else {
                this.putAllInternal(mapPart, map);
            }
            return;
        }
        SparseArray array = new SparseArray();
        for (Map.Entry entry : map.entrySet()) {
            Object oKey = entry.getKey();
            int nPid2 = ctx.getKeyPartition(oKey);
            LiteMap mapPid = (LiteMap)array.get(nPid2);
            if (mapPid == null) {
                mapPid = new LiteMap();
                array.set(nPid2, mapPid);
            }
            mapPid.put(oKey, entry.getValue());
        }
        Iterator iter2 = array.iterator();
        while (iter2.hasNext()) {
            Map mapPid = (Map)iter2.next();
            int nPid3 = (int)iter2.getIndex();
            Map mapPart = this.getPartitionMap(nPid3);
            if (mapPart == null) {
                this.reportMissingPartition(null, nPid3);
                continue;
            }
            this.putAllInternal(mapPart, mapPid);
        }
    }

    public Object remove(Object oKey) {
        Map mapPart = this.getBackingMap(oKey);
        if (mapPart == null) {
            this.reportMissingPartition(oKey, -1);
            return null;
        }
        return mapPart.remove(oKey);
    }

    @Override
    protected boolean removeBlind(Object oKey) {
        Map mapPart = this.getBackingMap(oKey);
        return mapPart != null && mapPart.keySet().remove(oKey);
    }

    @Override
    public int size() {
        return this.size(this.getMapArray().getBackingMaps());
    }

    protected Iterator iterateKeys() {
        return this.iterateKeys(this.getMapArray().getBackingMaps());
    }

    protected Set instantiateKeySet() {
        return new KeySet();
    }

    public CacheStatistics getCacheStatistics() {
        AggregatingCacheStatistics stats = this.m_stats;
        if (stats == null) {
            this.m_stats = stats = new AggregatingCacheStatistics();
        }
        return stats;
    }

    @Override
    public BackingMapManager getBackingMapManager() {
        return this.m_bmm;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void createPartition(int nPid) {
        if (this.getPartitionMap(nPid) != null) {
            String sMsg = "Partition " + nPid + " already exists at " + this.toString(false);
            if (this.isStrict()) {
                throw new IllegalStateException(sMsg);
            }
            PartitionSplittingBackingMap.err(this.format(sMsg, 0));
            return;
        }
        Map map = this.getBackingMapManager().instantiateBackingMap(this.makeName(this.getName(), nPid));
        this.m_maparray = this.m_maparray.addMap(nPid, map);
    }

    @Override
    public void destroyPartition(int nPid) {
        Map map = this.getPartitionMap(nPid);
        if (map == null) {
            this.reportMissingPartition(null, nPid);
            return;
        }
        this.m_maparray = this.m_maparray.removeMap(nPid);
        this.getBackingMapManager().releaseBackingMap(this.makeName(this.getName(), nPid), map);
    }

    @Override
    public Map getPartitionMap(int nPid) {
        return this.m_maparray.getBackingMap(nPid);
    }

    @Override
    public Map getPartitionMap(PartitionSet partitions) {
        return new MaskedPartitionMap(partitions);
    }

    @Override
    public void dispose() {
        for (Map mapPart : this.m_maparray.getBackingMaps()) {
            if (!(mapPart instanceof Disposable)) continue;
            ((Disposable)((Object)mapPart)).dispose();
        }
        this.m_maparray = new MapArray(((PartitionedService)((Object)this.m_ctx.getCacheService())).getPartitionCount());
    }

    public boolean isStrict() {
        return this.m_fStrict;
    }

    public void setStrict(boolean fStrict) {
        this.m_fStrict = fStrict;
    }

    protected Object putInternal(Map mapPart, Object oKey, Object oValue) {
        return mapPart.put(oKey, oValue);
    }

    protected void putAllInternal(Map mapPart, Map mapUpdate) {
        mapPart.putAll(mapUpdate);
    }

    protected BackingMapManagerContext getContext() {
        return this.m_ctx;
    }

    protected int size(Map[] amap) {
        int cItems = 0;
        int c = amap.length;
        for (int i = 0; i < c; ++i) {
            cItems += amap[i].size();
        }
        return cItems;
    }

    protected boolean isEmpty(Map[] amap) {
        int c = amap.length;
        for (int i = 0; i < c; ++i) {
            if (amap[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected Iterator iterateKeys(Map[] amap) {
        int c = amap.length;
        if (c == 0) {
            return NullImplementation.getIterator();
        }
        if (amap[0] instanceof BinaryMap) {
            return new PartitionedIterator(amap);
        }
        Iterator[] aiter = new Iterator[c];
        for (int i = 0; i < c; ++i) {
            aiter[i] = amap[i].keySet().iterator();
        }
        return new ChainedEnumerator(aiter);
    }

    protected MapArray getMapArray() {
        return this.m_maparray;
    }

    protected Map getBackingMap(Object oKey) {
        return this.getPartitionMap(this.getContext().getKeyPartition(oKey));
    }

    protected String makeName(String sName, int nPid) {
        return sName + "-" + nPid;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fVerbose) {
        StringBuffer sb = new StringBuffer(ClassHelper.getSimpleName(this.getClass()));
        sb.append("{Name=").append(this.getName()).append(',');
        if (!fVerbose) {
            sb.append("Partitions=[");
        }
        MapArray array = this.getMapArray();
        for (int iPid : array.getPartitions()) {
            if (fVerbose) {
                sb.append('\n').append(iPid).append(": ").append(array.getBackingMap(iPid));
            } else {
                sb.append(iPid);
            }
            sb.append(',');
        }
        if (!fVerbose) {
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    protected void reportMissingPartition(Object oKey, int nPid) {
        if (nPid < 0) {
            nPid = this.getContext().getKeyPartition(oKey);
        }
        String sMsg = "Partition " + nPid + " does not exist at " + this.toString(false) + (oKey == null ? "" : "; key=" + oKey);
        if (this.isStrict()) {
            throw new IllegalStateException(sMsg);
        }
        PartitionSplittingBackingMap.err(this.format(sMsg, 1));
    }

    private String format(String sMessage, int iStackDepth) {
        try {
            return PartitionSplittingBackingMap.getStackFrames()[iStackDepth + 1] + ": " + this.getName() + ": " + sMessage;
        }
        catch (Throwable e) {
            return sMessage;
        }
    }

    protected class KeySet
    extends AbstractKeyBasedMap.KeySet {
        protected KeySet() {
            super(PartitionSplittingBackingMap.this);
        }

        @Override
        public boolean removeAll(Collection coll) {
            boolean fRemove = false;
            for (Object oKey : coll) {
                fRemove |= PartitionSplittingBackingMap.this.removeBlind(oKey);
            }
            return fRemove;
        }
    }

    public class AggregatingCacheStatistics
    implements CacheStatistics {
        private static final int PROP_GETS = 0;
        private static final int PROP_GETS_MILLIS = 1;
        private static final int PROP_PUTS = 2;
        private static final int PROP_PUTS_MILLIS = 3;
        private static final int PROP_HITS = 4;
        private static final int PROP_HITS_MILLIS = 5;
        private static final int PROP_MISSES = 6;
        private static final int PROP_MISSES_MILLIS = 7;
        private static final int PROP_PRUNES = 8;
        private static final int PROP_PRUNES_MILLIS = 9;

        @Override
        public long getTotalGets() {
            return this.calculateTotal(0);
        }

        @Override
        public long getTotalGetsMillis() {
            return this.calculateTotal(1);
        }

        @Override
        public double getAverageGetMillis() {
            double cMillis = this.getTotalGetsMillis();
            double cGets = this.getTotalGets();
            return cGets == 0.0 ? 0.0 : cMillis / cGets;
        }

        @Override
        public long getTotalPuts() {
            return this.calculateTotal(2);
        }

        @Override
        public long getTotalPutsMillis() {
            return this.calculateTotal(3);
        }

        @Override
        public double getAveragePutMillis() {
            double cMillis = this.getTotalPutsMillis();
            double cPuts = this.getTotalPuts();
            return cPuts == 0.0 ? 0.0 : cMillis / cPuts;
        }

        @Override
        public long getCacheHits() {
            return this.calculateTotal(4);
        }

        @Override
        public long getCacheHitsMillis() {
            return this.calculateTotal(5);
        }

        @Override
        public double getAverageHitMillis() {
            double cMillis = this.getCacheHitsMillis();
            double cGets = this.getCacheHits();
            return cGets == 0.0 ? 0.0 : cMillis / cGets;
        }

        @Override
        public long getCacheMisses() {
            return this.calculateTotal(6);
        }

        @Override
        public long getCacheMissesMillis() {
            return this.calculateTotal(7);
        }

        @Override
        public double getAverageMissMillis() {
            double cMillis = this.getCacheMissesMillis();
            double cGets = this.getCacheMisses();
            return cGets == 0.0 ? 0.0 : cMillis / cGets;
        }

        @Override
        public double getHitProbability() {
            double cHits = this.getCacheHits();
            double cTotal = cHits + (double)this.getCacheMisses();
            return cTotal == 0.0 ? 0.0 : cHits / cTotal;
        }

        @Override
        public long getCachePrunes() {
            return this.calculateTotal(8);
        }

        @Override
        public long getCachePrunesMillis() {
            return this.calculateTotal(9);
        }

        @Override
        public void resetHitStatistics() {
            for (CacheStatistics stats : PartitionSplittingBackingMap.this.getMapArray().getCacheStatistics()) {
                if (stats == null) continue;
                stats.resetHitStatistics();
            }
        }

        private long calculateTotal(int nProp) {
            long cTotal = 0L;
            boolean fAny = false;
            for (CacheStatistics stats : PartitionSplittingBackingMap.this.getMapArray().getCacheStatistics()) {
                long n;
                if (stats == null) continue;
                switch (nProp) {
                    case 0: {
                        n = stats.getTotalGets();
                        break;
                    }
                    case 1: {
                        n = stats.getTotalGetsMillis();
                        break;
                    }
                    case 2: {
                        n = stats.getTotalPuts();
                        break;
                    }
                    case 3: {
                        n = stats.getTotalPutsMillis();
                        break;
                    }
                    case 4: {
                        n = stats.getCacheHits();
                        break;
                    }
                    case 5: {
                        n = stats.getCacheHitsMillis();
                        break;
                    }
                    case 6: {
                        n = stats.getCacheMisses();
                        break;
                    }
                    case 7: {
                        n = stats.getCacheMissesMillis();
                        break;
                    }
                    case 8: {
                        n = stats.getCachePrunes();
                        break;
                    }
                    case 9: {
                        n = stats.getCachePrunesMillis();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("invalid property=" + nProp);
                    }
                }
                if (n < 0L) continue;
                cTotal += n;
                fAny = true;
            }
            return fAny ? cTotal : -1L;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("CacheStatistics {TotalGets=").append(this.getTotalGets()).append(", TotalGetsMillis=").append(this.getTotalGetsMillis()).append(", AverageGetMillis=").append(this.getAverageGetMillis()).append(", TotalPuts=").append(this.getTotalPuts()).append(", TotalPutsMillis=").append(this.getTotalPutsMillis()).append(", AveragePutMillis=").append(this.getAveragePutMillis()).append(", CacheHits=").append(this.getCacheHits()).append(", CacheHitsMillis=").append(this.getCacheHitsMillis()).append(", AverageHitMillis=").append(this.getAverageHitMillis()).append(", CacheMisses=").append(this.getCacheMisses()).append(", CacheMissesMillis=").append(this.getCacheMissesMillis()).append(", AverageMissMillis=").append(this.getAverageMissMillis()).append(", HitProbability=").append(this.getHitProbability()).append(", Prunes=").append(this.getCachePrunes()).append(", PruneMillis=").append(this.getCachePrunesMillis()).append('}');
            return sb.toString();
        }
    }

    public class MaskedPartitionMap
    extends AbstractKeyBasedMap
    implements Map {
        private PartitionSet m_partMask;
        private Map[] m_amap;

        protected MaskedPartitionMap(PartitionSet partMask) {
            MapArray array = PartitionSplittingBackingMap.this.getMapArray();
            PartitionSet partCurrent = array.getPartitionSet();
            if (!partCurrent.contains(partMask)) {
                String sMsg = partMask + " not a subset of " + partCurrent;
                if (PartitionSplittingBackingMap.this.isStrict()) {
                    throw new IllegalArgumentException(sMsg);
                }
                MaskedPartitionMap.err(sMsg);
                partMask = new PartitionSet(partMask);
                partMask.retain(partCurrent);
            }
            this.m_partMask = partMask;
            this.m_amap = array.getBackingMaps(partMask);
        }

        public Object get(Object oKey) {
            return this.m_partMask.contains(PartitionSplittingBackingMap.this.getContext().getKeyPartition(oKey)) ? PartitionSplittingBackingMap.this.get(oKey) : null;
        }

        @Override
        public boolean containsKey(Object oKey) {
            return this.m_partMask.contains(PartitionSplittingBackingMap.this.getContext().getKeyPartition(oKey)) && PartitionSplittingBackingMap.this.containsKey(oKey);
        }

        @Override
        public boolean isEmpty() {
            return PartitionSplittingBackingMap.this.isEmpty(this.m_amap);
        }

        @Override
        public int size() {
            return PartitionSplittingBackingMap.this.size(this.m_amap);
        }

        protected Iterator iterateKeys() {
            return PartitionSplittingBackingMap.this.iterateKeys(this.m_amap);
        }
    }

    public class PartitionedIterator
    extends AbstractStableIterator {
        private Map[] m_amap;
        private int m_iNextMap;
        private Object[] m_aoKey;
        private int m_iNextKey;

        protected PartitionedIterator(Map[] amap) {
            this.m_amap = amap;
            this.m_iNextMap = 0;
            this.m_iNextKey = 0;
            this.m_aoKey = NO_OBJECTS;
        }

        @Override
        protected void advance() {
            Object[] aoKey = this.m_aoKey;
            int iNext = this.m_iNextKey;
            while (iNext >= aoKey.length) {
                int iNextMap = this.m_iNextMap;
                Map[] amap = this.m_amap;
                if (iNextMap >= amap.length) {
                    this.m_aoKey = NO_OBJECTS;
                    this.m_iNextKey = 0;
                    return;
                }
                this.m_aoKey = aoKey = amap[iNextMap].keySet().toArray();
                iNext = 0;
                this.m_iNextKey = 0;
                this.m_iNextMap = iNextMap + 1;
            }
            this.setNext(aoKey[iNext]);
            this.m_iNextKey = iNext + 1;
        }

        protected void remove(Object oPrev) {
            PartitionSplittingBackingMap.this.remove(oPrev);
        }
    }

    public static class MapArray {
        private PartitionSet m_partitions;
        private int[] m_ai;
        private Map[] m_amap;
        private CacheStatistics[] m_astat;

        public MapArray(int cPartitions) {
            this(new PartitionSet(cPartitions), new int[0], new Map[0], new CacheStatistics[0]);
        }

        private MapArray(PartitionSet partitions, int[] aiPid, Map[] amapBacking, CacheStatistics[] astat) {
            this.m_partitions = partitions;
            this.m_ai = aiPid;
            this.m_amap = amapBacking;
            this.m_astat = astat;
        }

        public int[] getPartitions() {
            return this.m_ai;
        }

        public PartitionSet getPartitionSet() {
            return this.m_partitions;
        }

        public Map getBackingMap(int nPid) {
            int i = Arrays.binarySearch(this.m_ai, nPid);
            return i < 0 ? null : this.m_amap[i];
        }

        public Map[] getBackingMaps() {
            return this.m_amap;
        }

        public Map[] getBackingMaps(PartitionSet partitions) {
            if (this.m_partitions.equals(partitions)) {
                return this.m_amap;
            }
            int cPids = partitions.cardinality();
            Map[] amap = new Map[cPids];
            if (cPids <= 16) {
                int nPid = partitions.next(0);
                int iAppend = 0;
                while (nPid >= 0) {
                    amap[iAppend++] = this.getBackingMap(nPid);
                    nPid = partitions.next(nPid + 1);
                }
            } else {
                int[] aiPid = this.m_ai;
                Map[] amapAll = this.m_amap;
                int c = aiPid.length;
                int iAppend = 0;
                for (int i = 0; i < c; ++i) {
                    if (!partitions.contains(aiPid[i])) continue;
                    amap[iAppend++] = amapAll[i];
                }
            }
            return amap;
        }

        public CacheStatistics[] getCacheStatistics() {
            return this.m_astat;
        }

        public MapArray addMap(int nPid, Map mapBacking) {
            int[] aiOld = this.m_ai;
            Map[] amapOld = this.m_amap;
            CacheStatistics[] astatOld = this.m_astat;
            int i = Arrays.binarySearch(aiOld, nPid);
            Base.azzert(i < 0);
            i = -(i + 1);
            int cOld = aiOld.length;
            int cNew = cOld + 1;
            int[] aiNew = new int[cNew];
            Map[] amapNew = new Map[cNew];
            CacheStatistics[] astatNew = new CacheStatistics[cNew];
            if (i > 0) {
                System.arraycopy(aiOld, 0, aiNew, 0, i);
                System.arraycopy(amapOld, 0, amapNew, 0, i);
                System.arraycopy(astatOld, 0, astatNew, 0, i);
            }
            CacheStatistics stats = null;
            try {
                stats = (CacheStatistics)ClassHelper.invoke(mapBacking, "getCacheStatistics", ClassHelper.VOID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aiNew[i] = nPid;
            amapNew[i] = mapBacking;
            astatNew[i] = stats;
            int cRemain = cOld - i;
            if (cRemain > 0) {
                System.arraycopy(aiOld, i, aiNew, i + 1, cRemain);
                System.arraycopy(amapOld, i, amapNew, i + 1, cRemain);
                System.arraycopy(astatOld, i, astatNew, i + 1, cRemain);
            }
            PartitionSet partitions = new PartitionSet(this.m_partitions);
            partitions.add(nPid);
            return new MapArray(partitions, aiNew, amapNew, astatNew);
        }

        public MapArray removeMap(int nPid) {
            int cRemain;
            int[] aiOld = this.m_ai;
            Map[] amapOld = this.m_amap;
            CacheStatistics[] astatOld = this.m_astat;
            int i = Arrays.binarySearch(aiOld, nPid);
            Base.azzert(i >= 0);
            int cOld = aiOld.length;
            int cNew = cOld - 1;
            int[] aiNew = new int[cNew];
            Map[] amapNew = new Map[cNew];
            CacheStatistics[] astatNew = new CacheStatistics[cNew];
            if (i > 0) {
                System.arraycopy(aiOld, 0, aiNew, 0, i);
                System.arraycopy(amapOld, 0, amapNew, 0, i);
                System.arraycopy(astatOld, 0, astatNew, 0, i);
            }
            if ((cRemain = cOld - i - 1) > 0) {
                System.arraycopy(aiOld, i + 1, aiNew, i, cRemain);
                System.arraycopy(amapOld, i + 1, amapNew, i, cRemain);
                System.arraycopy(astatOld, i + 1, astatNew, i, cRemain);
            }
            PartitionSet partitions = new PartitionSet(this.m_partitions);
            partitions.remove(nPid);
            return new MapArray(partitions, aiNew, amapNew, astatNew);
        }
    }
}

