/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.datagrid.persistence.OfflinePersistenceInfo;
import com.oracle.datagrid.persistence.PersistenceStatistics;
import com.oracle.datagrid.persistence.PersistenceTools;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.AbstractPersistenceTools;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.persistence.Snapshot;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.persistence.bdb.BerkeleyDBEnvironment;
import com.tangosol.util.Base;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public abstract class AbstractSnapshotArchiver
implements SnapshotArchiver {
    protected final String f_sClusterName;
    protected final String f_sServiceName;
    protected long m_cMillisTotal = 0L;
    protected long m_cMillisMax = Long.MIN_VALUE;
    protected long m_cMillisMin = Long.MAX_VALUE;
    protected long m_cMillisLastStart = -1L;

    public AbstractSnapshotArchiver(String sClusterName, String sServiceName) {
        this.f_sClusterName = sClusterName;
        this.f_sServiceName = sServiceName;
    }

    @Override
    public String[] list() {
        return this.listInternal();
    }

    @Override
    public Snapshot get(String sSnapshot) {
        return new Snapshot(sSnapshot, this.listStoresInternal(sSnapshot));
    }

    @Override
    public synchronized boolean remove(String sSnapshot) {
        if (!this.hasArchivedSnapshot(sSnapshot)) {
            throw new IllegalArgumentException("The snapshot " + sSnapshot + " does not exist");
        }
        return this.removeInternal(sSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void archive(Snapshot snapshot, PersistenceEnvironment<ReadBuffer> env) {
        String sSnapshot = snapshot.getName();
        PersistenceManager<ReadBuffer> mgr = null;
        if (!this.hasLocalSnapshot(env, sSnapshot)) {
            throw new IllegalArgumentException("The snapshot " + sSnapshot + " does not exist");
        }
        this.resetStatistics();
        PersistenceEnvironment<ReadBuffer> persistenceEnvironment = env;
        synchronized (persistenceEnvironment) {
            try {
                mgr = env.openSnapshot(sSnapshot);
                this.archiveInternal(snapshot, mgr);
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
            }
        }
        this.displayStatistics(snapshot, "archive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void retrieve(Snapshot snapshot, PersistenceEnvironment<ReadBuffer> env) {
        String sSnapshotName = snapshot.getName();
        PersistenceManager<ReadBuffer> mgr = null;
        this.resetStatistics();
        PersistenceEnvironment<ReadBuffer> persistenceEnvironment = env;
        synchronized (persistenceEnvironment) {
            try {
                mgr = env.createSnapshot(sSnapshotName, null);
                this.retrieveInternal(snapshot, mgr);
            }
            finally {
                if (mgr != null) {
                    mgr.release();
                }
            }
        }
        this.displayStatistics(snapshot, "retrieve");
    }

    @Override
    public PersistenceTools getPersistenceTools(String sSnapshot) {
        if (!this.hasArchivedSnapshot(sSnapshot)) {
            throw new IllegalArgumentException("The snapshot " + sSnapshot + " is not known to the archiver " + this.toString());
        }
        try {
            Properties props = this.getMetadata(sSnapshot);
            if (props == null) {
                throw new IllegalArgumentException("Cannot load properties file meta.properties for snapshot " + sSnapshot);
            }
            String[] asStores = this.listStoresInternal(sSnapshot);
            if (asStores.length == 0) {
                throw new IllegalArgumentException("The snapshot " + sSnapshot + " has no stores, unable to continue");
            }
            OfflinePersistenceInfo info = new OfflinePersistenceInfo((int)Integer.valueOf(props.getProperty("partition.count")), props.getProperty("storage.format"), true, this.listStoresInternal(sSnapshot), (int)Integer.valueOf(props.getProperty("storage.version")), (int)Integer.valueOf(props.getProperty("implementation.version")), props.get("service.version").toString());
            return this.instantiatePersistenceTools(info, sSnapshot);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate persistence tools for snapshot " + sSnapshot + " - " + e.getMessage());
        }
    }

    protected abstract String[] listInternal();

    protected abstract void archiveInternal(Snapshot var1, PersistenceManager<ReadBuffer> var2);

    protected abstract void retrieveInternal(Snapshot var1, PersistenceManager<ReadBuffer> var2);

    protected abstract boolean removeInternal(String var1);

    protected abstract String[] listStoresInternal(String var1);

    protected abstract Properties getMetadata(String var1) throws IOException;

    protected PersistenceTools instantiatePersistenceTools(OfflinePersistenceInfo info, String sSnapshot) {
        return new SnapshotArchiverPersistenceTools(info, sSnapshot);
    }

    protected void resetStatistics() {
        this.m_cMillisMax = Long.MIN_VALUE;
        this.m_cMillisMin = Long.MAX_VALUE;
        this.m_cMillisTotal = 0L;
    }

    protected void recordStartTime() {
        this.m_cMillisLastStart = Base.getLastSafeTimeMillis();
    }

    protected void recordEndTime() {
        long cMillisDuration = Base.getLastSafeTimeMillis() - this.m_cMillisLastStart;
        this.m_cMillisTotal += cMillisDuration;
        if (cMillisDuration > this.m_cMillisMax) {
            this.m_cMillisMax = cMillisDuration;
        }
        if (cMillisDuration < this.m_cMillisMin) {
            this.m_cMillisMin = cMillisDuration;
        }
    }

    protected void displayStatistics(Snapshot snapshot, String sType) {
        int cStores = snapshot.listStores().length;
        StringBuilder sb = new StringBuilder("Statistics for ");
        sb.append(sType).append(" of snapshot ").append(snapshot.getName()).append(": Number of stores ").append(sType).append("d by this member=").append(cStores).append(", Total time=").append(this.m_cMillisTotal).append("ms, Average=").append(cStores == 0 ? 0L : this.m_cMillisTotal / (long)cStores).append("ms, Min=").append(this.m_cMillisMin).append("ms, Max=").append(this.m_cMillisMax).append("ms");
        CacheFactory.log(sb.toString(), 6);
    }

    public String toString() {
        return "AbstractSnapshotArchiver(class=" + this.getClass().getCanonicalName() + ", Cluster=" + this.f_sClusterName + ", Service=" + this.f_sServiceName + ")";
    }

    protected boolean hasLocalSnapshot(PersistenceEnvironment<ReadBuffer> env, String sSnapshot) {
        return this.containsElement(env.listSnapshots(), sSnapshot);
    }

    protected boolean hasArchivedSnapshot(String sSnapshot) {
        return this.containsElement(this.list(), sSnapshot);
    }

    private boolean containsElement(String[] asString, String sElement) {
        int c = asString.length;
        for (int i = 0; i < c; ++i) {
            if (sElement == null || !sElement.equals(asString[i])) continue;
            return true;
        }
        return false;
    }

    protected PersistenceEnvironment<ReadBuffer> createTempEnvironment(File fileBaseDir, String sStorageFormat) throws IOException {
        CacheFactory.log("Creating temporary PersistenceEnvironment under " + fileBaseDir.getAbsolutePath() + " using format " + sStorageFormat, 5);
        if (sStorageFormat == null || sStorageFormat.isEmpty()) {
            throw new IllegalArgumentException("Invalid validation format " + sStorageFormat);
        }
        if (sStorageFormat.equals("BDB")) {
            return new BerkeleyDBEnvironment(new File(fileBaseDir, "active"), new File(fileBaseDir, "snapshots"), new File(fileBaseDir, "trash"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMetadata(File fileDir, PersistenceManager<ReadBuffer> mgr, String sStore) throws IOException {
        Properties props = new Properties();
        PersistentStore<ReadBuffer> store = null;
        try {
            AbstractPersistenceManager abstractMgr = (AbstractPersistenceManager)SafePersistenceWrappers.unwrap(mgr);
            store = mgr.open(sStore, null);
            props.setProperty("implementation.version", String.valueOf(abstractMgr.getImplVersion()));
            props.setProperty("storage.version", String.valueOf(abstractMgr.getStorageVersion()));
            props.setProperty("storage.format", String.valueOf(abstractMgr.getStorageFormat()));
            props.setProperty("partition.count", String.valueOf(CachePersistenceHelper.getPartitionCount(store)));
            props.setProperty("service.version", String.valueOf(CachePersistenceHelper.getServiceVersion(store)));
            CachePersistenceHelper.writeMetadata(fileDir, props);
        }
        finally {
            if (store != null) {
                mgr.close(sStore);
            }
        }
    }

    private class SnapshotArchiverPersistenceTools
    extends AbstractPersistenceTools {
        protected final String f_sSnapshot;

        public SnapshotArchiverPersistenceTools(OfflinePersistenceInfo info, String sSnapshot) {
            super(info);
            this.f_sSnapshot = sSnapshot;
        }

        @Override
        public void validate() {
            this.validateArchivedSnapshot(false);
        }

        @Override
        public PersistenceStatistics getStatistics() {
            return this.validateArchivedSnapshot(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected PersistenceStatistics validateArchivedSnapshot(boolean fCollectStats) {
            Snapshot snapshotAllStores;
            PersistenceStatistics stats = null;
            AbstractPersistenceTools.StatsVisitor visitor = null;
            PersistenceEnvironment<ReadBuffer> env = null;
            PersistenceManager<ReadBuffer> manager = null;
            File dirTemp = null;
            if (fCollectStats) {
                stats = new PersistenceStatistics();
                visitor = new AbstractPersistenceTools.StatsVisitor(stats);
            }
            if ((snapshotAllStores = AbstractSnapshotArchiver.this.get(this.f_sSnapshot)) == null) {
                throw new IllegalArgumentException("Snapshot " + this.f_sSnapshot + " is not known to this archiver");
            }
            String[] asStores = snapshotAllStores.listStores();
            if (!this.f_info.isComplete()) {
                throw new RuntimeException("The archived snapshot is not complete. Number of stores is " + asStores.length + " but number of partitions is " + this.f_info.getPartitionCount());
            }
            try {
                Properties props = AbstractSnapshotArchiver.this.getMetadata(this.f_sSnapshot);
                String sStorageFormat = props.getProperty("storage.format");
                dirTemp = FileHelper.createTempDir();
                env = AbstractSnapshotArchiver.this.createTempEnvironment(dirTemp, sStorageFormat);
                for (String sStore : asStores) {
                    Snapshot snapshot = new Snapshot(this.f_sSnapshot, new String[]{sStore});
                    AbstractSnapshotArchiver.this.retrieve(snapshot, env);
                    manager = env.openSnapshot(this.f_sSnapshot);
                    PersistentStore<ReadBuffer> store = manager.open(sStore, null);
                    if (fCollectStats) {
                        visitor.setCaches(CachePersistenceHelper.getCacheNames(store));
                        store.iterate(CachePersistenceHelper.instantiatePersistenceVisitor(visitor));
                    }
                    manager.close(sStore);
                    env.removeSnapshot(this.f_sSnapshot);
                }
                if (manager != null) {
                    manager.release();
                }
                if (env != null) {
                    env.release();
                }
                if (dirTemp == null) return stats;
            }
            catch (IOException ioe) {
                try {
                    throw CachePersistenceHelper.ensurePersistenceException(ioe, "Unable to create temporary directory");
                }
                catch (Throwable throwable) {
                    if (manager != null) {
                        manager.release();
                    }
                    if (env != null) {
                        env.release();
                    }
                    if (dirTemp == null) throw throwable;
                    FileHelper.deleteDirSilent(dirTemp);
                    throw throwable;
                }
            }
            FileHelper.deleteDirSilent(dirTemp);
            return stats;
        }
    }
}

