/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence.ldb;

import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.tangosol.io.ReadBuffer;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.ldb.LevelDBManager;
import java.io.File;
import java.io.IOException;

public class LevelDBEnvironment
extends AbstractPersistenceEnvironment {
    public LevelDBEnvironment(File fileActive, File fileSnapshot, File fileTrash) throws IOException {
        super(fileActive, fileSnapshot, fileTrash);
    }

    @Override
    protected AbstractPersistenceManager openActiveInternal() {
        try {
            return new LevelDBManager(this.getPersistenceActiveDirectory(), this.getPersistenceTrashDirectory(), null);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager openSnapshotInternal(File fileSnapshot, String sSnapshot) {
        try {
            return new LevelDBManager(fileSnapshot, null, sSnapshot);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager createSnapshotInternal(File fileSnapshot, String sSnapshot, PersistenceManager<ReadBuffer> manager) {
        if (manager != null && !(manager instanceof LevelDBManager)) {
            throw new IllegalArgumentException("incompatible persistence manager type: " + manager.getClass());
        }
        LevelDBManager snapshot = (LevelDBManager)this.openSnapshotInternal(fileSnapshot, sSnapshot);
        if (manager instanceof LevelDBManager) {
            try {
                ((LevelDBManager)manager).createSnapshot(fileSnapshot);
            }
            catch (PersistenceException e) {
                snapshot.release();
                throw e;
            }
        }
        return snapshot;
    }
}

