/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence.ldb;

import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.datagrid.persistence.OfflinePersistenceInfo;
import com.oracle.datagrid.persistence.PersistenceTools;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.GuardSupport;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.util.Binary;
import com.tangosol.util.BitHelper;
import com.tangosol.util.Unsafe;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class LevelDBManager
extends AbstractPersistenceManager<LevelDBStore> {
    public static final long METADATA_EXTENT = Long.MIN_VALUE;
    protected static final ReadBuffer EXTENT_IDS_KEY = new Binary();
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    public LevelDBManager(File fileData, File fileTrash, String sName) throws IOException {
        super(fileData, fileTrash, sName);
    }

    @Override
    protected int getImplVersion() {
        return 0;
    }

    @Override
    protected String getStorageFormat() {
        return "LDB";
    }

    @Override
    protected int getStorageVersion() {
        return 0;
    }

    protected void createSnapshot(final File fileSnapshot) {
        this.executeTaskExclusive(new AbstractPersistenceManager.Task(){

            @Override
            public void execute() {
                Map map = LevelDBManager.this.getPersistentStoreMap();
                for (LevelDBStore store : map.values()) {
                    GuardSupport.heartbeat();
                    File fileDirFrom = store.getDataDirectory();
                    File fileDirTo = new File(fileSnapshot, fileDirFrom.getName());
                    try {
                        FileHelper.copyDir(fileDirFrom, fileDirTo);
                    }
                    catch (IOException e) {
                        throw LevelDBManager.this.ensurePersistenceException(e, "error creating snapshot \"" + fileSnapshot + "\" while copying persistent store \"" + fileDirFrom + '\"');
                    }
                }
            }
        });
    }

    @Override
    protected PersistenceTools instantiatePersistenceTools(OfflinePersistenceInfo info) {
        return new AbstractPersistenceManager.AbstractPersistenceSnapshotTools(this.getDataDirectory(), info){

            @Override
            public void validate() {
                this.getStatistics();
            }
        };
    }

    @Override
    protected LevelDBStore instantiatePersistentStore(String sId) {
        return new LevelDBStore(sId);
    }

    protected class LevelDBStore
    extends AbstractPersistenceManager.AbstractPersistentStore {
        protected DB m_db;

        protected LevelDBStore(String sId) {
            super(sId);
        }

        @Override
        protected void validateExtentId(long lExtentId) {
            if (lExtentId == Long.MIN_VALUE) {
                throw new IllegalArgumentException("reserved extent identifier");
            }
            super.validateExtentId(lExtentId);
        }

        @Override
        protected void openInternal() {
            if (this.m_db == null) {
                Options options = new Options();
                options.createIfMissing(true);
                options.cacheSize(0L);
                try {
                    this.m_db = JniDBFactory.factory.open(this.f_dirStore, options);
                }
                catch (IOException e) {
                    throw this.ensurePersistenceException(new FatalAccessException("error opening the LevelDB database in directory \"" + this.f_dirStore + '\"', e));
                }
            }
        }

        @Override
        protected void releaseInternal() {
            DB db = this.m_db;
            if (db != null) {
                try {
                    db.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.m_db = null;
            }
        }

        @Override
        protected boolean deleteInternal() {
            try {
                JniDBFactory.factory.destroy(this.f_dirStore, new Options());
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        protected void loadExtentIdsInternal(Set<Long> set) {
            byte[] ab;
            ReadBuffer buf = this.loadInternal(Long.MIN_VALUE, EXTENT_IDS_KEY);
            byte[] byArray = ab = buf == null ? null : this.getByteArrayUnsafe(buf);
            if (ab != null && ab.length > 0) {
                int i = 0;
                int c = BitHelper.toInt(ab, 0);
                int of = 4;
                while (i < c) {
                    set.add(BitHelper.toLong(ab, of));
                    ++i;
                    of += 8;
                }
            }
        }

        @Override
        protected void createExtentInternal(long lExtentId) {
            this.saveExtentIds(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void deleteExtentInternal(long lExtentId) {
            DB db = this.m_db;
            if (db != null) {
                WriteBatch batch = (WriteBatch)this.begin();
                boolean fAbort = true;
                DBIterator iter = db.iterator();
                try {
                    iter.seekToFirst();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        byte[] abKey = (byte[])entry.getKey();
                        long lId = this.extractExtentId(abKey);
                        if (lExtentId != lId) continue;
                        batch.delete(abKey);
                    }
                    this.saveExtentIds(batch);
                    this.commit(batch);
                }
                finally {
                    try {
                        iter.close();
                    }
                    catch (IOException iOException) {}
                    if (fAbort) {
                        this.abort(batch);
                    }
                }
            }
        }

        @Override
        protected void truncateExtentInternal(long lExtentId) {
            this.deleteExtentInternal(lExtentId);
        }

        @Override
        protected ReadBuffer loadInternal(long lExtentId, ReadBuffer bufKey) {
            try {
                byte[] ab = this.ensureDatabase().get(this.createKey(lExtentId, bufKey));
                return ab == null ? null : UNSAFE.newBinary(ab, 0, ab.length);
            }
            catch (DBException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        protected void storeInternal(long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue, Object oToken) {
            try {
                this.ensureWriteBatch(oToken).put(this.createKey(lExtentId, bufKey), this.getByteArrayUnsafe(bufValue));
            }
            catch (DBException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        protected void eraseInternal(long lExtentId, ReadBuffer bufKey, Object oToken) {
            try {
                this.ensureWriteBatch(oToken).delete(this.createKey(lExtentId, bufKey));
            }
            catch (DBException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        public void iterateInternal(PersistentStore.Visitor<ReadBuffer> visitor) {
            DB db = this.ensureDatabase();
            try (DBIterator iter = db.iterator();){
                iter.seekToFirst();
                while (iter.hasNext()) {
                    Binary bufValue;
                    Map.Entry entry = (Map.Entry)iter.next();
                    byte[] abKey = (byte[])entry.getKey();
                    long lId = this.extractExtentId(abKey);
                    Long LId = lId;
                    if (!this.f_setExtentIds.contains(LId)) continue;
                    byte[] abValue = (byte[])entry.getValue();
                    ReadBuffer bufKey = this.extractKeyContent(abKey);
                    if (visitor.visit(lId, bufKey, bufValue = UNSAFE.newBinary(abValue, 0, abValue.length))) continue;
                    return;
                }
            }
            catch (Throwable e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        public Object beginInternal() {
            try {
                return this.ensureDatabase().createWriteBatch();
            }
            catch (DBException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitInternal(Object oToken) {
            try {
                WriteBatch batch = this.ensureWriteBatch(oToken);
                try {
                    this.ensureDatabase().write(batch);
                }
                finally {
                    try {
                        batch.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (DBException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        public void abortInternal(Object oToken) {
            try {
                this.ensureWriteBatch(oToken).close();
            }
            catch (IOException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        private byte[] getByteArrayUnsafe(ReadBuffer buf) {
            byte[] ab;
            ByteArrayReadBuffer babuf;
            if (buf instanceof Binary) {
                byte[] ab2;
                Binary bin = (Binary)buf;
                if (UNSAFE.getArrayOffset(bin) == 0 && (ab2 = UNSAFE.getByteArray(bin)).length == bin.length()) {
                    return ab2;
                }
            } else if (buf instanceof ByteArrayReadBuffer && (babuf = (ByteArrayReadBuffer)buf).getRawOffset() == 0 && (ab = babuf.getRawByteArray()).length == babuf.length()) {
                return ab;
            }
            return buf.toByteArray();
        }

        protected DB ensureDatabase() {
            DB db = this.m_db;
            if (db == null) {
                throw new IllegalStateException("the LevelDB database \"" + this.f_dirStore + "\" is not open");
            }
            return db;
        }

        protected WriteBatch ensureWriteBatch(Object oToken) {
            if (oToken instanceof WriteBatch) {
                return (WriteBatch)oToken;
            }
            throw new IllegalArgumentException("illegal token: " + oToken);
        }

        protected byte[] createKey(long lExtentId, ReadBuffer bufKey) {
            assert (bufKey != null);
            int cb = bufKey.length();
            byte[] ab = new byte[cb + 8];
            BitHelper.toBytes(lExtentId, ab, 0);
            bufKey.copyBytes(0, cb, ab, 8);
            return ab;
        }

        protected long extractExtentId(byte[] abKey) {
            assert (abKey != null && abKey.length >= 8);
            return BitHelper.toLong(abKey);
        }

        protected ReadBuffer extractKeyContent(byte[] abKey) {
            assert (abKey != null && abKey.length >= 8);
            return UNSAFE.newBinary(abKey, 8, abKey.length - 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveExtentIds(Object oToken) {
            int c = this.f_setExtentIds.size();
            byte[] ab = new byte[4 + c * 8];
            BitHelper.toBytes(c, ab, 0);
            int of = 4;
            for (Long LId : this.f_setExtentIds) {
                BitHelper.toBytes(LId, ab, of);
                of += 8;
            }
            boolean fAbort = oToken == null;
            boolean fCommit = fAbort;
            if (fCommit) {
                oToken = this.begin();
            }
            try {
                this.storeInternal(Long.MIN_VALUE, EXTENT_IDS_KEY, UNSAFE.newBinary(ab, 0, ab.length), oToken);
                if (fCommit) {
                    this.commit(oToken);
                    fAbort = false;
                }
            }
            finally {
                if (fAbort) {
                    this.abort(oToken);
                }
            }
        }
    }
}

