/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.IterableAdapter;
import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.ClassHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionAdapter
extends IterableAdapter {
    private Class m_clzCollection;
    private PropertyAdapter m_adapterElement;

    public CollectionAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        CollectionAdapter.azzert(Collection.class.isAssignableFrom(clzType));
        Class clzCollection = this.getType();
        XmlElement xmlClz = xml.getElement("class");
        if (xmlClz != null) {
            clzCollection = infoBean.resolveClass(xmlClz.getString());
        }
        this.m_clzCollection = clzCollection;
        XmlElement xmlElement = xml.getElement("element");
        if (xmlElement == null) {
            throw new IllegalStateException("Missing the \"<element>\" information for the \"" + sName + "\" property of the \"" + ClassHelper.getSimpleName(infoBean.getType()) + "\" XmlBean.");
        }
        this.m_adapterElement = this.findAdapter(infoBean, xmlElement);
    }

    @Override
    public Object clone(Object o) {
        if (o == null) {
            return null;
        }
        PropertyAdapter adapterElement = this.m_adapterElement;
        Collection colOld = (Collection)o;
        Collection colNew = this.instantiateCollection();
        for (Object oElement : colOld) {
            if (oElement != null) {
                oElement = adapterElement.clone(oElement);
            }
            colNew.add(oElement);
        }
        return colNew;
    }

    @Override
    protected Object readElements(XmlElement xml) {
        Iterator iter;
        Collection collection = this.instantiateCollection();
        PropertyAdapter adapterElement = this.m_adapterElement;
        boolean fAnonymous = adapterElement.isAnonymous();
        Iterator iterator = iter = fAnonymous ? xml.getElementList().iterator() : XmlHelper.getElements(xml, this.getElementName(), adapterElement.getNamespaceUri());
        while (iter.hasNext()) {
            XmlElement xmlElement = (XmlElement)iter.next();
            Object oElement = adapterElement.fromXml(xmlElement);
            if (fAnonymous && oElement == null) continue;
            collection.add(oElement);
        }
        return collection;
    }

    @Override
    protected void writeElements(XmlElement xml, Object o) {
        Collection collection = (Collection)o;
        if (collection.isEmpty()) {
            return;
        }
        PropertyAdapter adapterElement = this.m_adapterElement;
        boolean fAnonymous = adapterElement.isAnonymous();
        String sNmsPrefix = null;
        String sElement = null;
        if (!fAnonymous) {
            sNmsPrefix = adapterElement.getNamespacePrefix();
            sElement = XmlHelper.getUniversalName(this.getElementName(), sNmsPrefix);
        }
        List list = xml.getElementList();
        for (Object oElement : (Collection)o) {
            XmlElement xmlElement = adapterElement.toXml(oElement);
            if (xmlElement == null) continue;
            if (fAnonymous) {
                List listElement = xmlElement.getElementList();
                int cElements = listElement.size();
                if (cElements == 1) {
                    list.add(listElement.get(0));
                    continue;
                }
                if (cElements <= 1) continue;
                throw new IllegalStateException("Too many elements: " + xmlElement + "\nadapter=" + adapterElement);
            }
            xmlElement.setName(sElement);
            list.add(xmlElement);
        }
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        Collection collection = this.instantiateCollection();
        PropertyAdapter adapter = this.getElementAdapter();
        int c = CollectionAdapter.readInt(in);
        for (int i = 0; i < c; ++i) {
            collection.add(in.readBoolean() ? adapter.readExternal(in) : null);
        }
        return collection;
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        Collection collection = (Collection)o;
        PropertyAdapter adapter = this.getElementAdapter();
        int c = collection.size();
        CollectionAdapter.writeInt(out, c);
        int cActual = 0;
        for (Object oElement : collection) {
            boolean fExists = oElement != null;
            out.writeBoolean(fExists);
            if (fExists) {
                adapter.writeExternal(out, oElement);
            }
            ++cActual;
        }
        if (c != cActual) {
            throw new IOException("expected " + c + " elements, but wrote " + cActual);
        }
    }

    @Override
    public boolean isEmpty(Object o) {
        return o == null || this.isEmptyIsNull() && ((Collection)o).isEmpty();
    }

    public PropertyAdapter getElementAdapter() {
        return this.m_adapterElement;
    }

    protected Collection instantiateCollection() {
        try {
            return (Collection)this.m_clzCollection.newInstance();
        }
        catch (Throwable e) {
            throw CollectionAdapter.ensureRuntimeException(e);
        }
    }
}

