/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Binary;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class SerializableAdapter
extends PropertyAdapter {
    public SerializableAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        SerializableAdapter.azzert(Serializable.class.isAssignableFrom(clzType));
        if (this.isAnonymous()) {
            throw new IllegalStateException("Element for Serializable type cannot be anonymous: " + this);
        }
    }

    @Override
    public boolean isCloneRequired() {
        return true;
    }

    @Override
    public Object clone(Object o) {
        if (o != null && this.isCloneRequired() && this.getCloner() == null) {
            return SerializableAdapter.fromByteArray(SerializableAdapter.toByteArray(o));
        }
        return super.clone(o);
    }

    @Override
    public Object fromXml(XmlElement xml) {
        Binary bin = xml.getBinary();
        if (bin == null || bin.length() == 0) {
            return null;
        }
        return SerializableAdapter.fromBinary(bin);
    }

    @Override
    public XmlElement toXml(Object o) {
        if (o == null) {
            return null;
        }
        return new SimpleElement(this.getXmlName(), SerializableAdapter.toBinary(o));
    }

    @Override
    public Object fromUri(String sUri) {
        return SerializableAdapter.fromByteArray(SerializableAdapter.parseHex(sUri));
    }

    @Override
    public String toUri(Object o) {
        return SerializableAdapter.toHex(SerializableAdapter.toByteArray(o));
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        return SerializableAdapter.readObject(in, this.getBeanInfo().getType().getClassLoader());
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        SerializableAdapter.writeObject(out, o);
    }
}

