/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.NaturalHasher;
import com.tangosol.util.LongArray;
import java.util.Iterator;

public abstract class AbstractLongArray<V>
implements LongArray<V> {
    @Override
    public V get(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            Object value = iter.next();
            return (V)(iter.getIndex() == lIndex ? value : null);
        }
        return null;
    }

    @Override
    public long add(V oValue) {
        long lIndex = this.getLastIndex() + 1L;
        this.set(lIndex, oValue);
        return lIndex;
    }

    @Override
    public boolean exists(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex() == lIndex;
        }
        return false;
    }

    @Override
    public V remove(long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        if (iter.hasNext()) {
            Object value = iter.next();
            if (iter.getIndex() == lIndex) {
                iter.remove();
                return value;
            }
        }
        return null;
    }

    @Override
    public void remove(long lIndexFrom, long lIndexTo) {
        LongArray.Iterator iter = this.iterator(lIndexFrom);
        while (iter.hasNext()) {
            iter.next();
            if (iter.getIndex() >= lIndexTo) break;
            iter.remove();
        }
    }

    @Override
    public boolean contains(V value) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!NaturalHasher.INSTANCE.equals(value, iter.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public int getSize() {
        int cItems = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++cItems;
        }
        return cItems;
    }

    @Override
    public long getFirstIndex() {
        Iterator iter = this.iterator();
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long getLastIndex() {
        LongArray.Iterator iter = this.reverseIterator();
        if (iter.hasNext()) {
            iter.next();
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long indexOf(V oValue) {
        return this.indexOf(oValue, this.getFirstIndex());
    }

    @Override
    public long indexOf(V oValue, long lIndex) {
        LongArray.Iterator iter = this.iterator(lIndex);
        while (iter.hasNext()) {
            if (!NaturalHasher.INSTANCE.equals(oValue, iter.next())) continue;
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(V oValue) {
        return this.lastIndexOf(oValue, this.getLastIndex());
    }

    @Override
    public long lastIndexOf(V oValue, long lIndex) {
        LongArray.Iterator iter = this.reverseIterator(lIndex);
        while (iter.hasNext()) {
            if (!NaturalHasher.INSTANCE.equals(oValue, iter.next())) continue;
            return iter.getIndex();
        }
        return -1L;
    }

    @Override
    public String toString() {
        String sClass = this.getClass().getName();
        sClass = sClass.substring(sClass.lastIndexOf(46) + 1);
        StringBuffer sb = new StringBuffer();
        sb.append(sClass).append('{');
        boolean fFirst = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            Object o = iter.next();
            sb.append('[').append(iter.getIndex()).append("]=").append(o);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LongArray) {
            LongArray that = (LongArray)o;
            if (this.getSize() == that.getSize()) {
                if (this.isEmpty()) {
                    return true;
                }
                Iterator iterThis = this.iterator();
                Iterator iterThat = that.iterator();
                while (iterThis.hasNext() && iterThat.hasNext()) {
                    if (NaturalHasher.INSTANCE.equals(iterThis.next(), iterThat.next()) && iterThis.getIndex() == iterThat.getIndex()) continue;
                    return false;
                }
                return iterThis.hasNext() == iterThat.hasNext();
            }
        }
        return false;
    }

    public int hashCode() {
        int nHash = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            nHash += NaturalHasher.INSTANCE.hashCode(iter.next());
        }
        return nHash;
    }

    @Override
    public AbstractLongArray<V> clone() {
        try {
            return (AbstractLongArray)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

