/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.util.AutoLock;
import com.tangosol.util.LongArray;

public abstract class AbstractSafeLongArray<V>
implements LongArray<V> {
    protected static final Object NO_VALUE = new Object();

    @Override
    public V get(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            V v = sentry.getResource().get(lIndex);
            return v;
        }
    }

    @Override
    public long floorIndex(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().floorIndex(lIndex);
            return l;
        }
    }

    @Override
    public V floor(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            V v = sentry.getResource().floor(lIndex);
            return v;
        }
    }

    @Override
    public long ceilingIndex(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().ceilingIndex(lIndex);
            return l;
        }
    }

    @Override
    public V ceiling(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            V v = sentry.getResource().ceiling(lIndex);
            return v;
        }
    }

    @Override
    public V set(long lIndex, V oValue) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireWriteLock();){
            V v = sentry.getResource().set(lIndex, oValue);
            return v;
        }
    }

    @Override
    public long add(V oValue) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireWriteLock();){
            long l = sentry.getResource().add(oValue);
            return l;
        }
    }

    @Override
    public boolean exists(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            boolean bl = sentry.getResource().exists(lIndex);
            return bl;
        }
    }

    @Override
    public V remove(long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireWriteLock();){
            V v = sentry.getResource().remove(lIndex);
            return v;
        }
    }

    @Override
    public void remove(long lIndexFrom, long lIndexTo) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireWriteLock();){
            sentry.getResource().remove(lIndexFrom, lIndexTo);
        }
    }

    @Override
    public boolean contains(V oValue) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            boolean bl = sentry.getResource().contains(oValue);
            return bl;
        }
    }

    @Override
    public void clear() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireWriteLock();){
            sentry.getResource().clear();
        }
    }

    @Override
    public boolean isEmpty() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            boolean bl = sentry.getResource().isEmpty();
            return bl;
        }
    }

    @Override
    public int getSize() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            int n = sentry.getResource().getSize();
            return n;
        }
    }

    @Override
    public long getFirstIndex() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().getFirstIndex();
            return l;
        }
    }

    @Override
    public long getLastIndex() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().getLastIndex();
            return l;
        }
    }

    @Override
    public long indexOf(V oValue) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().indexOf(oValue);
            return l;
        }
    }

    @Override
    public long indexOf(V oValue, long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().indexOf(oValue, lIndex);
            return l;
        }
    }

    @Override
    public long lastIndexOf(V oValue) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().lastIndexOf(oValue);
            return l;
        }
    }

    @Override
    public long lastIndexOf(V oValue, long lIndex) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            long l = sentry.getResource().lastIndexOf(oValue, lIndex);
            return l;
        }
    }

    @Override
    public LongArray.Iterator<V> iterator() {
        return this.instantiateSafeIterator(true, Long.MIN_VALUE);
    }

    @Override
    public LongArray.Iterator<V> iterator(long lIndex) {
        return this.instantiateSafeIterator(true, lIndex);
    }

    @Override
    public LongArray.Iterator<V> reverseIterator() {
        return this.instantiateSafeIterator(false, Long.MAX_VALUE);
    }

    @Override
    public LongArray.Iterator<V> reverseIterator(long lIndex) {
        return this.instantiateSafeIterator(false, lIndex);
    }

    @Override
    public String toString() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            String string = sentry.getResource().toString();
            return string;
        }
    }

    @Override
    public abstract AbstractSafeLongArray<V> clone();

    protected abstract AutoLock.Sentry<LongArray<V>> acquireReadLock();

    protected abstract AutoLock.Sentry<LongArray<V>> acquireWriteLock();

    protected SafeIterator instantiateSafeIterator(boolean fForward, long lIndexFrom) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            SafeIterator safeIterator = new SafeIterator(sentry.getResource(), fForward, lIndexFrom);
            return safeIterator;
        }
    }

    protected class SafeIterator
    implements LongArray.Iterator<V> {
        protected final LongArray.Iterator<V> f_delegate;
        protected Object m_valueLast = NO_VALUE;
        protected long m_lIndexLast;

        protected SafeIterator(LongArray<V> delegate, boolean fForward, long lIndexFrom) {
            this.f_delegate = fForward ? (lIndexFrom == Long.MIN_VALUE ? delegate.iterator() : delegate.iterator(lIndexFrom)) : (lIndexFrom == Long.MAX_VALUE ? delegate.reverseIterator() : delegate.reverseIterator(lIndexFrom));
        }

        @Override
        public boolean hasNext() {
            try (AutoLock.Sentry sentry = AbstractSafeLongArray.this.acquireReadLock();){
                boolean bl = this.f_delegate.hasNext();
                return bl;
            }
        }

        @Override
        public V next() {
            long lIndex;
            Object value;
            try (AutoLock.Sentry sentry = AbstractSafeLongArray.this.acquireReadLock();){
                value = this.f_delegate.next();
                lIndex = this.f_delegate.getIndex();
            }
            this.m_valueLast = value;
            this.m_lIndexLast = lIndex;
            return value;
        }

        @Override
        public long getIndex() {
            this.ensureValid();
            return this.m_lIndexLast;
        }

        @Override
        public V getValue() {
            this.ensureValid();
            return this.m_valueLast;
        }

        @Override
        public V setValue(V oValue) {
            try (AutoLock.Sentry sentry = AbstractSafeLongArray.this.acquireWriteLock();){
                Object value = this.f_delegate.setValue(oValue);
                this.m_valueLast = oValue;
                Object v = value;
                return v;
            }
        }

        @Override
        public void remove() {
            try (AutoLock.Sentry sentry = AbstractSafeLongArray.this.acquireWriteLock();){
                this.f_delegate.remove();
            }
            this.m_valueLast = NO_VALUE;
        }

        protected void ensureValid() {
            if (this.m_valueLast == NO_VALUE) {
                throw new IllegalStateException("missing call to next()");
            }
        }
    }
}

