/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AbstractScript
implements ExternalizableLite,
PortableObject {
    protected String m_sLanguage;
    protected String m_sName;
    protected Object[] m_aoArgs;

    public AbstractScript() {
    }

    public AbstractScript(String language, String name, Object ... args) {
        this.m_sLanguage = language;
        this.m_sName = name;
        this.m_aoArgs = args;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sLanguage = in.readUTF();
        this.m_sName = in.readUTF();
        int numArgs = in.readInt();
        Base.azzert(numArgs < 256, "Unexpected number of arguments");
        this.m_aoArgs = new Object[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            this.m_aoArgs[i] = ExternalizableHelper.readObject(in);
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.m_sLanguage);
        out.writeUTF(this.m_sName);
        int numArgs = this.m_aoArgs.length;
        out.writeInt(numArgs);
        for (Object arg : this.m_aoArgs) {
            ExternalizableHelper.writeObject(out, arg);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sLanguage = in.readString(0);
        this.m_sName = in.readString(1);
        this.m_aoArgs = in.readArray(2, Object[]::new);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sLanguage);
        out.writeString(1, this.m_sName);
        out.writeObjectArray(2, this.m_aoArgs);
    }
}

