/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.SafeHashMap;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Map;

public class CacheCollator
extends Collator
implements Serializable {
    private Collator collator;
    private transient Map m_cache;

    public CacheCollator(Collator collator) {
        this.collator = (Collator)collator.clone();
    }

    @Override
    public int getStrength() {
        return this.collator.getStrength();
    }

    @Override
    public void setStrength(int newStrength) {
        throw new UnsupportedOperationException("cache collator is immutable");
    }

    @Override
    public int getDecomposition() {
        return this.collator.getDecomposition();
    }

    @Override
    public void setDecomposition(int decomposition) {
        throw new UnsupportedOperationException("cache collator is immutable");
    }

    @Override
    public int compare(String source, String target) {
        return this.getCollationKey(source).compareTo(this.getCollationKey(target));
    }

    @Override
    public CollationKey getCollationKey(String source) {
        if (source == null) {
            return null;
        }
        Map cache = this.getCache();
        CollationKey key = (CollationKey)cache.get(source);
        if (key == null) {
            key = this.collator.getCollationKey(source);
            cache.put(source, key);
        }
        return key;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean equals(Object that) {
        return this.collator.equals(that);
    }

    @Override
    public int hashCode() {
        return this.collator.hashCode();
    }

    protected Map getCache() {
        SafeHashMap cache = this.m_cache;
        if (cache == null) {
            this.m_cache = cache = new SafeHashMap();
        }
        return cache;
    }
}

