/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteMap<K, V>
implements Map<K, V> {
    private volatile Map<K, V> m_mapInternal;
    private KeySet m_setKeys;
    private EntrySet m_setEntries;

    public CopyOnWriteMap(Class clazz) {
        this.setInternalMap(this.instantiateMap(clazz));
    }

    public CopyOnWriteMap(Map<K, V> map) {
        this.setInternalMap(this.copyMap(map));
    }

    protected Map<K, V> getInternalMap() {
        return this.m_mapInternal;
    }

    protected void setInternalMap(Map<K, V> map) {
        this.m_mapInternal = map;
    }

    protected Map<K, V> instantiateMap(Class clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Expected a class assignable from java.util.Map instead of " + clazz.getName());
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Could not create new instance of " + clazz.getName());
        }
    }

    protected Map<K, V> copyMap(Map<K, V> map) {
        Map<K, V> mapNew = this.instantiateMap(map.getClass());
        mapNew.putAll(map);
        return mapNew;
    }

    @Override
    public int size() {
        return this.getInternalMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getInternalMap().containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oValue) {
        return this.getInternalMap().containsValue(oValue);
    }

    @Override
    public V get(Object oKey) {
        return this.getInternalMap().get(oKey);
    }

    @Override
    public synchronized V put(K oKey, V oValue) {
        Map<K, V> mapNew = this.copyMap(this.getInternalMap());
        V oValueOld = mapNew.put(oKey, oValue);
        this.setInternalMap(mapNew);
        return oValueOld;
    }

    @Override
    public synchronized V remove(Object oKey) {
        Map<K, V> mapNew = this.copyMap(this.getInternalMap());
        V oValueOld = mapNew.remove(oKey);
        this.setInternalMap(mapNew);
        return oValueOld;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        Map<? extends K, ? extends V> mapNew = this.copyMap(this.getInternalMap());
        mapNew.putAll(map);
        this.setInternalMap(mapNew);
    }

    @Override
    public synchronized void clear() {
        this.setInternalMap(this.instantiateMap(this.m_mapInternal.getClass()));
    }

    @Override
    public Set<K> keySet() {
        KeySet set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = new KeySet();
        }
        return set;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = new EntrySet();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.getInternalMap().values());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        CopyOnWriteMap that = (CopyOnWriteMap)o;
        return Base.equals(this.m_mapInternal, that.m_mapInternal);
    }

    @Override
    public int hashCode() {
        return this.m_mapInternal == null ? 0 : this.m_mapInternal.hashCode();
    }

    public String toString() {
        return "CopyOnWriteMap{" + this.m_mapInternal + "}";
    }

    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator(){
                private Iterator<Map.Entry<K, V>> m_iter;
                private Map.Entry<K, V> m_entryNext;
                {
                    this.m_iter = CopyOnWriteMap.this.getInternalMap().entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Map.Entry<K, V> next() {
                    this.m_entryNext = this.m_iter.next();
                    return this.m_entryNext;
                }

                @Override
                public void remove() {
                    CopyOnWriteMap.this.remove(this.m_entryNext.getKey());
                    this.m_entryNext = null;
                }
            };
        }

        @Override
        public int size() {
            return CopyOnWriteMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entryThat = (Map.Entry)o;
                Map.Entry entryThis = (Map.Entry)CopyOnWriteMap.this.get(entryThat.getKey());
                return entryThis != null && entryThis.equals(entryThat);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            CopyOnWriteMap map = CopyOnWriteMap.this;
            if (this.contains(o)) {
                map.remove(((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            CopyOnWriteMap.this.clear();
        }
    }

    protected class KeySet
    extends AbstractSet<K> {
        protected KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator(){
                private Iterator<K> m_iter;
                private K m_keyNext;
                {
                    this.m_iter = CopyOnWriteMap.this.getInternalMap().keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public K next() {
                    this.m_keyNext = this.m_iter.next();
                    return this.m_keyNext;
                }

                @Override
                public void remove() {
                    CopyOnWriteMap.this.remove(this.m_keyNext);
                    this.m_keyNext = null;
                }
            };
        }

        @Override
        public int size() {
            return CopyOnWriteMap.this.size();
        }

        @Override
        public boolean contains(Object oKey) {
            return CopyOnWriteMap.this.containsKey(oKey);
        }

        @Override
        public boolean remove(Object o) {
            CopyOnWriteMap map = CopyOnWriteMap.this;
            if (map.containsKey(o)) {
                map.remove(o);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection coll) {
            boolean fRemoved;
            assert (coll != null);
            CopyOnWriteMap copyOnWriteMap = CopyOnWriteMap.this;
            synchronized (copyOnWriteMap) {
                Map mapNew = CopyOnWriteMap.this.copyMap(CopyOnWriteMap.this.getInternalMap());
                fRemoved = mapNew.keySet().removeAll(coll);
                CopyOnWriteMap.this.setInternalMap(mapNew);
            }
            return fRemoved;
        }

        @Override
        public void clear() {
            CopyOnWriteMap.this.clear();
        }
    }
}

