/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;

public abstract class Daemon
extends Base
implements Runnable,
Guardable {
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_STOPPING = 3;
    private String m_sConfiguredName;
    private int m_nConfiguredPriority;
    private ClassLoader m_loaderConfigured;
    private volatile DaemonWorker m_worker;
    private volatile int m_nState;
    private ThreadGroup m_threadGroup;
    private Runnable m_actionGuardRegister;
    private Guardian.GuardContext m_guardContext;

    public Daemon() {
        this(null);
    }

    public Daemon(String sName) {
        this(sName, 5, false);
    }

    public Daemon(String sName, int nPriority, boolean fStart) {
        this.setConfiguredName(sName);
        this.setConfiguredPriority(nPriority);
        if (fStart) {
            this.start();
        }
    }

    @Override
    public abstract void run();

    @Override
    public void setContext(Guardian.GuardContext context) {
        this.m_guardContext = context;
    }

    @Override
    public void recover() {
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    @Override
    public void terminate() {
        this.stop();
    }

    @Override
    public Guardian.GuardContext getContext() {
        return this.m_guardContext;
    }

    public boolean isGuarded() {
        return this.m_guardContext != null;
    }

    public long getMaxWaitMillis(long cDefaultMillis) {
        long cMaxWaitMillis = cDefaultMillis;
        Guardian.GuardContext context = this.getContext();
        if (context != null) {
            long cTimeoutMillis = context.getSoftTimeoutMillis();
            cMaxWaitMillis = Math.min(1000L, Math.max(1L, cTimeoutMillis >> 2));
        }
        return cMaxWaitMillis;
    }

    protected void heartbeat() {
        Guardian.GuardContext context = this.getContext();
        if (context != null) {
            context.heartbeat();
        }
    }

    protected void heartbeat(long cMillis) {
        Guardian.GuardContext context = this.getContext();
        if (context != null) {
            context.heartbeat(cMillis);
        }
    }

    protected void setGuardRegisterAction(Runnable action) {
        this.m_actionGuardRegister = action;
    }

    protected Runnable getGuardRegisterAction() {
        return this.m_actionGuardRegister;
    }

    protected void setGuardPolicy(final Guardian guardian, final long cTimeoutMillis, final float flPctRecover) {
        Guardian.GuardContext ctx = this.getContext();
        if (ctx != null) {
            ctx.release();
        }
        this.setGuardRegisterAction(new Runnable(){

            @Override
            public void run() {
                if (cTimeoutMillis == 0L) {
                    guardian.guard(Daemon.this);
                } else {
                    guardian.guard(Daemon.this, cTimeoutMillis, flPctRecover);
                }
            }
        });
        if (this.isRunning()) {
            this.guardIfNeeded();
        }
    }

    protected void guardIfNeeded() {
        Runnable actionGuard = this.getGuardRegisterAction();
        if (actionGuard != null) {
            actionGuard.run();
        }
    }

    public Thread getThread() {
        DaemonWorker worker = this.getWorker();
        return worker == null ? null : worker.getThread();
    }

    public DaemonWorker getWorker() {
        return this.m_worker;
    }

    public synchronized void start() {
        DaemonWorker worker = this.getWorker();
        if (worker != null && worker.isCurrentThread()) {
            return;
        }
        if (worker != null && !worker.getThread().isAlive()) {
            this.changeState(0, worker);
        }
        this.guardIfNeeded();
        switch (this.getState()) {
            default: {
                worker = this.instantiateWorker();
                this.configureWorker(worker);
                this.changeState(1, worker);
                worker.getThread().start();
            }
            case 1: {
                Daemon.azzert(worker != null);
                this.finishStarting(worker);
                return;
            }
            case 2: {
                return;
            }
            case 3: 
        }
    }

    public boolean isRunning() {
        switch (this.getState()) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
        }
        Thread thread = this.getThread();
        return thread != null && thread.isAlive();
    }

    public synchronized void stop() {
        DaemonWorker worker = this.getWorker();
        if (worker != null && worker.isCurrentThread()) {
            this.changeState(0, worker);
        } else if (!this.isOnWorkerThread()) {
            if (worker != null && !worker.getThread().isAlive()) {
                this.changeState(0, worker);
            } else {
                switch (this.getState()) {
                    case 1: {
                        this.finishStarting(worker);
                        if (this.getState() != 2 || worker != this.getWorker()) {
                            return;
                        }
                    }
                    case 2: {
                        this.changeState(3, worker);
                        return;
                    }
                }
            }
        }
    }

    public synchronized void shutdown(long cWait) {
        if (this.isOnWorkerThread()) {
            throw new IllegalStateException("shutdown cannot be called by a daemon thread");
        }
        this.stop();
        if (this.getState() == 3) {
            this.finishStopping(this.getWorker(), cWait);
        }
    }

    public boolean isStopping() {
        switch (this.getState()) {
            case 3: {
                return true;
            }
            case 0: {
                return this.isOnWorkerThread();
            }
        }
        return false;
    }

    public boolean isOnWorkerThread() {
        return this.m_threadGroup == Thread.currentThread().getThreadGroup();
    }

    protected int getState() {
        return this.m_nState;
    }

    protected void finishStarting(DaemonWorker worker) {
        while (worker == this.getWorker() && worker.getThread().isAlive() && this.getState() == 1) {
            try {
                Blocking.wait(this, 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Daemon.ensureRuntimeException(e);
            }
        }
    }

    protected void finishStopping(DaemonWorker worker, long cWait) {
        long ldtStop;
        long ldtStart;
        long ldtNow = ldtStart = Daemon.getSafeTimeMillis();
        long l = cWait < 0L ? Long.MAX_VALUE : (ldtStop = cWait == 0L ? ldtStart : ldtStart + cWait);
        while (worker == this.getWorker() && worker.getThread().isAlive() && this.getState() == 3) {
            try {
                if (ldtNow >= ldtStop) {
                    return;
                }
                Blocking.wait(this, ldtStop - ldtNow);
                ldtNow = Daemon.getSafeTimeMillis();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Daemon.ensureRuntimeException(e);
            }
        }
    }

    protected synchronized void changeState(int nState, DaemonWorker worker) {
        DaemonWorker workerPrev = this.getWorker();
        switch (nState) {
            case 1: {
                if (workerPrev != null) {
                    Daemon.err("unexpected state: a thread (" + worker + ") is starting while another thread (" + workerPrev + ") still exists");
                }
                this.m_worker = worker;
                this.m_nState = 1;
                break;
            }
            case 2: {
                if (worker != workerPrev) break;
                this.m_nState = 2;
                if (!this.isGuarded()) break;
                GuardSupport.setThreadContext(this.getContext());
                break;
            }
            case 3: {
                if (worker != workerPrev) break;
                worker.notifyStopping();
                this.m_nState = 3;
                break;
            }
            case 0: {
                if (worker != workerPrev) break;
                worker.notifyStopping();
                this.m_worker = null;
                this.m_nState = 0;
                if (!this.isGuarded()) break;
                this.getContext().release();
                GuardSupport.setThreadContext(null);
            }
        }
        this.notifyAll();
    }

    protected void setConfiguredPriority(int nPriority) {
        nPriority = Math.min(nPriority, 10);
        this.m_nConfiguredPriority = nPriority = Math.max(nPriority, 1);
    }

    protected int getConfiguredPriority() {
        return this.m_nConfiguredPriority;
    }

    protected void setConfiguredName(String sName) {
        this.m_sConfiguredName = sName;
    }

    protected String getConfiguredName() {
        return this.m_sConfiguredName;
    }

    public void setThreadContextClassLoader(ClassLoader loader) {
        Thread thread = this.getThread();
        if (thread != null) {
            thread.setContextClassLoader(loader);
        }
        this.m_loaderConfigured = loader;
    }

    public ClassLoader getThreadContextClassLoader() {
        return this.m_loaderConfigured;
    }

    protected DaemonWorker instantiateWorker() {
        return new DaemonWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureWorker(DaemonWorker worker) {
        ClassLoader loader;
        Thread threadWorker;
        ThreadGroup curThreadGroup;
        ThreadGroup threadGroup = curThreadGroup = this.ensureThreadGroup();
        synchronized (threadGroup) {
            if (curThreadGroup.isDestroyed()) {
                this.ensureThreadGroup();
            }
            threadWorker = Daemon.makeThread(this.m_threadGroup, worker, null);
        }
        threadWorker.setDaemon(true);
        threadWorker.setPriority(this.getConfiguredPriority());
        String sName = this.getConfiguredName();
        if (sName != null) {
            threadWorker.setName(sName);
        }
        if ((loader = this.getThreadContextClassLoader()) != null) {
            threadWorker.setContextClassLoader(loader);
        }
        worker.setThread(threadWorker);
    }

    protected ThreadGroup ensureThreadGroup() {
        ThreadGroup threadGroup = this.m_threadGroup;
        if (threadGroup == null || threadGroup.isDestroyed()) {
            threadGroup = this.m_threadGroup = new ThreadGroup(this.getConfiguredName());
            threadGroup.setDaemon(true);
        }
        return threadGroup;
    }

    public String toString() {
        return "Daemon{" + this.getDescription() + '}';
    }

    protected String getDescription() {
        return "Thread=\"" + this.getThread() + '\"' + ", State=" + Daemon.toStateString(this.getState());
    }

    protected static String toStateString(int nState) {
        switch (nState) {
            case 1: {
                return "Starting";
            }
            case 2: {
                return "Running";
            }
            case 3: {
                return "Stopping";
            }
            case 0: {
                return "Stopped";
            }
        }
        return "Unknown";
    }

    public class DaemonWorker
    implements Runnable {
        private volatile boolean m_fStopping;
        private Thread m_thread;

        @Override
        public void run() {
            Daemon daemon = this.getDaemon();
            Base.azzert(daemon != null);
            try {
                daemon.changeState(2, this);
                daemon.run();
            }
            finally {
                daemon.changeState(0, this);
            }
        }

        protected Daemon getDaemon() {
            return Daemon.this;
        }

        protected void notifyStopping() {
            this.m_fStopping = true;
        }

        protected boolean isStopping() {
            return this.m_fStopping;
        }

        protected void setThread(Thread thread) {
            this.m_thread = thread;
        }

        protected Thread getThread() {
            return this.m_thread;
        }

        protected boolean isCurrentThread() {
            return Thread.currentThread() == this.getThread();
        }
    }
}

